/*
 * Decompiled with CFR 0.152.
 */
package com.github.commoble.morered.wire_post;

import com.github.commoble.morered.TileEntityRegistrar;
import com.github.commoble.morered.plate_blocks.PlateBlock;
import com.github.commoble.morered.util.WorldHelper;
import com.github.commoble.morered.wire_post.PostsInChunkCapability;
import com.github.commoble.morered.wire_post.WirePostTileEntity;
import com.github.commoble.morered.wire_post.WireRayTraceSelectionContext;
import com.google.common.collect.ImmutableSet;
import java.util.EnumSet;
import java.util.Set;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunk;
import net.minecraftforge.event.ForgeEventFactory;

public class WirePostBlock
extends Block {
    public static final DirectionProperty DIRECTION_OF_ATTACHMENT = BlockStateProperties.field_208155_H;
    public static final IntegerProperty POWER = BlockStateProperties.field_208136_ak;
    protected static final VoxelShape[] SHAPES_DUNSWE = new VoxelShape[]{VoxelShapes.func_197872_a((VoxelShape)Block.func_208617_a((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)10.0, (double)10.0), (VoxelShape)PlateBlock.SHAPES_BY_DIRECTION[0]), VoxelShapes.func_197872_a((VoxelShape)Block.func_208617_a((double)6.0, (double)16.0, (double)6.0, (double)10.0, (double)6.0, (double)10.0), (VoxelShape)PlateBlock.SHAPES_BY_DIRECTION[1]), VoxelShapes.func_197872_a((VoxelShape)Block.func_208617_a((double)6.0, (double)6.0, (double)0.0, (double)10.0, (double)10.0, (double)10.0), (VoxelShape)PlateBlock.SHAPES_BY_DIRECTION[2]), VoxelShapes.func_197872_a((VoxelShape)Block.func_208617_a((double)6.0, (double)6.0, (double)6.0, (double)10.0, (double)10.0, (double)16.0), (VoxelShape)PlateBlock.SHAPES_BY_DIRECTION[3]), VoxelShapes.func_197872_a((VoxelShape)Block.func_208617_a((double)0.0, (double)6.0, (double)6.0, (double)10.0, (double)10.0, (double)10.0), (VoxelShape)PlateBlock.SHAPES_BY_DIRECTION[4]), VoxelShapes.func_197872_a((VoxelShape)Block.func_208617_a((double)6.0, (double)6.0, (double)6.0, (double)16.0, (double)10.0, (double)10.0), (VoxelShape)PlateBlock.SHAPES_BY_DIRECTION[5])};

    public WirePostBlock(Block.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)DIRECTION_OF_ATTACHMENT, (Comparable)Direction.DOWN)).func_206870_a((IProperty)POWER, (Comparable)Integer.valueOf(0)));
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader reader) {
        return ((TileEntityType)TileEntityRegistrar.REDWIRE_POST.get()).func_200968_a();
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{DIRECTION_OF_ATTACHMENT, POWER});
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        VoxelShape[] shapeTable = context instanceof WireRayTraceSelectionContext && ((WireRayTraceSelectionContext)context).shouldIgnoreBlock(pos) ? PlateBlock.SHAPES_BY_DIRECTION : SHAPES_DUNSWE;
        return shapeTable[state.func_196959_b((IProperty)DIRECTION_OF_ATTACHMENT) ? ((Direction)state.func_177229_b((IProperty)DIRECTION_OF_ATTACHMENT)).ordinal() : 0];
    }

    @Deprecated
    public VoxelShape func_220071_b(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return this.field_196274_w ? state.func_215700_a(worldIn, pos, context) : VoxelShapes.func_197880_a();
    }

    public void func_180633_a(World world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        int newPower;
        int oldPower = (Integer)state.func_177229_b((IProperty)POWER);
        if (oldPower != (newPower = this.getNewPower(state, (IWorld)world, pos))) {
            world.func_180501_a(pos, (BlockState)state.func_206870_a((IProperty)POWER, (Comparable)Integer.valueOf(newPower)), 2);
        }
    }

    @Deprecated
    public void func_220069_a(BlockState state, World world, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        super.func_220069_a(state, world, pos, blockIn, fromPos, isMoving);
        int oldPower = (Integer)state.func_177229_b((IProperty)POWER);
        int newPower = this.getNewPower(state, (IWorld)world, pos);
        if (oldPower != newPower) {
            world.func_180501_a(pos, (BlockState)state.func_206870_a((IProperty)POWER, (Comparable)Integer.valueOf(newPower)), 2);
        }
    }

    @Deprecated
    public void func_220082_b(BlockState state, World world, BlockPos pos, BlockState oldState, boolean isMoving) {
        this.doPostSetOperation(world, pos, Set::add);
        super.func_220082_b(state, world, pos, oldState, isMoving);
        this.notifyNeighbors(world, pos, state);
    }

    @Deprecated
    public void func_196243_a(BlockState state, World world, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.func_177230_c() != newState.func_177230_c()) {
            this.doPostSetOperation(world, pos, Set::remove);
            super.func_196243_a(state, world, pos, newState, isMoving);
        }
        this.notifyNeighbors(world, pos, state);
    }

    public void doPostSetOperation(World world, BlockPos pos, BiConsumer<Set<BlockPos>, BlockPos> consumer) {
        IChunk chunk = world.func_217349_x(pos);
        if (chunk instanceof Chunk) {
            ((Chunk)chunk).getCapability(PostsInChunkCapability.INSTANCE).ifPresent(posts -> consumer.accept(posts.getPositions(), pos));
        }
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        BlockState defaultState = this.func_176223_P();
        World world = context.func_195991_k();
        BlockPos pos = context.func_195995_a();
        BlockState bestState = null;
        for (Direction direction : context.func_196009_e()) {
            BlockState checkState = (BlockState)defaultState.func_206870_a((IProperty)DIRECTION_OF_ATTACHMENT, (Comparable)direction);
            if (checkState == null || !checkState.func_196955_c((IWorldReader)world, pos)) continue;
            bestState = checkState;
            break;
        }
        return bestState != null && world.func_226663_a_(bestState, pos, ISelectionContext.func_216377_a()) ? (BlockState)bestState.func_206870_a((IProperty)POWER, (Comparable)Integer.valueOf(this.getNewPower(bestState, (IWorld)world, pos))) : null;
    }

    public BlockState func_196271_a(BlockState state, Direction facing, BlockState facingState, IWorld world, BlockPos pos, BlockPos facingPos) {
        return (BlockState)state.func_206870_a((IProperty)POWER, (Comparable)Integer.valueOf(this.getNewPower(state, world, pos)));
    }

    @Deprecated
    public BlockState func_185499_a(BlockState state, Rotation rot) {
        return (BlockState)state.func_206870_a((IProperty)DIRECTION_OF_ATTACHMENT, (Comparable)rot.func_185831_a((Direction)state.func_177229_b((IProperty)DIRECTION_OF_ATTACHMENT)));
    }

    @Deprecated
    public BlockState func_185471_a(BlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((Direction)state.func_177229_b((IProperty)DIRECTION_OF_ATTACHMENT)));
    }

    @Deprecated
    public boolean func_149744_f(BlockState state) {
        return true;
    }

    @Deprecated
    public int func_176211_b(BlockState blockState, IBlockReader blockAccess, BlockPos pos, Direction side) {
        return blockState.func_185911_a(blockAccess, pos, side);
    }

    @Deprecated
    public int func_180656_a(BlockState blockState, IBlockReader blockAccess, BlockPos pos, Direction directionOfThisBlockFromCaller) {
        Direction attachment = (Direction)blockState.func_177229_b((IProperty)DIRECTION_OF_ATTACHMENT);
        if (attachment == directionOfThisBlockFromCaller || attachment.func_176734_d() == directionOfThisBlockFromCaller) {
            return 0;
        }
        return (Integer)blockState.func_177229_b((IProperty)POWER);
    }

    public int getNewPower(BlockState state, IWorld world, BlockPos pos) {
        return Math.max(0, Math.max(this.getNeighborPower(state, world, pos), this.getConnectionPower(state, world, pos)) - 1);
    }

    public int getNeighborPower(BlockState state, IWorld world, BlockPos pos) {
        if (world instanceof World) {
            return WirePostBlock.getRedstoneConnectionDirections(state).stream().map(direction -> ((World)world).func_175651_c(pos.func_177972_a(direction), direction)).reduce(0, Math::max);
        }
        return 0;
    }

    public int getConnectionPower(BlockState state, IWorld world, BlockPos pos) {
        return WorldHelper.getTileEntityAt(WirePostTileEntity.class, (IWorldReader)world, pos).map(te -> te.getRemoteConnections()).orElse((Set)ImmutableSet.of()).stream().map(tePos -> world.func_180495_p(tePos)).map(otherState -> otherState.func_196959_b((IProperty)POWER) ? (Integer)otherState.func_177229_b((IProperty)POWER) : Integer.valueOf(0)).reduce(0, Math::max);
    }

    public void notifyNeighbors(World world, BlockPos pos, BlockState state) {
        EnumSet<Direction> neighborDirections = WirePostBlock.getRedstoneConnectionDirections(state);
        if (!ForgeEventFactory.onNeighborNotify((World)world, (BlockPos)pos, (BlockState)world.func_180495_p(pos), neighborDirections, (boolean)false).isCanceled()) {
            for (Direction dir : neighborDirections) {
                BlockPos neighborPos = pos.func_177972_a(dir);
                world.func_190524_a(neighborPos, (Block)this, pos);
                world.func_175695_a(neighborPos, (Block)this, dir);
            }
            WorldHelper.getTileEntityAt(WirePostTileEntity.class, (IWorldReader)world, pos).ifPresent(te -> te.notifyConnections());
        }
    }

    public static EnumSet<Direction> getRedstoneConnectionDirections(BlockState state) {
        if (!state.func_196959_b((IProperty)DIRECTION_OF_ATTACHMENT)) {
            return EnumSet.noneOf(Direction.class);
        }
        Direction attachmentDir = (Direction)state.func_177229_b((IProperty)DIRECTION_OF_ATTACHMENT);
        return EnumSet.complementOf(EnumSet.of(attachmentDir, attachmentDir.func_176734_d()));
    }
}

