/*
 * Decompiled with CFR 0.152.
 */
package com.github.commoble.morered.wire_post;

import com.github.commoble.morered.MoreRed;
import com.github.commoble.morered.TileEntityRegistrar;
import com.github.commoble.morered.util.NBTListHelper;
import com.github.commoble.morered.util.NestedBoundingBox;
import com.github.commoble.morered.util.WorldHelper;
import com.github.commoble.morered.wire_post.SlackInterpolator;
import com.github.commoble.morered.wire_post.WireBreakPacket;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.PacketDistributor;

public class WirePostTileEntity
extends TileEntity {
    public static final String CONNECTIONS = "connections";
    public static final AxisAlignedBB EMPTY_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    private Map<BlockPos, NestedBoundingBox> remoteConnections = new HashMap<BlockPos, NestedBoundingBox>();
    private AxisAlignedBB renderAABB = EMPTY_AABB;
    public static NBTListHelper<BlockPos> BLOCKPOS_LISTER = new NBTListHelper<BlockPos>("connections", pos -> NBTUtil.func_186859_a((BlockPos)pos), nbt -> NBTUtil.func_186861_c((CompoundNBT)nbt));

    public WirePostTileEntity() {
        super((TileEntityType)TileEntityRegistrar.REDWIRE_POST.get());
    }

    public static Optional<WirePostTileEntity> getPost(IWorld world, BlockPos pos) {
        return WorldHelper.getTileEntityAt(WirePostTileEntity.class, (IWorldReader)world, pos);
    }

    public static boolean addConnection(IWorld world, BlockPos posA, BlockPos posB) {
        return WirePostTileEntity.getPost(world, posA).flatMap(postA -> WirePostTileEntity.getPost(world, posB).map(postB -> WirePostTileEntity.addConnection(world, postA, postB))).orElse(false);
    }

    public static boolean addConnection(IWorld world, @Nonnull WirePostTileEntity postA, @Nonnull WirePostTileEntity postB) {
        postA.addConnection(postB.field_174879_c);
        postB.addConnection(postA.field_174879_c);
        return true;
    }

    public Set<BlockPos> getRemoteConnections() {
        return ImmutableSet.copyOf(this.remoteConnections.keySet());
    }

    public boolean hasRemoteConnection(BlockPos otherPos) {
        return this.remoteConnections.keySet().contains(otherPos);
    }

    public void func_145843_s() {
        this.clearRemoteConnections();
        super.func_145843_s();
    }

    public static boolean arePostsConnected(IWorld world, BlockPos posA, BlockPos posB) {
        return WirePostTileEntity.getPost(world, posA).flatMap(postA -> WirePostTileEntity.getPost(world, posB).map(postB -> postA.hasRemoteConnection(posB) && postB.hasRemoteConnection(posA))).orElse(false);
    }

    public void clearRemoteConnections() {
        this.remoteConnections.keySet().forEach(otherPos -> WirePostTileEntity.getPost((IWorld)this.field_145850_b, otherPos).ifPresent(otherPost -> otherPost.removeConnection(this.field_174879_c)));
        this.remoteConnections = new HashMap<BlockPos, NestedBoundingBox>();
        this.onDataUpdated();
    }

    public static void removeConnection(IWorld world, BlockPos posA, BlockPos posB) {
        WirePostTileEntity.getPost(world, posA).ifPresent(post -> post.removeConnection(posB));
        WirePostTileEntity.getPost(world, posB).ifPresent(post -> post.removeConnection(posA));
    }

    private void addConnection(BlockPos otherPos) {
        this.remoteConnections.put(otherPos, this.getNestedBoundingBoxForConnectedPos(otherPos));
        this.field_145850_b.func_190524_a(this.field_174879_c, this.func_195044_w().func_177230_c(), otherPos);
        this.onDataUpdated();
    }

    private void removeConnection(BlockPos otherPos) {
        this.remoteConnections.remove(otherPos);
        this.field_145850_b.func_190524_a(this.field_174879_c, this.func_195044_w().func_177230_c(), otherPos);
        if (!this.field_145850_b.field_72995_K) {
            MoreRed.CHANNEL.send(PacketDistributor.TRACKING_CHUNK.with(() -> this.field_145850_b.func_175726_f(this.field_174879_c)), (Object)new WireBreakPacket(WirePostTileEntity.getConnectionVector(this.field_174879_c), WirePostTileEntity.getConnectionVector(otherPos)));
        }
        this.onDataUpdated();
    }

    public void notifyConnections() {
        this.getRemoteConnections().forEach(connectionPos -> this.field_145850_b.func_190524_a(connectionPos, this.func_195044_w().func_177230_c(), this.field_174879_c));
    }

    public static Vec3d getConnectionVector(BlockPos pos) {
        return new Vec3d((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5);
    }

    @OnlyIn(value=Dist.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return this.renderAABB;
    }

    public static AxisAlignedBB getAABBContainingAllBlockPos(BlockPos startPos, Set<BlockPos> theRest) {
        return theRest.stream().map(AxisAlignedBB::new).reduce(EMPTY_AABB, AxisAlignedBB::func_111270_a, AxisAlignedBB::func_111270_a).func_111270_a(new AxisAlignedBB(startPos));
    }

    public void onDataUpdated() {
        this.func_70296_d();
        this.field_145850_b.func_184138_a(this.field_174879_c, this.func_195044_w(), this.func_195044_w(), 3);
    }

    public void func_145839_a(CompoundNBT compound) {
        super.func_145839_a(compound);
        if (compound.func_74764_b(CONNECTIONS)) {
            List<BlockPos> positions = BLOCKPOS_LISTER.read(compound);
            HashMap<BlockPos, NestedBoundingBox> newMap = new HashMap<BlockPos, NestedBoundingBox>();
            positions.forEach(otherPos -> newMap.put((BlockPos)otherPos, this.getNestedBoundingBoxForConnectedPos((BlockPos)otherPos)));
            this.remoteConnections = newMap;
        }
        this.renderAABB = WirePostTileEntity.getAABBContainingAllBlockPos(this.field_174879_c, this.remoteConnections.keySet());
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        super.func_189515_b(compound);
        BLOCKPOS_LISTER.write(Lists.newArrayList(this.remoteConnections.keySet()), compound);
        return compound;
    }

    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.field_174879_c, 1, this.func_189515_b(new CompoundNBT()));
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        super.onDataPacket(net, pkt);
        this.func_145839_a(pkt.func_148857_g());
    }

    public NestedBoundingBox getNestedBoundingBoxForConnectedPos(BlockPos otherPos) {
        Vec3d thisVec = WirePostTileEntity.getConnectionVector(this.field_174879_c);
        Vec3d otherVec = WirePostTileEntity.getConnectionVector(otherPos);
        boolean otherHigher = otherVec.field_72448_b > thisVec.field_72448_b;
        Vec3d higherVec = otherHigher ? otherVec : thisVec;
        Vec3d lowerVec = otherHigher ? thisVec : otherVec;
        Vec3d[] points = SlackInterpolator.getInterpolatedPoints(lowerVec, higherVec);
        int segmentCount = points.length - 1;
        AxisAlignedBB[] boxes = new AxisAlignedBB[segmentCount];
        for (int i = 0; i < segmentCount; ++i) {
            boxes[i] = new AxisAlignedBB(points[i], points[i + 1]);
        }
        return NestedBoundingBox.fromAABBs(boxes);
    }

    @Nullable
    public Vec3d doesBlockStateIntersectConnection(BlockPos placePos, BlockState placeState, Set<BlockPos> checkedPostPositions) {
        for (Map.Entry<BlockPos, NestedBoundingBox> entry : this.remoteConnections.entrySet()) {
            Vec3d hit;
            BlockPos pos = entry.getKey();
            if (checkedPostPositions.contains(pos) || (hit = WirePostTileEntity.doesBlockStateIntersectConnection(this.field_174879_c, pos, placePos, placeState, entry.getValue(), this.func_145831_w())) == null) continue;
            return hit;
        }
        return null;
    }

    @Nullable
    public static Vec3d doesBlockStateIntersectConnection(BlockPos startPos, BlockPos endPos, BlockPos placePos, BlockState placeState, NestedBoundingBox box, World world) {
        VoxelShape shape = placeState.func_196952_d((IBlockReader)world, placePos);
        for (AxisAlignedBB aabb : shape.func_197756_d()) {
            if (!box.intersects(aabb.func_186670_a(placePos))) continue;
            boolean lastPosIsHigher = startPos.func_177956_o() < endPos.func_177956_o();
            BlockPos upperPos = lastPosIsHigher ? endPos : startPos;
            BlockPos lowerPos = lastPosIsHigher ? startPos : endPos;
            return SlackInterpolator.getWireRaytraceHit(lowerPos, upperPos, world);
        }
        return null;
    }
}

