/*
 * Decompiled with CFR 0.152.
 */
package com.github.commoble.morered.wire_post;

import com.github.commoble.morered.MoreRed;
import com.github.commoble.morered.ServerConfig;
import com.github.commoble.morered.TileEntityRegistrar;
import com.github.commoble.morered.wire_post.SlackInterpolator;
import com.github.commoble.morered.wire_post.WireBreakPacket;
import com.github.commoble.morered.wire_post.WirePostTileEntity;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.RedstoneParticleData;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.network.PacketDistributor;

public class WireSpoolItem
extends Item {
    public static final String LAST_POST_POS = "last_post_pos";

    public WireSpoolItem(Item.Properties properties) {
        super(properties);
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        World world = context.func_195991_k();
        BlockPos pos = context.func_195995_a();
        return WirePostTileEntity.getPost((IWorld)world, pos).map(post -> this.onUseOnPost(world, pos, (WirePostTileEntity)((Object)post), context.func_195996_i(), context.func_195999_j())).orElseGet(() -> super.func_195939_a(context));
    }

    private ActionResultType onUseOnPost(World world, BlockPos pos, @Nonnull WirePostTileEntity post, ItemStack stack, PlayerEntity player) {
        if (!world.field_72995_K) {
            CompoundNBT nbt = stack.func_179543_a(LAST_POST_POS);
            if (nbt == null) {
                stack.func_77983_a(LAST_POST_POS, (INBT)NBTUtil.func_186859_a((BlockPos)pos));
            } else {
                BlockPos lastPos = NBTUtil.func_186861_c((CompoundNBT)nbt);
                if (lastPos.equals((Object)pos)) {
                    stack.func_196083_e(LAST_POST_POS);
                } else if (post.hasRemoteConnection(lastPos)) {
                    WirePostTileEntity.removeConnection((IWorld)world, pos, lastPos);
                    stack.func_196083_e(LAST_POST_POS);
                } else {
                    BlockPos upperPos;
                    boolean lastPosIsHigher = pos.func_177956_o() < lastPos.func_177956_o();
                    BlockPos lowerPos = lastPosIsHigher ? pos : lastPos;
                    Vec3d hit = SlackInterpolator.getWireRaytraceHit(lowerPos, upperPos = lastPosIsHigher ? lastPos : pos, world);
                    if (hit != null) {
                        stack.func_196083_e(LAST_POST_POS);
                        if (player instanceof ServerPlayerEntity && world instanceof ServerWorld) {
                            MoreRed.CHANNEL.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)player), (Object)new WireBreakPacket(WirePostTileEntity.getConnectionVector(lowerPos), WirePostTileEntity.getConnectionVector(upperPos)));
                            ((ServerWorld)world).func_195600_a((ServerPlayerEntity)player, (IParticleData)RedstoneParticleData.field_197564_a, false, hit.field_72450_a, hit.field_72448_b, hit.field_72449_c, 5, 0.05, 0.05, 0.05, 0.0);
                            ((ServerPlayerEntity)player).func_213823_a(SoundEvents.field_219713_mY, SoundCategory.BLOCKS, 0.5f, 2.0f);
                        }
                    } else if (pos.func_218141_a((Vec3i)lastPos, ServerConfig.INSTANCE.max_wire_post_connection_range.get().doubleValue())) {
                        stack.func_196083_e(LAST_POST_POS);
                        WirePostTileEntity.getPost((IWorld)world, lastPos).ifPresent(lastPost -> WirePostTileEntity.addConnection((IWorld)world, post, lastPost));
                        stack.func_222118_a(1, (LivingEntity)player, thePlayer -> thePlayer.func_213361_c(EquipmentSlotType.MAINHAND));
                    } else {
                        stack.func_77983_a(LAST_POST_POS, (INBT)NBTUtil.func_186859_a((BlockPos)pos));
                    }
                }
            }
            world.func_184133_a(null, pos, SoundEvents.field_187839_fV, SoundCategory.BLOCKS, 0.2f + world.field_73012_v.nextFloat() * 0.1f, 0.7f + world.field_73012_v.nextFloat() * 0.1f);
        }
        return ActionResultType.SUCCESS;
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        super.func_77663_a(stack, worldIn, entityIn, itemSlot, isSelected);
        if (!worldIn.field_72995_K) {
            Optional.ofNullable(stack.func_179543_a(LAST_POST_POS)).map(nbt -> NBTUtil.func_186861_c((CompoundNBT)nbt)).filter(pos -> WireSpoolItem.shouldRemoveConnection(pos, worldIn, entityIn)).ifPresent(pos -> WireSpoolItem.breakPendingConnection(stack, pos, entityIn, worldIn));
        }
    }

    public static boolean shouldRemoveConnection(BlockPos connectionPos, World world, Entity holder) {
        double maxDistance = ServerConfig.INSTANCE.max_wire_post_connection_range.get();
        Vec3d vec3d = new Vec3d((Vec3i)connectionPos);
        if (holder.func_213303_ch().func_72436_e(vec3d.func_72441_c(0.5, 0.5, 0.5)) > maxDistance * maxDistance) {
            return true;
        }
        TileEntity te = world.func_175625_s(connectionPos);
        return te == null || te.func_200662_C() != TileEntityRegistrar.REDWIRE_POST.get();
    }

    public static void breakPendingConnection(ItemStack stack, BlockPos connectingPos, Entity holder, World world) {
        stack.func_196083_e(LAST_POST_POS);
        if (holder instanceof ServerPlayerEntity) {
            MoreRed.CHANNEL.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)holder), (Object)new WireBreakPacket(WirePostTileEntity.getConnectionVector(connectingPos), new Vec3d(holder.func_226277_ct_(), holder.func_226280_cw_(), holder.func_226281_cx_())));
        }
    }
}

