/*
 * Decompiled with CFR 0.152.
 */
package mrp_v2.morewires.block;

import java.awt.Color;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Random;
import javax.annotation.Nullable;
import mrp_v2.morewires.item.AdjustedRedstoneItem;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.RedstoneWireBlock;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.state.Property;
import net.minecraft.state.properties.RedstoneSide;
import net.minecraft.tags.ITag;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import org.apache.commons.lang3.tuple.Pair;

public class AdjustedRedstoneWireBlock
extends RedstoneWireBlock {
    private static final HashMap<AdjustedRedstoneWireBlock, HashMap<Integer, Pair<Integer, Vector3f>>> blockAndStrengthToColorMap = new HashMap();
    private static final HashSet<Block> redstoneWires = new HashSet();
    protected static boolean globalCanProvidePower = true;

    public AdjustedRedstoneWireBlock(float hueChange) {
        this(AbstractBlock.Properties.func_200950_a((AbstractBlock)Blocks.field_150488_af), hueChange);
    }

    protected AdjustedRedstoneWireBlock(AbstractBlock.Properties properties, float hueChange) {
        super(properties);
        redstoneWires.add((Block)this);
        blockAndStrengthToColorMap.put(this, AdjustedRedstoneWireBlock.calculateColors(hueChange));
    }

    protected static HashMap<Integer, Pair<Integer, Vector3f>> calculateColors(float hueChange) {
        while (hueChange > 1.0f) {
            hueChange -= 1.0f;
        }
        while (hueChange < 0.0f) {
            hueChange += 1.0f;
        }
        HashMap<Integer, Pair<Integer, Vector3f>> colors = new HashMap<Integer, Pair<Integer, Vector3f>>();
        for (int i = 0; i <= 15; ++i) {
            Vector3f RGBColorVecF = RedstoneWireBlock.field_235542_k_[i];
            Vector3i RGBColorVecI = new Vector3i((double)(RGBColorVecF.func_195899_a() * 255.0f), (double)(RGBColorVecF.func_195900_b() * 255.0f), (double)(RGBColorVecF.func_195902_c() * 255.0f));
            float[] hsb = Color.RGBtoHSB(RGBColorVecI.func_177958_n(), RGBColorVecI.func_177956_o(), RGBColorVecI.func_177952_p(), null);
            hsb[0] = hsb[0] + hueChange;
            if (hsb[0] > 1.0f) {
                hsb[0] = hsb[0] - 1.0f;
            }
            int color = Color.HSBtoRGB(hsb[0], hsb[1], hsb[2]);
            Vector3f colorVec = new Vector3f((float)(color >> 16 & 0xFF) / 255.0f, (float)(color >> 8 & 0xFF) / 255.0f, (float)(color & 0xFF) / 255.0f);
            colors.put(i, (Pair<Integer, Vector3f>)Pair.of((Object)color, (Object)colorVec));
        }
        return colors;
    }

    public static int getColor(BlockState state) {
        return (Integer)blockAndStrengthToColorMap.get(state.func_177230_c()).get(state.func_177229_b((Property)field_176351_O)).getLeft();
    }

    protected boolean isWireBlock(BlockState state) {
        return this.isWireBlock(state.func_177230_c());
    }

    protected boolean isWireBlock(Block block) {
        return redstoneWires.contains(block);
    }

    public AdjustedRedstoneItem createBlockItem(ITag<Item> dyeTag) {
        return new AdjustedRedstoneItem((Block)this, new Item.Properties().func_200916_a(ItemGroup.field_78028_d), dyeTag);
    }

    protected RedstoneSide func_235545_a_(IBlockReader reader, BlockPos pos, Direction direction, boolean nonNormalCubeAbove) {
        boolean canPlaceOnTopOfOffset;
        BlockPos offsetPos = pos.func_177972_a(direction);
        BlockState offsetState = reader.func_180495_p(offsetPos);
        if (nonNormalCubeAbove && (canPlaceOnTopOfOffset = this.func_235552_b_(reader, offsetPos, offsetState)) && this.canThisConnectTo(reader.func_180495_p(offsetPos.func_177984_a()), reader, offsetPos.func_177984_a(), null)) {
            if (offsetState.func_224755_d(reader, offsetPos, direction.func_176734_d())) {
                return RedstoneSide.UP;
            }
            return RedstoneSide.SIDE;
        }
        return !this.canThisConnectTo(offsetState, reader, offsetPos, direction) && (offsetState.func_215686_e(reader, offsetPos) || !this.canThisConnectTo(reader.func_180495_p(offsetPos.func_177977_b()), reader, offsetPos.func_177977_b(), null)) ? RedstoneSide.NONE : RedstoneSide.SIDE;
    }

    protected int func_235546_a_(World world, BlockPos pos) {
        globalCanProvidePower = false;
        int i = world.func_175687_A(pos);
        globalCanProvidePower = true;
        int j = 0;
        if (i < 15) {
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                BlockPos offsetPos = pos.func_177972_a(direction);
                BlockState offsetState = world.func_180495_p(offsetPos);
                j = Math.max(j, this.func_235557_o_(offsetState));
                BlockPos upPos = pos.func_177984_a();
                if (offsetState.func_215686_e((IBlockReader)world, offsetPos) && !world.func_180495_p(upPos).func_215686_e((IBlockReader)world, upPos)) {
                    j = Math.max(j, this.func_235557_o_(world.func_180495_p(offsetPos.func_177984_a())));
                    continue;
                }
                if (offsetState.func_215686_e((IBlockReader)world, offsetPos)) continue;
                j = Math.max(j, this.func_235557_o_(world.func_180495_p(offsetPos.func_177977_b())));
            }
        }
        return Math.max(i, j - 1);
    }

    public int func_176211_b(BlockState blockState, IBlockReader blockAccess, BlockPos pos, Direction side) {
        return !globalCanProvidePower ? 0 : blockState.func_185911_a(blockAccess, pos, side);
    }

    public int func_180656_a(BlockState blockState, IBlockReader blockAccess, BlockPos pos, Direction side) {
        if (globalCanProvidePower && side != Direction.DOWN) {
            int i = (Integer)blockState.func_177229_b((Property)field_176351_O);
            if (i == 0) {
                return 0;
            }
            return side != Direction.UP && !((RedstoneSide)this.func_235544_a_(blockAccess, blockState, pos).func_177229_b((Property)field_196498_A.get(side.func_176734_d()))).func_235921_b_() ? 0 : i;
        }
        return 0;
    }

    public boolean func_149744_f(BlockState state) {
        return globalCanProvidePower;
    }

    public void func_180655_c(BlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        int i = (Integer)stateIn.func_177229_b((Property)field_176351_O);
        if (i != 0) {
            block4: for (Direction direction : Direction.Plane.HORIZONTAL) {
                RedstoneSide redstoneside = (RedstoneSide)stateIn.func_177229_b((Property)field_196498_A.get(direction));
                switch (redstoneside) {
                    case UP: {
                        this.func_235549_a_(worldIn, rand, pos, (Vector3f)blockAndStrengthToColorMap.get((Object)this).get(i).getRight(), direction, Direction.UP, -0.5f, 0.5f);
                    }
                    case SIDE: {
                        this.func_235549_a_(worldIn, rand, pos, (Vector3f)blockAndStrengthToColorMap.get((Object)this).get(i).getRight(), Direction.DOWN, direction, 0.0f, 0.5f);
                        continue block4;
                    }
                }
                this.func_235549_a_(worldIn, rand, pos, (Vector3f)blockAndStrengthToColorMap.get((Object)this).get(i).getRight(), Direction.DOWN, direction, 0.0f, 0.3f);
            }
        }
    }

    protected boolean canThisConnectTo(BlockState blockState, IBlockReader world, BlockPos pos, @Nullable Direction side) {
        if (blockState.func_203425_a((Block)this)) {
            return true;
        }
        if (redstoneWires.contains(blockState.func_177230_c())) {
            return false;
        }
        return RedstoneWireBlock.canConnectTo((BlockState)blockState, (IBlockReader)world, (BlockPos)pos, (Direction)side);
    }
}

