/*
 * Decompiled with CFR 0.152.
 */
package mrp_v2.morewires.block;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import mrp_v2.morewires.block.AdjustedRedstoneWireBlock;
import mrp_v2.morewires.block.util.InfiniwireChainParent;
import mrp_v2.morewires.block.util.InfiniwireGraphBuilder;
import mrp_v2.morewires.item.InfiniwireItem;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.state.Property;
import net.minecraft.tags.ITag;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public class InfiniwireBlock
extends AdjustedRedstoneWireBlock {
    private boolean doingUpdate = false;

    public InfiniwireBlock(float hueChange) {
        super(AbstractBlock.Properties.func_200950_a((AbstractBlock)Blocks.field_150488_af), hueChange);
    }

    @Override
    public InfiniwireItem createBlockItem(ITag<Item> dyeTag) {
        return new InfiniwireItem((Block)this, new Item.Properties().func_200916_a(ItemGroup.field_78028_d), dyeTag);
    }

    public void func_220082_b(BlockState state, World worldIn, BlockPos pos, BlockState oldState, boolean isMoving) {
        if (oldState.func_203425_a(state.func_177230_c()) || worldIn.field_72995_K) {
            return;
        }
        int test = this.getStrongestNonWireSignal(worldIn, pos);
        int neighborTest = this.getNeighborEquivalency(worldIn, pos);
        if (neighborTest == -2) {
            if (test != 0) {
                worldIn.func_175656_a(pos, (BlockState)state.func_206870_a((Property)field_176351_O, (Comparable)Integer.valueOf(test)));
                this.updateRelevantNeighbors(worldIn, pos);
            }
        } else if (neighborTest == -1) {
            this.updateChain(worldIn, pos);
        } else if (neighborTest >= test) {
            worldIn.func_175656_a(pos, (BlockState)state.func_206870_a((Property)field_176351_O, (Comparable)Integer.valueOf(neighborTest)));
            this.updateRelevantNeighbors(worldIn, pos);
        } else {
            this.updateChain(worldIn, pos);
        }
    }

    public static HashSet<BlockPos> updateInfiniwireChain(World world, Map<BlockPos, BlockState> chain, int strength) {
        HashSet<BlockPos> updatedBlocks = new HashSet<BlockPos>();
        for (Map.Entry<BlockPos, BlockState> entry : chain.entrySet()) {
            if (strength == (Integer)entry.getValue().func_177229_b((Property)field_176351_O)) continue;
            world.func_180501_a(entry.getKey(), (BlockState)entry.getValue().func_206870_a((Property)field_176351_O, (Comparable)Integer.valueOf(strength)), 2);
            updatedBlocks.add(entry.getKey());
        }
        return updatedBlocks;
    }

    public void func_220069_a(BlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        if (worldIn.field_72995_K) {
            return;
        }
        if (state.func_196955_c((IWorldReader)worldIn, pos)) {
            BlockState neighborState = worldIn.func_180495_p(fromPos);
            if (this.isWireBlock(neighborState) || this.isWireBlock(blockIn)) {
                return;
            }
            this.updateChain(worldIn, pos);
        } else {
            InfiniwireBlock.func_220075_c((BlockState)state, (World)worldIn, (BlockPos)pos);
            worldIn.func_217377_a(pos, false);
        }
    }

    private int getStrongestNonWireSignal(World world, BlockPos pos) {
        globalCanProvidePower = false;
        int strongest = world.func_175687_A(pos);
        globalCanProvidePower = true;
        return strongest;
    }

    public static int getStrongestNonWireSignal(World world, Set<BlockPos> chain) {
        int strongest = 0;
        globalCanProvidePower = false;
        for (BlockPos pos : chain) {
            int test = world.func_175687_A(pos);
            if (test <= strongest) continue;
            strongest = test;
        }
        globalCanProvidePower = true;
        return strongest;
    }

    private int getNeighborEquivalency(World world, BlockPos pos) {
        int foundPower = -2;
        for (Map.Entry<BlockPos, BlockState> neighbor : this.getConnectedWireNeighbors(world, pos).entrySet()) {
            int neighborPower = (Integer)neighbor.getValue().func_177229_b((Property)field_176351_O);
            if (foundPower == -2) {
                foundPower = neighborPower;
                continue;
            }
            if (neighborPower == foundPower) continue;
            return -1;
        }
        return foundPower;
    }

    private Map<BlockPos, BlockState> getConnectedWireNeighbors(World world, BlockPos pos) {
        HashMap<BlockPos, BlockState> relevantWireNeighbors = new HashMap<BlockPos, BlockState>();
        BlockPos thisUp = pos.func_177984_a();
        BlockState thisUpState = world.func_180495_p(thisUp);
        boolean thisUpIsNormalCube = thisUpState.func_215686_e((IBlockReader)world, thisUp);
        for (Direction horizontalDirection : Direction.Plane.HORIZONTAL) {
            BlockPos neighborDown;
            BlockState neighborDownState;
            BlockPos neighborUp;
            BlockState neighborUpState;
            BlockPos neighborPos = pos.func_177972_a(horizontalDirection);
            BlockState neighborState = world.func_180495_p(neighborPos);
            if (neighborState.func_203425_a((Block)this)) {
                relevantWireNeighbors.put(neighborPos, neighborState);
                continue;
            }
            boolean neighborIsNormalCube = neighborState.func_215686_e((IBlockReader)world, neighborPos);
            if (!thisUpIsNormalCube && (neighborUpState = world.func_180495_p(neighborUp = neighborPos.func_177984_a())).func_203425_a((Block)this)) {
                relevantWireNeighbors.put(neighborUp, neighborUpState);
                continue;
            }
            if (neighborIsNormalCube || !(neighborDownState = world.func_180495_p(neighborDown = neighborPos.func_177977_b())).func_203425_a((Block)this)) continue;
            relevantWireNeighbors.put(neighborDown, neighborDownState);
        }
        return relevantWireNeighbors;
    }

    private void updateRelevantNeighbors(World world, BlockPos pos) {
        for (BlockPos updatePos : this.getRelevantUpdateNeighbors(pos)) {
            world.func_195593_d(updatePos, (Block)this);
        }
    }

    private HashSet<BlockPos> getRelevantUpdateNeighbors(BlockPos pos) {
        HashSet<BlockPos> relevantNeighbors = new HashSet<BlockPos>();
        relevantNeighbors.add(pos);
        for (Direction direction : Direction.values()) {
            relevantNeighbors.add(pos.func_177972_a(direction));
        }
        return relevantNeighbors;
    }

    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.func_203425_a(newState.func_177230_c()) || isMoving) {
            return;
        }
        if (!(!state.hasTileEntity() || state.func_203425_a(newState.func_177230_c()) && newState.hasTileEntity())) {
            worldIn.func_175713_t(pos);
        }
        if (worldIn.field_72995_K) {
            return;
        }
        if (newState.func_203425_a((Block)this) || !state.func_203425_a((Block)this)) {
            return;
        }
        if ((Integer)state.func_177229_b((Property)field_176351_O) == 0) {
            this.updateRelevantNeighbors(worldIn, pos);
            return;
        }
        HashMap<InfiniwireChainParent, BlockPos> neighborChains = new HashMap<InfiniwireChainParent, BlockPos>();
        block0: for (BlockPos neighborPos : this.getConnectedWireNeighbors(worldIn, pos).keySet()) {
            for (InfiniwireChainParent chain : neighborChains.keySet()) {
                if (!chain.containsPos(neighborPos)) continue;
                continue block0;
            }
            neighborChains.put(this.getBlocksInChain(worldIn, neighborPos).build(), neighborPos);
        }
        if (neighborChains.size() > 1) {
            for (InfiniwireChainParent wireGraph : neighborChains.keySet()) {
                this.updateChain((BlockPos)neighborChains.get(wireGraph), worldIn, wireGraph);
            }
        } else if (this.getStrongestNonWireSignal(worldIn, pos) == ((Integer)state.func_177229_b((Property)field_176351_O)).intValue()) {
            for (InfiniwireChainParent wireGraph : neighborChains.keySet()) {
                this.updateChain((BlockPos)neighborChains.get(wireGraph), worldIn, wireGraph);
            }
        }
        this.updateRelevantNeighbors(worldIn, pos);
    }

    private InfiniwireGraphBuilder getBlocksInChain(World world, BlockPos pos) {
        BlockState state = world.func_180495_p(pos);
        InfiniwireGraphBuilder wireGraph = new InfiniwireGraphBuilder(pos, state, this);
        if (state.func_203425_a((Block)this)) {
            this.getBlocksInChain(world, pos, wireGraph, new HashSet<BlockPos>());
        }
        return wireGraph;
    }

    private void updateChain(BlockPos updateOrigin, World world, InfiniwireChainParent chain) {
        if (this.doingUpdate) {
            return;
        }
        this.doingUpdate = true;
        chain.update(updateOrigin, world);
        this.doingUpdate = false;
    }

    public void updateNeighbors(World world, HashSet<BlockPos> updatedBlocks) {
        HashSet<BlockPos> toUpdate = new HashSet<BlockPos>();
        for (BlockPos pos : updatedBlocks) {
            toUpdate.addAll(this.getRelevantUpdateNeighbors(pos));
        }
        for (BlockPos updatePos : toUpdate) {
            world.func_195593_d(updatePos, (Block)this);
        }
    }

    private void updateChain(World world, BlockPos pos) {
        if (this.doingUpdate) {
            return;
        }
        this.updateChain(pos, world, this.getBlocksInChain(world, pos).build());
    }

    private void getBlocksInChain(World world, BlockPos pos, InfiniwireGraphBuilder wireGraph, Set<BlockPos> checkedPositions) {
        checkedPositions.add(pos);
        for (BlockPos relevantNeighbor : this.getConnectedWireNeighbors(world, pos, wireGraph)) {
            if (checkedPositions.contains(relevantNeighbor)) continue;
            this.getBlocksInChain(world, relevantNeighbor, wireGraph, checkedPositions);
        }
    }

    private Set<BlockPos> getConnectedWireNeighbors(World world, BlockPos pos, InfiniwireGraphBuilder wireGraph) {
        HashSet<BlockPos> relevantWireNeighbors = new HashSet<BlockPos>();
        BlockPos thisUp = pos.func_177984_a();
        BlockPos thisDown = pos.func_177977_b();
        BlockState thisState = world.func_180495_p(pos);
        BlockState thisUpState = world.func_180495_p(thisUp);
        BlockState thisDownState = world.func_180495_p(thisDown);
        boolean thisUpIsNormalCube = thisUpState.func_215686_e((IBlockReader)world, thisUp);
        boolean thisDownIsNormalCube = thisDownState.func_215686_e((IBlockReader)world, thisDown);
        for (Direction horizontalDirection : Direction.Plane.HORIZONTAL) {
            BlockPos neighborDown;
            BlockState neighborDownState;
            InfiniwireGraphBuilder.ConnectionType connectionType;
            BlockPos neighborUp;
            BlockState neighborUpState;
            BlockPos neighborPos = pos.func_177972_a(horizontalDirection);
            BlockState neighborState = world.func_180495_p(neighborPos);
            if (neighborState.func_203425_a((Block)this)) {
                relevantWireNeighbors.add(neighborPos);
                wireGraph.addNewConnection(pos, thisState, neighborPos, neighborState, InfiniwireGraphBuilder.ConnectionType.BIDIRECTIONAL);
                continue;
            }
            boolean neighborIsNormalCube = neighborState.func_215686_e((IBlockReader)world, neighborPos);
            if (!thisUpIsNormalCube && (neighborUpState = world.func_180495_p(neighborUp = neighborPos.func_177984_a())).func_203425_a((Block)this)) {
                connectionType = neighborIsNormalCube ? InfiniwireGraphBuilder.ConnectionType.BIDIRECTIONAL : InfiniwireGraphBuilder.ConnectionType.A_TO_B;
                relevantWireNeighbors.add(neighborUp);
                wireGraph.addNewConnection(pos, thisState, neighborUp, neighborUpState, connectionType);
            }
            if (neighborIsNormalCube || !(neighborDownState = world.func_180495_p(neighborDown = neighborPos.func_177977_b())).func_203425_a((Block)this)) continue;
            connectionType = thisDownIsNormalCube ? InfiniwireGraphBuilder.ConnectionType.BIDIRECTIONAL : InfiniwireGraphBuilder.ConnectionType.B_TO_A;
            relevantWireNeighbors.add(neighborDown);
            wireGraph.addNewConnection(pos, thisState, neighborDown, neighborDownState, connectionType);
        }
        return relevantWireNeighbors;
    }
}

