/*
 * Decompiled with CFR 0.152.
 */
package mrp_v2.morewires.block.util;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import mrp_v2.morewires.block.InfiniwireBlock;
import net.minecraft.block.BlockState;
import net.minecraft.state.Property;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class InfiniwireChain {
    final Map<BlockPos, BlockState> positions = new HashMap<BlockPos, BlockState>();
    final Set<InfiniwireChain> chainsPoweredBy = new HashSet<InfiniwireChain>();
    final Set<InfiniwireChain> chainsPowering = new HashSet<InfiniwireChain>();
    final InfiniwireBlock block;

    public InfiniwireChain(InfiniwireBlock block) {
        this.block = block;
    }

    void update(World world) {
        int powerFromChains = this.getPowerFromRelevantChains();
        int powerFromWorld = this.getUpdatedBlockPower(world);
        BlockState state = this.getBlockState();
        int oldPower = this.getPower(state);
        int newPower = Math.max(powerFromChains, powerFromWorld);
        this.update(oldPower, newPower, world);
    }

    void update(int oldPower, int newPower, World world) {
        if (newPower != oldPower) {
            this.block.updateNeighbors(world, InfiniwireBlock.updateInfiniwireChain(world, this.positions, newPower));
            this.positions.keySet().forEach(pos1 -> this.positions.computeIfPresent((BlockPos)pos1, (pos2, state) -> world.func_180495_p(pos2)));
            for (InfiniwireChain chain : this.chainsPowering) {
                int chainPower = chain.getPower();
                if (chainPower < newPower) {
                    chain.update(chainPower, newPower, world);
                    continue;
                }
                if (chainPower != oldPower) continue;
                chain.update(world);
            }
        }
    }

    int getPower() {
        return this.getPower(this.getBlockState());
    }

    BlockState getBlockState() {
        return this.positions.values().stream().findFirst().get();
    }

    int getPower(BlockState state) {
        return (Integer)state.func_177229_b((Property)InfiniwireBlock.field_176351_O);
    }

    int getPowerFromRelevantChains() {
        int power = 0;
        for (InfiniwireChain chain : this.chainsPoweredBy) {
            power = Math.max(power, chain.getPower());
        }
        return power;
    }

    int getUpdatedBlockPower(World world) {
        return InfiniwireBlock.getStrongestNonWireSignal(world, this.positions.keySet());
    }
}

