/*
 * Decompiled with CFR 0.152.
 */
package mrp_v2.morewires.block.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import mrp_v2.morewires.block.InfiniwireBlock;
import mrp_v2.morewires.block.util.InfiniwireChain;
import mrp_v2.morewires.block.util.InfiniwireChainParent;
import net.minecraft.block.BlockState;
import net.minecraft.util.math.BlockPos;

public class InfiniwireGraphBuilder {
    protected final Map<BlockPos, BlockState> blockMap = new HashMap<BlockPos, BlockState>();
    protected final Map<BlockPos, List<Connection>> connectionMap = new HashMap<BlockPos, List<Connection>>();
    protected final Set<Connection> connectionSet = new HashSet<Connection>();
    protected final BlockPos originPos;
    protected final BlockState originState;
    protected final InfiniwireBlock block;

    public InfiniwireGraphBuilder(BlockPos originPos, BlockState originState, InfiniwireBlock block) {
        this.originPos = originPos;
        this.originState = originState;
        this.block = block;
    }

    protected List<Connection> getOrCreateConnectionList(BlockPos pos) {
        if (this.connectionMap.containsKey(pos)) {
            return this.connectionMap.get(pos);
        }
        ArrayList<Connection> list = new ArrayList<Connection>();
        this.connectionMap.put(pos, list);
        return list;
    }

    public InfiniwireChainParent build() {
        HashSet<InfiniwireChain> chains = new HashSet<InfiniwireChain>();
        for (Connection connection : this.connectionSet) {
            InfiniwireChain a = null;
            InfiniwireChain b = null;
            for (InfiniwireChain chain : chains) {
                if (chain.positions.containsKey(connection.a)) {
                    a = chain;
                }
                if (!chain.positions.containsKey(connection.b)) continue;
                b = chain;
            }
            if (a != null && a == b) continue;
            if (a != null && b != null) {
                this.setupChainRelationship(a, b, connection.connectionType, chains);
                continue;
            }
            if (connection.connectionType == ConnectionType.BIDIRECTIONAL) {
                if (a == null && b != null) {
                    b.positions.put(connection.a, this.blockMap.get(connection.a));
                    continue;
                }
                if (a != null) {
                    a.positions.put(connection.b, this.blockMap.get(connection.b));
                    continue;
                }
                a = new InfiniwireChain(this.block);
                a.positions.put(connection.a, this.blockMap.get(connection.a));
                a.positions.put(connection.b, this.blockMap.get(connection.b));
                chains.add(a);
                continue;
            }
            if (a == null && b != null) {
                a = new InfiniwireChain(this.block);
                a.positions.put(connection.a, this.blockMap.get(connection.a));
                chains.add(a);
                this.setupChainRelationship(a, b, connection.connectionType, chains);
                continue;
            }
            if (a != null) {
                b = new InfiniwireChain(this.block);
                b.positions.put(connection.b, this.blockMap.get(connection.b));
                chains.add(b);
                this.setupChainRelationship(a, b, connection.connectionType, chains);
                continue;
            }
            a = new InfiniwireChain(this.block);
            a.positions.put(connection.a, this.blockMap.get(connection.a));
            chains.add(a);
            b = new InfiniwireChain(this.block);
            b.positions.put(connection.b, this.blockMap.get(connection.b));
            chains.add(b);
            this.setupChainRelationship(a, b, connection.connectionType, chains);
        }
        InfiniwireChainParent parent = new InfiniwireChainParent();
        for (InfiniwireChain chain : chains) {
            for (BlockPos pos : chain.positions.keySet()) {
                parent.chainMap.put(pos, chain);
            }
        }
        if (chains.size() == 0) {
            InfiniwireChain infiniwireChain = new InfiniwireChain(this.block);
            infiniwireChain.positions.put(this.originPos, this.originState);
            parent.chainMap.put(this.originPos, infiniwireChain);
        }
        return parent;
    }

    protected void setupChainRelationship(InfiniwireChain a, InfiniwireChain b, ConnectionType connectionType, Set<InfiniwireChain> chains) {
        switch (connectionType) {
            case BIDIRECTIONAL: {
                this.checkForRecursivePowering(this.mergeChains(a, b, chains), chains);
                break;
            }
            case A_TO_B: {
                a.chainsPowering.add(b);
                b.chainsPoweredBy.add(a);
                this.checkForRecursivePowering(a, chains);
                break;
            }
            case B_TO_A: {
                b.chainsPowering.add(a);
                a.chainsPoweredBy.add(b);
                this.checkForRecursivePowering(a, chains);
            }
        }
    }

    protected InfiniwireChain mergeChains(InfiniwireChain a, InfiniwireChain b, Set<InfiniwireChain> chains) {
        InfiniwireChain combinedChain = new InfiniwireChain(this.block);
        combinedChain.positions.putAll(a.positions);
        combinedChain.positions.putAll(b.positions);
        a.chainsPoweredBy.remove(b);
        b.chainsPoweredBy.remove(a);
        a.chainsPowering.remove(b);
        b.chainsPowering.remove(a);
        combinedChain.chainsPoweredBy.addAll(a.chainsPoweredBy);
        for (InfiniwireChain chain : a.chainsPoweredBy) {
            chain.chainsPowering.remove(a);
            chain.chainsPowering.add(combinedChain);
        }
        combinedChain.chainsPoweredBy.addAll(b.chainsPoweredBy);
        for (InfiniwireChain chain : b.chainsPoweredBy) {
            chain.chainsPowering.remove(b);
            chain.chainsPowering.add(combinedChain);
        }
        combinedChain.chainsPowering.addAll(a.chainsPowering);
        for (InfiniwireChain chain : a.chainsPowering) {
            chain.chainsPoweredBy.remove(a);
            chain.chainsPoweredBy.add(combinedChain);
        }
        combinedChain.chainsPowering.addAll(b.chainsPowering);
        for (InfiniwireChain chain : b.chainsPowering) {
            chain.chainsPoweredBy.remove(b);
            chain.chainsPoweredBy.add(combinedChain);
        }
        chains.remove(a);
        chains.remove(b);
        chains.add(combinedChain);
        return combinedChain;
    }

    protected void checkForRecursivePowering(InfiniwireChain chain, Set<InfiniwireChain> chains) {
        this.checkForRecursivePowering(chain, chain, chains, new HashSet<InfiniwireChain>(), new Stack<InfiniwireChain>());
    }

    protected void mergeChains(Set<InfiniwireChain> chainsToMerge, Set<InfiniwireChain> chains) {
        if (chainsToMerge.size() < 2) {
            return;
        }
        InfiniwireChain[] chainArray = chainsToMerge.toArray(new InfiniwireChain[0]);
        if (chainsToMerge.size() == 2) {
            this.checkForRecursivePowering(this.mergeChains(chainArray[0], chainArray[1], chains), chains);
        }
        InfiniwireChain combined = chainArray[0];
        for (int i = 1; i < chainArray.length; ++i) {
            combined = this.mergeChains(combined, chainArray[i], chains);
        }
        this.checkForRecursivePowering(combined, chains);
    }

    protected void checkForRecursivePowering(InfiniwireChain current, InfiniwireChain start, Set<InfiniwireChain> chains, Set<InfiniwireChain> checkedChains, Stack<InfiniwireChain> currentPath) {
        checkedChains.add(current);
        for (InfiniwireChain chain : current.chainsPowering) {
            currentPath.push(chain);
            if (chain == start) {
                this.mergeChains(new HashSet<InfiniwireChain>(currentPath), chains);
                return;
            }
            if (!checkedChains.contains(chain)) {
                this.checkForRecursivePowering(chain, start, chains, checkedChains, currentPath);
            }
            currentPath.pop();
        }
    }

    public void addNewConnection(BlockPos aPos, BlockState aState, BlockPos bPos, BlockState bState, ConnectionType connectionType) {
        Connection connection = new Connection(aPos, bPos, connectionType);
        if (!this.connectionSet.contains(connection)) {
            connection.install();
            if (!this.blockMap.containsKey(aPos)) {
                this.blockMap.put(aPos, aState);
            }
            if (!this.blockMap.containsKey(bPos)) {
                this.blockMap.put(bPos, bState);
            }
        }
    }

    protected class Connection {
        protected final BlockPos a;
        protected final BlockPos b;
        protected final ConnectionType connectionType;

        protected Connection(BlockPos a, BlockPos b, ConnectionType connectionType) {
            this.a = a;
            this.b = b;
            this.connectionType = connectionType;
        }

        protected void install() {
            InfiniwireGraphBuilder.this.getOrCreateConnectionList(this.a).add(this);
            InfiniwireGraphBuilder.this.getOrCreateConnectionList(this.b).add(this);
            InfiniwireGraphBuilder.this.connectionSet.add(this);
        }

        public int hashCode() {
            return this.a.hashCode() + this.b.hashCode();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Connection)) {
                return false;
            }
            Connection other = (Connection)o;
            boolean equalsPositions = this.a.equals((Object)other.a) && this.b.equals((Object)other.b) || this.a.equals((Object)other.b) && this.b.equals((Object)other.a);
            return equalsPositions && this.connectionType == other.connectionType;
        }
    }

    public static enum ConnectionType {
        BIDIRECTIONAL,
        A_TO_B,
        B_TO_A;

    }
}

