/*
 * Decompiled with CFR 0.152.
 */
package mrp_v2.morewires.datagen;

import mrp_v2.morewires.block.AdjustedRedstoneWireBlock;
import mrp_v2.morewires.block.InfiniwireBlock;
import mrp_v2.morewires.util.ObjectHolder;
import mrp_v2.mrplibrary.datagen.providers.BlockStateProvider;
import net.minecraft.block.Block;
import net.minecraft.block.RedstoneWireBlock;
import net.minecraft.data.DataGenerator;
import net.minecraft.state.Property;
import net.minecraft.state.properties.RedstoneSide;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.client.model.generators.MultiPartBlockStateBuilder;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.fml.RegistryObject;
import org.apache.commons.lang3.tuple.Pair;

public class BlockStateGenerator
extends BlockStateProvider {
    protected ModelFile dotModel;
    protected ModelFile upModel;
    protected ModelFile side0Model;
    protected ModelFile side1Model;
    protected ModelFile sideAlt0Model;
    protected ModelFile sideAlt1Model;

    public BlockStateGenerator(DataGenerator gen, String modId, ExistingFileHelper exFileHelper) {
        super(gen, modId, exFileHelper);
    }

    protected void registerStatesAndModels() {
        Pair particleDot = Pair.of((Object)"particle", (Object)"dot");
        Pair line0 = Pair.of((Object)"line", (Object)"line0");
        Pair line1 = Pair.of((Object)"line", (Object)"line1");
        this.registerModel("dot", particleDot, Pair.of((Object)"line", (Object)"dot"));
        this.registerModel("side", particleDot);
        this.registerModel("side0", line0);
        this.registerModel("side1", line1);
        this.registerModel("side_alt", particleDot);
        this.registerModel("side_alt0", line0);
        this.registerModel("side_alt1", line1);
        this.registerModel("up", particleDot, line0);
        this.registerWireStates();
        this.registerInfiniwireStates();
    }

    @SafeVarargs
    protected final void registerModel(String suffix, Pair<String, String> ... textures) {
        ModelBuilder modelBuilder = this.models().withExistingParent("morewires:block/infiniwire_" + suffix, "minecraft:block/redstone_dust_" + suffix);
        for (Pair<String, String> texture : textures) {
            modelBuilder.texture((String)texture.getLeft(), this.modLoc("block/infiniwire_" + (String)texture.getRight()));
        }
    }

    protected void registerWireStates() {
        this.setupWireModels();
        for (RegistryObject<AdjustedRedstoneWireBlock> block : ObjectHolder.WIRE_BLOCKS_EXCLUDING_REDSTONE.values()) {
            this.registerWireBasedStates((AdjustedRedstoneWireBlock)block.get());
        }
    }

    protected void setupWireModels() {
        this.dotModel = this.models().getExistingFile(new ResourceLocation("block/redstone_dust_dot"));
        this.upModel = this.models().getExistingFile(new ResourceLocation("block/redstone_dust_up"));
        this.side0Model = this.models().getExistingFile(new ResourceLocation("block/redstone_dust_side0"));
        this.side1Model = this.models().getExistingFile(new ResourceLocation("block/redstone_dust_side1"));
        this.sideAlt0Model = this.models().getExistingFile(new ResourceLocation("block/redstone_dust_side_alt0"));
        this.sideAlt1Model = this.models().getExistingFile(new ResourceLocation("block/redstone_dust_side_alt1"));
    }

    protected void registerWireBasedStates(AdjustedRedstoneWireBlock wireBasedBlock) {
        ((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)this.getMultipartBuilder((Block)wireBasedBlock).part().modelFile(this.dotModel).addModel()).useOr().nestedGroup().condition((Property)RedstoneWireBlock.field_176348_a, (Comparable[])new RedstoneSide[]{RedstoneSide.NONE}).condition((Property)RedstoneWireBlock.field_176349_M, (Comparable[])new RedstoneSide[]{RedstoneSide.NONE}).condition((Property)RedstoneWireBlock.field_176347_b, (Comparable[])new RedstoneSide[]{RedstoneSide.NONE}).condition((Property)RedstoneWireBlock.field_176350_N, (Comparable[])new RedstoneSide[]{RedstoneSide.NONE}).end().nestedGroup().nestedGroup().useOr().condition((Property)RedstoneWireBlock.field_176348_a, (Comparable[])new RedstoneSide[]{RedstoneSide.SIDE, RedstoneSide.UP}).condition((Property)RedstoneWireBlock.field_176349_M, (Comparable[])new RedstoneSide[]{RedstoneSide.SIDE, RedstoneSide.UP}).endNestedGroup().nestedGroup().useOr().condition((Property)RedstoneWireBlock.field_176347_b, (Comparable[])new RedstoneSide[]{RedstoneSide.SIDE, RedstoneSide.UP}).condition((Property)RedstoneWireBlock.field_176350_N, (Comparable[])new RedstoneSide[]{RedstoneSide.SIDE, RedstoneSide.UP}).endNestedGroup().end().end().part().modelFile(this.side0Model).addModel()).condition((Property)RedstoneWireBlock.field_176348_a, (Comparable[])new RedstoneSide[]{RedstoneSide.SIDE, RedstoneSide.UP}).end().part().modelFile(this.sideAlt0Model).addModel()).condition((Property)RedstoneWireBlock.field_176349_M, (Comparable[])new RedstoneSide[]{RedstoneSide.SIDE, RedstoneSide.UP}).end().part().modelFile(this.sideAlt1Model).rotationY(270).addModel()).condition((Property)RedstoneWireBlock.field_176347_b, (Comparable[])new RedstoneSide[]{RedstoneSide.SIDE, RedstoneSide.UP}).end().part().modelFile(this.side1Model).rotationY(270).addModel()).condition((Property)RedstoneWireBlock.field_176350_N, (Comparable[])new RedstoneSide[]{RedstoneSide.SIDE, RedstoneSide.UP}).end().part().modelFile(this.upModel).addModel()).condition((Property)RedstoneWireBlock.field_176348_a, (Comparable[])new RedstoneSide[]{RedstoneSide.UP}).end().part().modelFile(this.upModel).rotationY(90).addModel()).condition((Property)RedstoneWireBlock.field_176347_b, (Comparable[])new RedstoneSide[]{RedstoneSide.UP}).end().part().modelFile(this.upModel).rotationY(180).addModel()).condition((Property)RedstoneWireBlock.field_176349_M, (Comparable[])new RedstoneSide[]{RedstoneSide.UP}).end().part().modelFile(this.upModel).rotationY(270).addModel()).condition((Property)RedstoneWireBlock.field_176350_N, (Comparable[])new RedstoneSide[]{RedstoneSide.UP}).end();
    }

    protected void registerInfiniwireStates() {
        this.setupInfiniwireModels();
        for (RegistryObject<InfiniwireBlock> block : ObjectHolder.INFINIWIRE_BLOCKS.values()) {
            this.registerWireBasedStates((AdjustedRedstoneWireBlock)block.get());
        }
    }

    protected void setupInfiniwireModels() {
        this.dotModel = this.models().getExistingFile(new ResourceLocation("morewires", "block/infiniwire_dot"));
        this.upModel = this.models().getExistingFile(new ResourceLocation("morewires", "block/infiniwire_up"));
        this.side0Model = this.models().getExistingFile(new ResourceLocation("morewires", "block/infiniwire_side0"));
        this.side1Model = this.models().getExistingFile(new ResourceLocation("morewires", "block/infiniwire_side1"));
        this.sideAlt0Model = this.models().getExistingFile(new ResourceLocation("morewires", "block/infiniwire_side_alt0"));
        this.sideAlt1Model = this.models().getExistingFile(new ResourceLocation("morewires", "block/infiniwire_side_alt1"));
    }
}

