/*
 * Decompiled with CFR 0.152.
 */
package mrp_v2.morewires.datagen;

import mrp_v2.morewires.item.AdjustedRedstoneItem;
import mrp_v2.morewires.util.ObjectHolder;
import net.minecraft.data.DataGenerator;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.generators.ItemModelProvider;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.fml.RegistryObject;

public class ItemModelGenerator
extends ItemModelProvider {
    public ItemModelGenerator(DataGenerator generator, String modId, ExistingFileHelper existingFileHelper) {
        super(generator, modId, existingFileHelper);
    }

    protected void registerModels() {
        for (RegistryObject<AdjustedRedstoneItem> registryObject : ObjectHolder.WIRE_BLOCK_ITEMS_EXCLUDING_REDSTONE.values()) {
            this.registerItemModel((Item)registryObject.get());
        }
        for (RegistryObject<AdjustedRedstoneItem> registryObject : ObjectHolder.INFINIWIRE_BLOCK_ITEMS.values()) {
            this.registerInfiniwireItemModel((Item)registryObject.get());
        }
    }

    protected void registerItemModel(Item item) {
        this.registerItemModel(item, this.modLoc("item/" + item.getRegistryName().func_110623_a()));
    }

    protected void registerItemModel(Item item, ResourceLocation texture) {
        super.singleTexture(item.getRegistryName().func_110623_a(), new ResourceLocation("item/generated"), "layer0", texture);
    }

    private void registerInfiniwireItemModel(Item item) {
        String path = item.getRegistryName().func_110623_a().replace("infini", "");
        if (path.contains("red_wire")) {
            this.registerItemModel(item, new ResourceLocation("minecraft:item/redstone"));
        } else {
            this.registerItemModel(item, this.modLoc("item/" + path));
        }
    }
}

