/*
 * Decompiled with CFR 0.152.
 */
package mrp_v2.morewires.datagen;

import java.util.function.Consumer;
import mrp_v2.morewires.item.AdjustedRedstoneItem;
import mrp_v2.morewires.util.ObjectHolder;
import mrp_v2.mrplibrary.datagen.providers.RecipeProvider;
import net.minecraft.advancements.ICriterionInstance;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.data.ShapelessRecipeBuilder;
import net.minecraft.item.Item;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.tags.ITag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.Tags;
import net.minecraftforge.fml.RegistryObject;

public class RecipeGenerator
extends RecipeProvider {
    public static final String DYEING_ID = "dyeing";

    public RecipeGenerator(DataGenerator generatorIn, String modId) {
        super(generatorIn, modId);
    }

    protected void func_200404_a(Consumer<IFinishedRecipe> iFinishedRecipeConsumer) {
        this.makeWireRecipes(iFinishedRecipeConsumer);
        this.makeInfiniwireRecipes(iFinishedRecipeConsumer);
    }

    private void makeWireRecipes(Consumer<IFinishedRecipe> iFinishedRecipeConsumer) {
        for (RegistryObject<AdjustedRedstoneItem> item : ObjectHolder.WIRE_BLOCK_ITEMS_EXCLUDING_REDSTONE.values()) {
            this.makeDyeingWireRecipe(iFinishedRecipeConsumer, (IItemProvider)item.get(), ((AdjustedRedstoneItem)item.get()).getDyeTag());
        }
    }

    private void makeDyeingWireRecipe(Consumer<IFinishedRecipe> iFinishedRecipeConsumer, IItemProvider result, ITag<Item> dyeTag) {
        ResourceLocation resultLoc = result.func_199767_j().getRegistryName();
        ShapelessRecipeBuilder.func_200488_a((IItemProvider)result, (int)8).func_200492_a(Ingredient.func_199805_a(ObjectHolder.WIRES_TAG), 8).func_203221_a(dyeTag).func_200483_a("has_wire", (ICriterionInstance)RecipeProvider.func_200409_a(ObjectHolder.WIRES_TAG)).func_200490_a(resultLoc.func_110623_a()).func_200485_a(iFinishedRecipeConsumer, this.modLoc("dyeing/" + resultLoc.func_110623_a()));
    }

    private void makeInfiniwireRecipes(Consumer<IFinishedRecipe> iFinishedRecipeConsumer) {
        for (String color : ObjectHolder.COLORS.keySet()) {
            AdjustedRedstoneItem item = (AdjustedRedstoneItem)ObjectHolder.INFINIWIRE_BLOCK_ITEMS.get(color).get();
            this.makeDyedInfiniwireRecipe(iFinishedRecipeConsumer, (IItemProvider)item, (IItemProvider)ObjectHolder.WIRE_BLOCK_ITEMS.get(color).get());
            this.makeDyeingInfiniwireRecipe(iFinishedRecipeConsumer, (IItemProvider)item, item.getDyeTag());
        }
    }

    private void makeDyeingInfiniwireRecipe(Consumer<IFinishedRecipe> iFinishedRecipeConsumer, IItemProvider result, ITag<Item> dyeTag) {
        ResourceLocation resultLoc = result.func_199767_j().getRegistryName();
        ShapelessRecipeBuilder.func_200488_a((IItemProvider)result, (int)8).func_200492_a(Ingredient.func_199805_a(ObjectHolder.INFINIWIRES_TAG), 8).func_203221_a(dyeTag).func_200483_a("has_infiniwire", (ICriterionInstance)RecipeProvider.func_200409_a(ObjectHolder.INFINIWIRES_TAG)).func_200490_a(resultLoc.func_110623_a()).func_200485_a(iFinishedRecipeConsumer, this.modLoc("dyeing/" + resultLoc.func_110623_a()));
    }

    private void makeDyedInfiniwireRecipe(Consumer<IFinishedRecipe> iFinishedRecipeConsumer, IItemProvider result, IItemProvider ingredient) {
        ShapelessRecipeBuilder.func_200488_a((IItemProvider)result, (int)8).func_200491_b(ingredient, 8).func_203221_a((ITag)Tags.Items.INGOTS_IRON).func_200483_a("has_wire", (ICriterionInstance)RecipeProvider.func_200403_a((IItemProvider)ingredient)).func_200490_a(result.func_199767_j().getRegistryName().func_110623_a()).func_200482_a(iFinishedRecipeConsumer);
    }
}

