/*
 * Decompiled with CFR 0.152.
 */
package mrp_v2.morewires.util;

import java.util.HashMap;
import mrp_v2.morewires.block.AdjustedRedstoneWireBlock;
import mrp_v2.morewires.block.InfiniwireBlock;
import mrp_v2.morewires.item.AdjustedRedstoneItem;
import mrp_v2.morewires.item.InfiniwireItem;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.Tags;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import org.apache.commons.lang3.tuple.Pair;

public class ObjectHolder {
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"morewires");
    public static final DeferredRegister<Block> VANILLA_BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"minecraft");
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"morewires");
    public static final DeferredRegister<Item> VANILLA_ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"minecraft");
    public static final HashMap<String, RegistryObject<AdjustedRedstoneWireBlock>> WIRE_BLOCKS;
    public static final HashMap<String, RegistryObject<AdjustedRedstoneWireBlock>> WIRE_BLOCKS_EXCLUDING_REDSTONE;
    public static final HashMap<String, RegistryObject<AdjustedRedstoneItem>> WIRE_BLOCK_ITEMS;
    public static final HashMap<String, RegistryObject<AdjustedRedstoneItem>> WIRE_BLOCK_ITEMS_EXCLUDING_REDSTONE;
    public static final HashMap<String, RegistryObject<InfiniwireBlock>> INFINIWIRE_BLOCKS;
    public static final HashMap<String, RegistryObject<InfiniwireItem>> INFINIWIRE_BLOCK_ITEMS;
    public static final HashMap<String, Pair<Float, ITag<Item>>> COLORS;
    public static final Tags.IOptionalNamedTag<Item> WIRES_TAG;
    public static final Tags.IOptionalNamedTag<Item> INFINIWIRES_TAG;

    public static void registerListeners(IEventBus bus) {
        BLOCKS.register(bus);
        VANILLA_BLOCKS.register(bus);
        ITEMS.register(bus);
        VANILLA_ITEMS.register(bus);
    }

    static {
        COLORS = new HashMap();
        WIRES_TAG = ItemTags.createOptional((ResourceLocation)new ResourceLocation("morewires", "wires"));
        INFINIWIRES_TAG = ItemTags.createOptional((ResourceLocation)new ResourceLocation("morewires", "infiniwires"));
        COLORS.put("blue", (Pair<Float, ITag<Item>>)Pair.of((Object)Float.valueOf(0.6666667f), (Object)Tags.Items.DYES_BLUE));
        COLORS.put("green", (Pair<Float, ITag<Item>>)Pair.of((Object)Float.valueOf(0.33333334f), (Object)Tags.Items.DYES_GREEN));
        COLORS.put("orange", (Pair<Float, ITag<Item>>)Pair.of((Object)Float.valueOf(0.083333336f), (Object)Tags.Items.DYES_ORANGE));
        COLORS.put("pink", (Pair<Float, ITag<Item>>)Pair.of((Object)Float.valueOf(0.8333333f), (Object)Tags.Items.DYES_PINK));
        COLORS.put("yellow", (Pair<Float, ITag<Item>>)Pair.of((Object)Float.valueOf(0.16666667f), (Object)Tags.Items.DYES_YELLOW));
        WIRE_BLOCKS = new HashMap(COLORS.size() + 1);
        WIRE_BLOCKS_EXCLUDING_REDSTONE = new HashMap(COLORS.size());
        WIRE_BLOCK_ITEMS = new HashMap(COLORS.size() + 1);
        WIRE_BLOCK_ITEMS_EXCLUDING_REDSTONE = new HashMap(COLORS.size());
        for (String color : COLORS.keySet()) {
            String id = color + "_wire";
            RegistryObject wireBlockObject = BLOCKS.register(id, () -> new AdjustedRedstoneWireBlock(((Float)COLORS.get(color).getLeft()).floatValue()));
            WIRE_BLOCKS.put(color, (RegistryObject<AdjustedRedstoneWireBlock>)wireBlockObject);
            WIRE_BLOCKS_EXCLUDING_REDSTONE.put(color, (RegistryObject<AdjustedRedstoneWireBlock>)wireBlockObject);
            RegistryObject wireItemObject = ITEMS.register(id, () -> ((AdjustedRedstoneWireBlock)WIRE_BLOCKS.get(color).get()).createBlockItem((ITag<Item>)((ITag)COLORS.get(color).getRight())));
            WIRE_BLOCK_ITEMS.put(color, (RegistryObject<AdjustedRedstoneItem>)wireItemObject);
            WIRE_BLOCK_ITEMS_EXCLUDING_REDSTONE.put(color, (RegistryObject<AdjustedRedstoneItem>)wireItemObject);
        }
        String red = "red";
        COLORS.put(red, (Pair<Float, ITag<Item>>)Pair.of((Object)Float.valueOf(0.0f), (Object)Tags.Items.DYES_RED));
        WIRE_BLOCKS.put(red, (RegistryObject<AdjustedRedstoneWireBlock>)VANILLA_BLOCKS.register("redstone_wire", () -> new AdjustedRedstoneWireBlock(((Float)COLORS.get(red).getLeft()).floatValue())));
        WIRE_BLOCK_ITEMS.put(red, (RegistryObject<AdjustedRedstoneItem>)VANILLA_ITEMS.register("redstone", () -> ((AdjustedRedstoneWireBlock)WIRE_BLOCKS.get(red).get()).createBlockItem((ITag<Item>)((ITag)COLORS.get(red).getRight()))));
        INFINIWIRE_BLOCKS = new HashMap(COLORS.size());
        INFINIWIRE_BLOCK_ITEMS = new HashMap(COLORS.size());
        for (String color : COLORS.keySet()) {
            String id = color + "_infiniwire";
            INFINIWIRE_BLOCKS.put(color, (RegistryObject<InfiniwireBlock>)BLOCKS.register(id, () -> new InfiniwireBlock(((Float)COLORS.get(color).getLeft()).floatValue())));
            INFINIWIRE_BLOCK_ITEMS.put(color, (RegistryObject<InfiniwireItem>)ITEMS.register(id, () -> ((InfiniwireBlock)INFINIWIRE_BLOCKS.get(color).get()).createBlockItem((ITag)COLORS.get(color).getRight())));
        }
    }
}

