/*
 * Decompiled with CFR 0.152.
 */
package mrp_v2.mrplibrary.datagen;

import java.util.HashMap;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import mrp_v2.mrplibrary.datagen.providers.BlockStateProvider;
import net.minecraft.data.DataGenerator;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.common.data.ExistingFileHelper;
import org.apache.commons.lang3.tuple.Pair;

public class TintedBlockStateGenerator
extends BlockStateProvider {
    public static final String SUBSTITUTE = "#";
    public static final String PARTICLE = "particle";
    public static final String BOTTOM_BASE = "bottom";
    public static final String BOTTOM = "#bottom";
    public static final String TOP = "#top";
    public static final String SIDE = "#side";
    public static final String END = "#end";
    public static final String FRONT = "#front";
    public static final String WALL = "#wall";
    public static final String TEXTURE = "#texture";
    public static final String ALL = "#all";
    public static final ResourceLocation BASE_BLOCK = new ResourceLocation("block/block");
    public static final ResourceLocation CUBE_TINTED = TintedBlockStateGenerator.makeTintedBlockLoc("cube");
    public static final ResourceLocation CUBE_ALL_TINTED = TintedBlockStateGenerator.makeTintedBlockLoc("cube_all");
    public static final ResourceLocation CUBE_BOTTOM_TOP_TINTED = TintedBlockStateGenerator.makeTintedBlockLoc("cube_bottom_top");
    public static final ResourceLocation CUBE_COLUMN_TINTED = TintedBlockStateGenerator.makeTintedBlockLoc("cube_column");
    public static final ResourceLocation CUBE_COLUMN_HORIZONTAL_TINTED = TintedBlockStateGenerator.makeTintedBlockLoc("cube_column_horizontal_tinted");
    public static final ResourceLocation CUBE_DIRECTIONAL_TINTED = TintedBlockStateGenerator.makeTintedBlockLoc("cube_directional");
    public static final ResourceLocation CUBE_MIRRORED_TINTED = TintedBlockStateGenerator.makeTintedBlockLoc("cube_mirrored");
    public static final ResourceLocation CUBE_MIRRORED_ALL_TINTED = TintedBlockStateGenerator.makeTintedBlockLoc("cube_mirrored_all");
    public static final ResourceLocation CUBE_TOP_TINTED = TintedBlockStateGenerator.makeTintedBlockLoc("cube_top");
    public static final ResourceLocation FENCE_GATE_TINTED = TintedBlockStateGenerator.makeTintedBlockLoc("fence_gate");
    public static final ResourceLocation FENCE_GATE_OPEN_TINTED = TintedBlockStateGenerator.makeTintedBlockLoc("fence_gate_open");
    public static final ResourceLocation FENCE_GATE_WALL_TINTED = TintedBlockStateGenerator.makeTintedBlockLoc("fence_gate_wall");
    public static final ResourceLocation FENCE_GATE_WALL_OPEN_TINTED = TintedBlockStateGenerator.makeTintedBlockLoc("fence_gate_wall_open");
    public static final ResourceLocation FENCE_INVENTORY_TINTED = TintedBlockStateGenerator.makeTintedBlockLoc("fence_inventory");
    public static final ResourceLocation FENCE_POST_TINTED = TintedBlockStateGenerator.makeTintedBlockLoc("fence_post");
    public static final ResourceLocation FENCE_SIDE_TINTED = TintedBlockStateGenerator.makeTintedBlockLoc("fence_side");
    public static final ResourceLocation ORIENTABLE_TINTED = TintedBlockStateGenerator.makeTintedBlockLoc("orientable");
    public static final ResourceLocation ORIENTABLE_VERTICAL_TINTED = TintedBlockStateGenerator.makeTintedBlockLoc("orientable_vertical");
    public static final ResourceLocation ORIENTABLE_WITH_BOTTOM_TINTED = TintedBlockStateGenerator.makeTintedBlockLoc("orientable_with_bottom");
    public static final ResourceLocation SLAB_TINTED = TintedBlockStateGenerator.makeTintedBlockLoc("slab");
    public static final ResourceLocation SLAB_TOP_TINTED = TintedBlockStateGenerator.makeTintedBlockLoc("slab_top");
    public static final ResourceLocation STAIRS_TINTED = TintedBlockStateGenerator.makeTintedBlockLoc("stairs");
    public static final ResourceLocation STAIRS_INNER_TINTED = TintedBlockStateGenerator.makeTintedBlockLoc("stairs_inner");
    public static final ResourceLocation STAIRS_OUTER_TINTED = TintedBlockStateGenerator.makeTintedBlockLoc("stairs_outer");
    public static final ResourceLocation WALL_INVENTORY_TINTED = TintedBlockStateGenerator.makeTintedBlockLoc("wall_inventory");
    public static final ResourceLocation WALL_POST_TINTED = TintedBlockStateGenerator.makeTintedBlockLoc("wall_post");
    public static final ResourceLocation WALL_SIDE_TINTED = TintedBlockStateGenerator.makeTintedBlockLoc("wall_side");
    public static final ResourceLocation WALL_SIDE_TALL_TINTED = TintedBlockStateGenerator.makeTintedBlockLoc("wall_side_tall");
    public static final HashMap<Direction, Pair<Integer, Integer>> FACE_ROTATION_MAP = new HashMap();

    public TintedBlockStateGenerator(DataGenerator gen, String modid, ExistingFileHelper exFileHelper) {
        super(gen, modid, exFileHelper);
        this.promiseGeneration(ORIENTABLE_WITH_BOTTOM_TINTED);
    }

    private static ResourceLocation makeTintedBlockLoc(String loc) {
        return TintedBlockStateGenerator.makeBlockLoc(loc + "_tinted");
    }

    private static ResourceLocation makeBlockLoc(String loc) {
        return new ResourceLocation("mrplibrary", "block/" + loc);
    }

    protected void registerStatesAndModels() {
        this.registerFullBlockModels();
        this.registerSlabModels();
        this.registerStairModels();
        this.registerFenceModels();
        this.registerFenceGateModels();
        this.registerWallModels();
    }

    private void registerFenceModels() {
        ModelBuilder.ElementBuilder fenceInventoryLeftPost = ((BlockModelBuilder)this.models().withExistingParent(FENCE_INVENTORY_TINTED.toString(), this.mcLoc("block/fence_inventory"))).element();
        ModelBuilder.ElementBuilder fenceInventoryRightPost = ((BlockModelBuilder)fenceInventoryLeftPost.from(6.0f, 0.0f, 0.0f).to(10.0f, 16.0f, 4.0f).allFaces((direction, faceBuilder) -> faceBuilder.texture(TEXTURE)).face(Direction.DOWN).cullface(Direction.DOWN).end().faces(TintedBlockStateGenerator::tintFunction).end()).element();
        ModelBuilder.ElementBuilder fenceInventoryTopBar = ((BlockModelBuilder)fenceInventoryRightPost.from(6.0f, 0.0f, 12.0f).to(10.0f, 16.0f, 16.0f).allFaces((direction, faceBuilder) -> faceBuilder.texture(TEXTURE)).face(Direction.DOWN).cullface(Direction.DOWN).end().faces(TintedBlockStateGenerator::tintFunction).end()).element();
        ModelBuilder.ElementBuilder fenceInventoryBottomBar = ((BlockModelBuilder)fenceInventoryTopBar.from(7.0f, 13.0f, -2.0f).to(9.0f, 15.0f, 18.0f).allFaces((direction, faceBuilder) -> faceBuilder.texture(TEXTURE)).faces(TintedBlockStateGenerator::tintFunction).end()).element();
        fenceInventoryBottomBar.from(7.0f, 5.0f, -2.0f).to(9.0f, 7.0f, 18.0f).allFaces((direction, faceBuilder) -> faceBuilder.texture(TEXTURE)).faces(TintedBlockStateGenerator::tintFunction).end();
        Util.setUvs(fenceInventoryLeftPost, 6.0f, 0.0f, 10.0f, 4.0f, Direction.DOWN, Direction.UP);
        Util.setUvs(fenceInventoryLeftPost, 6.0f, 0.0f, 10.0f, 16.0f, Direction.NORTH, Direction.SOUTH);
        Util.setUvs(fenceInventoryLeftPost, 0.0f, 0.0f, 4.0f, 16.0f, Direction.WEST, Direction.EAST);
        Util.setUvs(fenceInventoryRightPost, 6.0f, 12.0f, 10.0f, 16.0f, Direction.DOWN, Direction.UP);
        Util.setUvs(fenceInventoryRightPost, 6.0f, 0.0f, 10.0f, 16.0f, Direction.NORTH, Direction.SOUTH);
        Util.setUvs(fenceInventoryRightPost, 12.0f, 0.0f, 16.0f, 16.0f, Direction.WEST, Direction.EAST);
        Util.setUvs(fenceInventoryTopBar, 7.0f, 0.0f, 9.0f, 16.0f, Direction.DOWN, Direction.UP);
        Util.setUvs(fenceInventoryTopBar, 7.0f, 1.0f, 9.0f, 3.0f, Direction.NORTH, Direction.SOUTH);
        Util.setUvs(fenceInventoryTopBar, 0.0f, 1.0f, 16.0f, 3.0f, Direction.WEST, Direction.EAST);
        Util.setUvs(fenceInventoryBottomBar, 7.0f, 0.0f, 9.0f, 16.0f, Direction.DOWN, Direction.UP);
        Util.setUvs(fenceInventoryBottomBar, 7.0f, 9.0f, 9.0f, 11.0f, Direction.NORTH, Direction.SOUTH);
        Util.setUvs(fenceInventoryBottomBar, 0.0f, 9.0f, 16.0f, 11.0f, Direction.WEST, Direction.EAST);
        ModelBuilder.ElementBuilder fencePost = ((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(FENCE_POST_TINTED.toString())).texture(PARTICLE, TEXTURE)).element();
        fencePost.from(6.0f, 0.0f, 6.0f).to(10.0f, 16.0f, 10.0f).allFaces((direction, faceBuilder) -> faceBuilder.texture(TEXTURE)).face(Direction.DOWN).cullface(Direction.DOWN).end().face(Direction.UP).cullface(Direction.UP).end().faces(TintedBlockStateGenerator::tintFunction).end();
        Util.setUvs(fencePost, 6.0f, 6.0f, 10.0f, 10.0f, Direction.DOWN, Direction.UP);
        Util.setUvs(fencePost, 6.0f, 0.0f, 10.0f, 16.0f, Direction.NORTH, Direction.SOUTH, Direction.WEST, Direction.EAST);
        ModelBuilder.ElementBuilder fenceSideTop = ((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(FENCE_SIDE_TINTED.toString())).texture(PARTICLE, TEXTURE)).element();
        ModelBuilder.ElementBuilder fenceSideBottom = ((BlockModelBuilder)fenceSideTop.from(7.0f, 12.0f, 0.0f).to(9.0f, 15.0f, 9.0f).face(Direction.DOWN).end().face(Direction.UP).end().face(Direction.NORTH).cullface(Direction.NORTH).end().face(Direction.WEST).end().face(Direction.WEST).end().face(Direction.EAST).end().faces((direction, faceBuilder) -> faceBuilder.texture(TEXTURE)).faces(TintedBlockStateGenerator::tintFunction).end()).element();
        fenceSideBottom.from(7.0f, 6.0f, 0.0f).to(9.0f, 9.0f, 9.0f).face(Direction.DOWN).end().face(Direction.UP).end().face(Direction.NORTH).cullface(Direction.NORTH).end().face(Direction.WEST).end().face(Direction.EAST).end().faces((direction, faceBuilder) -> faceBuilder.texture(TEXTURE)).faces(TintedBlockStateGenerator::tintFunction).end();
        Util.setUvs(fenceSideTop, 7.0f, 0.0f, 9.0f, 9.0f, Direction.DOWN, Direction.UP);
        fenceSideTop.face(Direction.NORTH).uvs(7.0f, 1.0f, 9.0f, 4.0f);
        Util.setUvs(fenceSideTop, 0.0f, 1.0f, 9.0f, 4.0f, Direction.WEST, Direction.EAST);
        Util.setUvs(fenceSideBottom, 7.0f, 0.0f, 9.0f, 9.0f, Direction.DOWN, Direction.UP);
        fenceSideBottom.face(Direction.NORTH).uvs(7.0f, 7.0f, 9.0f, 10.0f);
        Util.setUvs(fenceSideBottom, 0.0f, 7.0f, 9.0f, 10.0f, Direction.WEST, Direction.EAST);
    }

    private void registerFenceGateModels() {
        ModelBuilder fenceGateTintedBuilder = this.models().withExistingParent(FENCE_GATE_TINTED.toString(), this.mcLoc("block/template_fence_gate"));
        ModelBuilder fenceGateOpenTintedBuilder = ((BlockModelBuilder)this.models().getBuilder(FENCE_GATE_OPEN_TINTED.toString())).texture(PARTICLE, TEXTURE);
        ModelBuilder fenceGateWallTintedBuilder = ((BlockModelBuilder)this.models().getBuilder(FENCE_GATE_WALL_TINTED.toString())).texture(PARTICLE, TEXTURE);
        ModelBuilder fenceGateWallOpenTintedBuilder = ((BlockModelBuilder)this.models().getBuilder(FENCE_GATE_WALL_OPEN_TINTED.toString())).texture(PARTICLE, TEXTURE);
        Util.Wall notWall = new Util.Wall(false);
        Util.Wall wall = new Util.Wall(true);
        Util.fenceGateElements((ModelBuilder<BlockModelBuilder>)fenceGateTintedBuilder, false, notWall);
        Util.fenceGateElements((ModelBuilder<BlockModelBuilder>)fenceGateOpenTintedBuilder, true, notWall);
        Util.fenceGateElements((ModelBuilder<BlockModelBuilder>)fenceGateWallTintedBuilder, false, wall);
        Util.fenceGateElements((ModelBuilder<BlockModelBuilder>)fenceGateWallOpenTintedBuilder, true, wall);
    }

    private void registerFullBlockModels() {
        ((BlockModelBuilder)this.models().withExistingParent(CUBE_TINTED.toString(), BASE_BLOCK)).element().from(0.0f, 0.0f, 0.0f).to(16.0f, 16.0f, 16.0f).allFaces(TintedBlockStateGenerator::cullfaceAndTextureFunction).faces(TintedBlockStateGenerator::tintFunction).end();
        ModelBuilder cubeAllTintedBuilder = ((BlockModelBuilder)this.models().withExistingParent(CUBE_ALL_TINTED.toString(), CUBE_TINTED)).texture(PARTICLE, ALL);
        ModelBuilder cubeBottomTopTintedBuilder = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(CUBE_BOTTOM_TOP_TINTED.toString(), CUBE_TINTED)).texture(PARTICLE, SIDE)).texture(Direction.DOWN.toString(), BOTTOM)).texture(Direction.UP.toString(), TOP);
        ModelBuilder cubeColumnTintedBuilder = ((BlockModelBuilder)this.models().withExistingParent(CUBE_COLUMN_TINTED.toString(), CUBE_TINTED)).texture(PARTICLE, SIDE);
        ModelBuilder cubeColumnHorizontalTintedBuilder = ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(CUBE_COLUMN_HORIZONTAL_TINTED.toString(), BASE_BLOCK)).element().from(0.0f, 0.0f, 0.0f).to(16.0f, 16.0f, 16.0f).allFaces(TintedBlockStateGenerator::cullfaceAndTextureFunction).face(Direction.UP).rotation(ModelBuilder.FaceRotation.UPSIDE_DOWN).end().faces(TintedBlockStateGenerator::tintFunction).end()).texture(PARTICLE, SIDE);
        ((BlockModelBuilder)this.models().withExistingParent(CUBE_DIRECTIONAL_TINTED.toString(), BASE_BLOCK)).element().from(0.0f, 0.0f, 0.0f).to(16.0f, 16.0f, 16.0f).allFaces(TintedBlockStateGenerator::cullfaceAndTextureFunction).face(Direction.DOWN).rotation(ModelBuilder.FaceRotation.UPSIDE_DOWN).end().face(Direction.WEST).rotation(ModelBuilder.FaceRotation.COUNTERCLOCKWISE_90).end().face(Direction.EAST).rotation(ModelBuilder.FaceRotation.CLOCKWISE_90).end().faces(TintedBlockStateGenerator::tintFunction).end();
        ((BlockModelBuilder)this.models().getBuilder(CUBE_MIRRORED_TINTED.toString())).element().from(0.0f, 0.0f, 0.0f).to(16.0f, 16.0f, 16.0f).allFaces(TintedBlockStateGenerator::cullfaceAndTextureFunction).faces((direction, faceBuilder) -> faceBuilder.uvs(16.0f, 0.0f, 0.0f, 16.0f)).faces(TintedBlockStateGenerator::tintFunction).end();
        ModelBuilder cubeMirroredAllTintedBuilder = ((BlockModelBuilder)this.models().withExistingParent(CUBE_MIRRORED_ALL_TINTED.toString(), CUBE_MIRRORED_TINTED)).texture(PARTICLE, ALL);
        ModelBuilder cubeTopTintedBuilder = ((BlockModelBuilder)this.models().withExistingParent(CUBE_TOP_TINTED.toString(), CUBE_TINTED)).texture(PARTICLE, SIDE);
        ((BlockModelBuilder)this.models().withExistingParent(ORIENTABLE_TINTED.toString(), ORIENTABLE_WITH_BOTTOM_TINTED)).texture(BOTTOM_BASE, TOP);
        ModelBuilder orientableVerticalTintedBuilder = ((BlockModelBuilder)this.models().withExistingParent(ORIENTABLE_VERTICAL_TINTED.toString(), CUBE_TINTED)).texture(PARTICLE, SIDE);
        ModelBuilder orientableWithBottomTintedBuilder = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(ORIENTABLE_WITH_BOTTOM_TINTED.toString(), CUBE_TINTED)).texture(PARTICLE, FRONT)).texture(Direction.DOWN.toString(), BOTTOM)).texture(Direction.UP.toString(), TOP);
        for (Direction direction2 : Direction.values()) {
            String name = direction2.toString();
            cubeAllTintedBuilder.texture(name, ALL);
            cubeMirroredAllTintedBuilder.texture(name, ALL);
            cubeTopTintedBuilder.texture(name, SIDE);
            orientableVerticalTintedBuilder.texture(name, SIDE);
        }
        for (Direction direction3 : Direction.Plane.HORIZONTAL) {
            String name = direction3.toString();
            cubeBottomTopTintedBuilder.texture(name, SIDE);
            cubeColumnTintedBuilder.texture(name, SIDE);
            cubeColumnHorizontalTintedBuilder.texture(name, SIDE);
            orientableWithBottomTintedBuilder.texture(name, SIDE);
        }
        for (Direction direction4 : Direction.Plane.VERTICAL) {
            String name = direction4.toString();
            cubeColumnTintedBuilder.texture(name, END);
            cubeColumnHorizontalTintedBuilder.texture(name, END);
        }
        cubeTopTintedBuilder.texture(Direction.UP.toString(), TOP);
        orientableVerticalTintedBuilder.texture(Direction.UP.toString(), FRONT);
        orientableWithBottomTintedBuilder.texture(Direction.NORTH.toString(), FRONT);
    }

    /*
     * Ignored method signature, as it can't be verified against descriptor
     */
    private static void cullfaceAndTextureFunction(Direction direction, ModelBuilder.ElementBuilder.FaceBuilder faceBuilder) {
        faceBuilder.cullface(direction).texture(SUBSTITUTE + direction.toString());
    }

    /*
     * Ignored method signature, as it can't be verified against descriptor
     */
    private static void tintFunction(Direction direction, ModelBuilder.ElementBuilder.FaceBuilder faceBuilder) {
        faceBuilder.tintindex(0);
    }

    private void registerWallModels() {
        ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(WALL_INVENTORY_TINTED.toString(), this.mcLoc("block/wall_inventory"))).element().from(4.0f, 0.0f, 4.0f).to(12.0f, 16.0f, 12.0f).allFaces((direction, faceBuilder) -> faceBuilder.texture(WALL)).face(Direction.DOWN).cullface(Direction.DOWN).end().faces(TintedBlockStateGenerator::tintFunction).end()).element().from(5.0f, 0.0f, 0.0f).to(11.0f, 13.0f, 16.0f).allFaces((direction, faceBuilder) -> faceBuilder.texture(WALL)).face(Direction.DOWN).cullface(Direction.DOWN).end().face(Direction.NORTH).cullface(Direction.NORTH).end().face(Direction.SOUTH).cullface(Direction.SOUTH).end().faces(TintedBlockStateGenerator::tintFunction).end();
        ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(WALL_POST_TINTED.toString(), BASE_BLOCK)).texture(PARTICLE, WALL)).element().from(4.0f, 0.0f, 4.0f).to(12.0f, 16.0f, 12.0f).allFaces((dir, builder) -> builder.texture(WALL)).face(Direction.DOWN).cullface(Direction.DOWN).end().face(Direction.UP).cullface(Direction.UP).end().faces(TintedBlockStateGenerator::tintFunction).end();
        ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(WALL_SIDE_TINTED.toString(), BASE_BLOCK)).texture(PARTICLE, WALL)).element().from(5.0f, 0.0f, 0.0f).to(11.0f, 14.0f, 8.0f).face(Direction.DOWN).texture(WALL).cullface(Direction.DOWN).end().face(Direction.UP).texture(WALL).end().face(Direction.NORTH).texture(WALL).cullface(Direction.NORTH).end().face(Direction.WEST).texture(WALL).end().face(Direction.EAST).texture(WALL).end().faces(TintedBlockStateGenerator::tintFunction).end();
        ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(WALL_SIDE_TALL_TINTED.toString(), BASE_BLOCK)).texture(PARTICLE, WALL)).element().from(5.0f, 0.0f, 0.0f).to(11.0f, 16.0f, 8.0f).face(Direction.DOWN).texture(WALL).cullface(Direction.DOWN).end().face(Direction.UP).texture(WALL).cullface(Direction.UP).end().face(Direction.NORTH).texture(WALL).cullface(Direction.NORTH).end().face(Direction.WEST).texture(WALL).end().face(Direction.EAST).texture(WALL).end().faces(TintedBlockStateGenerator::tintFunction).end();
    }

    private void registerSlabModels() {
        ModelBuilder.ElementBuilder slabTintedBuilder = ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(SLAB_TINTED.toString(), BASE_BLOCK)).texture(PARTICLE, SIDE)).element();
        ModelBuilder.ElementBuilder slabTopTintedBuilder = ((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(SLAB_TOP_TINTED.toString())).texture(PARTICLE, SIDE)).element();
        slabTintedBuilder.from(0.0f, 0.0f, 0.0f).to(16.0f, 8.0f, 16.0f).face(Direction.DOWN).texture(BOTTOM).cullface(Direction.DOWN).end().face(Direction.UP).texture(TOP).end();
        slabTopTintedBuilder.from(0.0f, 8.0f, 0.0f).to(16.0f, 16.0f, 16.0f).face(Direction.DOWN).texture(BOTTOM).end().face(Direction.UP).texture(TOP).cullface(Direction.UP).end();
        BiConsumer<ModelBuilder.ElementBuilder, Direction> sideBuilder = (builder, side) -> builder.face(side).texture(SIDE).cullface(side).end();
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            sideBuilder.accept(slabTintedBuilder, direction);
            sideBuilder.accept(slabTopTintedBuilder, direction);
        }
        slabTintedBuilder.faces(TintedBlockStateGenerator::tintFunction).end();
        slabTopTintedBuilder.faces(TintedBlockStateGenerator::tintFunction).end();
    }

    private void registerStairModels() {
        Consumer<ModelBuilder> firstElementBuilder = builder -> {
            ModelBuilder.ElementBuilder elementBuilder = builder.element().from(0.0f, 0.0f, 0.0f).to(16.0f, 8.0f, 16.0f).face(Direction.DOWN).texture(BOTTOM).cullface(Direction.DOWN).end().face(Direction.UP).texture(TOP).end();
            for (Direction side : Direction.Plane.HORIZONTAL) {
                elementBuilder.face(side).texture(SIDE).cullface(side).end();
            }
            elementBuilder.end();
            elementBuilder.faces(TintedBlockStateGenerator::tintFunction);
        };
        BiFunction<ModelBuilder.ElementBuilder, Direction[], ModelBuilder.ElementBuilder> basicCullFaceBuilder = (builder, directions) -> {
            for (Direction side : directions) {
                builder.face(side).texture(SIDE).cullface(side).end();
            }
            return builder;
        };
        Consumer<ModelBuilder> stairsAndInnerSecondElementBuilder = builder -> {
            ModelBuilder.ElementBuilder elementBuilder = builder.element().from(8.0f, 8.0f, 0.0f).to(16.0f, 16.0f, 16.0f);
            basicCullFaceBuilder.apply(elementBuilder, new Direction[]{Direction.NORTH, Direction.SOUTH, Direction.EAST});
            elementBuilder.face(Direction.UP).texture(TOP).cullface(Direction.UP).end();
            elementBuilder.face(Direction.WEST).texture(SIDE).end();
            elementBuilder.faces(TintedBlockStateGenerator::tintFunction);
        };
        ModelBuilder stairsBuilder = ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(STAIRS_TINTED.toString(), BASE_BLOCK)).transforms().transform(ModelBuilder.Perspective.GUI).rotation(30.0f, 135.0f, 0.0f).scale(0.625f, 0.625f, 0.625f).end().transform(ModelBuilder.Perspective.HEAD).rotation(0.0f, -90.0f, 0.0f).scale(1.0f, 1.0f, 1.0f).end().transform(ModelBuilder.Perspective.THIRDPERSON_LEFT).rotation(75.0f, -135.0f, 0.0f).translation(0.0f, 2.5f, 0.0f).scale(0.375f, 0.375f, 0.375f).end().end()).texture(PARTICLE, SIDE);
        firstElementBuilder.accept(stairsBuilder);
        stairsAndInnerSecondElementBuilder.accept(stairsBuilder);
        ModelBuilder stairsInnerBuilder = ((BlockModelBuilder)this.models().getBuilder(STAIRS_INNER_TINTED.toString())).texture(PARTICLE, SIDE);
        firstElementBuilder.accept(stairsInnerBuilder);
        stairsAndInnerSecondElementBuilder.accept(stairsInnerBuilder);
        basicCullFaceBuilder.apply(stairsInnerBuilder.element().from(0.0f, 8.0f, 8.0f).to(8.0f, 16.0f, 16.0f).face(Direction.UP).cullface(Direction.UP).texture(TOP).end().face(Direction.NORTH).texture(SIDE).end(), new Direction[]{Direction.SOUTH, Direction.WEST}).faces(TintedBlockStateGenerator::tintFunction).end();
        ModelBuilder stairsOuterBuilder = ((BlockModelBuilder)this.models().getBuilder(STAIRS_OUTER_TINTED.toString())).texture(PARTICLE, SIDE);
        firstElementBuilder.accept(stairsOuterBuilder);
        stairsOuterBuilder.element().from(8.0f, 8.0f, 8.0f).to(16.0f, 16.0f, 16.0f).face(Direction.UP).cullface(Direction.UP).texture(TOP).end().face(Direction.NORTH).texture(SIDE).end().face(Direction.SOUTH).cullface(Direction.SOUTH).texture(SIDE).end().face(Direction.WEST).texture(SIDE).end().face(Direction.EAST).cullface(Direction.EAST).texture(SIDE).end().faces(TintedBlockStateGenerator::tintFunction).end();
    }

    @Nonnull
    public String func_200397_b() {
        return super.func_200397_b() + ": Tinted Blocks";
    }

    static {
        FACE_ROTATION_MAP.put(Direction.NORTH, (Pair<Integer, Integer>)Pair.of((Object)0, (Object)0));
        FACE_ROTATION_MAP.put(Direction.EAST, (Pair<Integer, Integer>)Pair.of((Object)0, (Object)90));
        FACE_ROTATION_MAP.put(Direction.SOUTH, (Pair<Integer, Integer>)Pair.of((Object)0, (Object)180));
        FACE_ROTATION_MAP.put(Direction.WEST, (Pair<Integer, Integer>)Pair.of((Object)0, (Object)-90));
        FACE_ROTATION_MAP.put(Direction.UP, (Pair<Integer, Integer>)Pair.of((Object)-90, (Object)0));
        FACE_ROTATION_MAP.put(Direction.DOWN, (Pair<Integer, Integer>)Pair.of((Object)90, (Object)0));
    }

    public static class Util {
        public static void fenceGateElements(ModelBuilder<BlockModelBuilder> builder, boolean isOpen, Wall wall) {
            ModelBuilder.ElementBuilder leftPost = builder.element().from(0.0f, wall.apply(5.0f), 7.0f).to(2.0f, wall.apply(16.0f), 9.0f).allFaces((direction, faceBuilder) -> faceBuilder.texture(TintedBlockStateGenerator.TEXTURE)).face(Direction.WEST).cullface(Direction.WEST).end().faces((x$0, x$1) -> TintedBlockStateGenerator.tintFunction(x$0, x$1));
            Util.setUvs(leftPost, 0.0f, 7.0f, 2.0f, 9.0f, Direction.DOWN, Direction.UP);
            Util.setUvs(leftPost, 0.0f, 0.0f, 2.0f, 11.0f, Direction.NORTH, Direction.SOUTH);
            Util.setUvs(leftPost, 7.0f, 0.0f, 9.0f, 11.0f, Direction.WEST, Direction.EAST);
            ModelBuilder.ElementBuilder rightPost = builder.element().from(14.0f, wall.apply(5.0f), 7.0f).to(16.0f, wall.apply(16.0f), 9.0f).allFaces((direction, faceBuilder) -> faceBuilder.texture(TintedBlockStateGenerator.TEXTURE)).face(Direction.EAST).cullface(Direction.EAST).end().faces((x$0, x$1) -> TintedBlockStateGenerator.tintFunction(x$0, x$1));
            Util.setUvs(rightPost, 14.0f, 7.0f, 16.0f, 9.0f, Direction.DOWN, Direction.UP);
            Util.setUvs(rightPost, 14.0f, 0.0f, 16.0f, 11.0f, Direction.NORTH, Direction.SOUTH);
            Util.setUvs(rightPost, 7.0f, 0.0f, 9.0f, 11.0f, Direction.WEST, Direction.EAST);
            ModelBuilder.ElementBuilder leftInnerVerticalPost = builder.element().from(isOpen ? 0.0f : 6.0f, wall.apply(6.0f), isOpen ? 13.0f : 7.0f).to(isOpen ? 2.0f : 8.0f, wall.apply(15.0f), isOpen ? 15.0f : 9.0f).allFaces(Util::textureFunction).faces((x$0, x$1) -> TintedBlockStateGenerator.tintFunction(x$0, x$1));
            Util.setUvs(leftInnerVerticalPost, 0.0f, 6.0f, 13.0f, 7.0f, 2.0f, 8.0f, 15.0f, 9.0f, isOpen, Direction.DOWN, Direction.UP);
            Util.setUvs(leftInnerVerticalPost, 0.0f, 6.0f, 1.0f, 2.0f, 8.0f, 10.0f, isOpen, Direction.NORTH, Direction.SOUTH);
            Util.setUvs(leftInnerVerticalPost, 13.0f, 7.0f, 1.0f, 15.0f, 9.0f, 10.0f, isOpen, Direction.WEST, Direction.EAST);
            ModelBuilder.ElementBuilder rightInnerVerticalPost = builder.element().from(isOpen ? 14.0f : 8.0f, wall.apply(6.0f), isOpen ? 13.0f : 7.0f).to(isOpen ? 16.0f : 10.0f, wall.apply(15.0f), isOpen ? 15.0f : 9.0f).allFaces(Util::textureFunction).faces((x$0, x$1) -> TintedBlockStateGenerator.tintFunction(x$0, x$1));
            Util.setUvs(rightInnerVerticalPost, 14.0f, 8.0f, 13.0f, 7.0f, 16.0f, 10.0f, 15.0f, 9.0f, isOpen, Direction.DOWN, Direction.UP);
            Util.setUvs(rightInnerVerticalPost, 14.0f, 8.0f, 1.0f, 16.0f, 10.0f, 10.0f, isOpen, Direction.NORTH, Direction.SOUTH);
            Util.setUvs(rightInnerVerticalPost, 13.0f, 7.0f, 1.0f, 15.0f, 9.0f, 10.0f, isOpen, Direction.WEST, Direction.EAST);
            ModelBuilder.ElementBuilder leftLowerHorizontalBar = builder.element().from(isOpen ? 0.0f : 2.0f, wall.apply(6.0f), isOpen ? 9.0f : 7.0f).to(isOpen ? 2.0f : 6.0f, wall.apply(9.0f), isOpen ? 13.0f : 9.0f).face(Direction.DOWN).end().face(Direction.UP).end();
            ModelBuilder.ElementBuilder leftUpperHorizontalBar = builder.element().from(isOpen ? 0.0f : 2.0f, wall.apply(12.0f), isOpen ? 9.0f : 7.0f).to(isOpen ? 2.0f : 6.0f, wall.apply(15.0f), isOpen ? 13.0f : 9.0f).face(Direction.DOWN).end().face(Direction.UP).end();
            ModelBuilder.ElementBuilder rightLowerHorizontalBar = builder.element().from(isOpen ? 14.0f : 10.0f, wall.apply(6.0f), isOpen ? 9.0f : 7.0f).to(isOpen ? 16.0f : 14.0f, wall.apply(9.0f), isOpen ? 13.0f : 9.0f).face(Direction.DOWN).end().face(Direction.UP).end();
            ModelBuilder.ElementBuilder rightUpperHorizontalBar = builder.element().from(isOpen ? 14.0f : 10.0f, wall.apply(12.0f), isOpen ? 9.0f : 7.0f).to(isOpen ? 16.0f : 14.0f, wall.apply(15.0f), isOpen ? 13.0f : 9.0f).face(Direction.DOWN).end().face(Direction.UP).end();
            if (isOpen) {
                leftLowerHorizontalBar.face(Direction.WEST).end().face(Direction.EAST).end();
                leftUpperHorizontalBar.face(Direction.WEST).end().face(Direction.EAST).end();
                rightLowerHorizontalBar.face(Direction.WEST).end().face(Direction.EAST).end();
                rightUpperHorizontalBar.face(Direction.WEST).end().face(Direction.EAST).end();
            } else {
                leftLowerHorizontalBar.face(Direction.NORTH).end().face(Direction.SOUTH).end();
                leftUpperHorizontalBar.face(Direction.NORTH).end().face(Direction.SOUTH).end();
                rightLowerHorizontalBar.face(Direction.NORTH).end().face(Direction.SOUTH).end();
                rightUpperHorizontalBar.face(Direction.NORTH).end().face(Direction.SOUTH).end();
            }
            leftLowerHorizontalBar.faces(Util::textureFunction);
            leftLowerHorizontalBar.faces((x$0, x$1) -> TintedBlockStateGenerator.tintFunction(x$0, x$1));
            Util.setUvs(leftLowerHorizontalBar, 13.0f, 2.0f, 7.0f, 15.0f, 6.0f, 10.0f, isOpen);
            Util.setUvs(leftLowerHorizontalBar, 0.0f, 2.0f, 9.0f, 7.0f, 2.0f, 6.0f, 13.0f, 9.0f, isOpen, Direction.DOWN, Direction.UP);
            leftUpperHorizontalBar.faces(Util::textureFunction);
            leftUpperHorizontalBar.faces((x$0, x$1) -> TintedBlockStateGenerator.tintFunction(x$0, x$1));
            Util.setUvs(leftUpperHorizontalBar, 13.0f, 2.0f, 1.0f, 15.0f, 6.0f, 4.0f, isOpen);
            Util.setUvs(leftUpperHorizontalBar, 0.0f, 2.0f, 9.0f, 7.0f, 2.0f, 6.0f, 13.0f, 9.0f, isOpen, Direction.DOWN, Direction.UP);
            rightLowerHorizontalBar.faces(Util::textureFunction);
            rightLowerHorizontalBar.faces((x$0, x$1) -> TintedBlockStateGenerator.tintFunction(x$0, x$1));
            Util.setUvs(rightLowerHorizontalBar, 13.0f, 10.0f, 7.0f, 15.0f, 14.0f, 10.0f, isOpen);
            Util.setUvs(rightLowerHorizontalBar, 14.0f, 10.0f, 9.0f, 7.0f, 16.0f, 14.0f, 13.0f, 9.0f, isOpen, Direction.DOWN, Direction.UP);
            rightUpperHorizontalBar.faces(Util::textureFunction);
            rightUpperHorizontalBar.faces((x$0, x$1) -> TintedBlockStateGenerator.tintFunction(x$0, x$1));
            Util.setUvs(rightUpperHorizontalBar, 13.0f, 10.0f, 1.0f, 15.0f, 14.0f, 4.0f, isOpen);
            Util.setUvs(rightUpperHorizontalBar, 14.0f, 10.0f, 9.0f, 7.0f, 16.0f, 14.0f, 13.0f, 9.0f, isOpen, Direction.DOWN, Direction.UP);
        }

        public static void setUvs(ModelBuilder.ElementBuilder builder, float u1, float v1, float u2, float v2, Direction ... directions) {
            for (Direction direction : directions) {
                builder.face(direction).uvs(u1, v1, u2, v2);
            }
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        public static void textureFunction(Direction direction, ModelBuilder.ElementBuilder.FaceBuilder faceBuilder) {
            faceBuilder.texture(TintedBlockStateGenerator.TEXTURE);
        }

        public static void setUvs(ModelBuilder.ElementBuilder builder, float u1t, float u1f, float v1t, float v1f, float u2t, float u2f, float v2t, float v2f, boolean condition, Direction ... directions) {
            for (Direction direction : directions) {
                if (condition) {
                    builder.face(direction).uvs(u1t, v1t, u2t, v2t);
                    continue;
                }
                builder.face(direction).uvs(u1f, v1f, u2f, v2f);
            }
        }

        public static void setUvs(ModelBuilder.ElementBuilder builder, float u1t, float u1f, float v1, float u2t, float u2f, float v2, boolean condition, Direction ... directions) {
            for (Direction direction : directions) {
                if (condition) {
                    builder.face(direction).uvs(u1t, v1, u2t, v2);
                    continue;
                }
                builder.face(direction).uvs(u1f, v1, u2f, v2);
            }
        }

        public static void setUvs(ModelBuilder.ElementBuilder builder, float u1t, float u1f, float v1, float u2t, float u2f, float v2, boolean condition) {
            builder.faces((direction, faceBuilder) -> {
                if (condition) {
                    faceBuilder.uvs(u1t, v1, u2t, v2);
                } else {
                    faceBuilder.uvs(u1f, v1, u2f, v2);
                }
            });
        }

        public static float applyWall(float base, boolean isWall) {
            return isWall ? base - 3.0f : base;
        }

        public static class Wall {
            private final boolean isWall;

            public Wall(boolean isWall) {
                this.isWall = isWall;
            }

            public float apply(float f) {
                return Util.applyWall(f, this.isWall);
            }
        }
    }
}

