/*
 * Decompiled with CFR 0.152.
 */
package mrp_v2.mrplibrary.datagen.providers;

import mrp_v2.mrplibrary.datagen.TintedBlockStateGenerator;
import mrp_v2.mrplibrary.util.IModLocProvider;
import net.minecraft.block.Block;
import net.minecraft.block.FenceBlock;
import net.minecraft.block.FenceGateBlock;
import net.minecraft.block.FourWayBlock;
import net.minecraft.block.RotatedPillarBlock;
import net.minecraft.block.SlabBlock;
import net.minecraft.block.StairsBlock;
import net.minecraft.block.WallBlock;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourcePackType;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;

public abstract class BlockStateProvider
extends net.minecraftforge.client.model.generators.BlockStateProvider
implements IModLocProvider {
    public static final String ALL = "all";
    public static final String SIDE = "side";
    public static final String END = "end";
    public static final String FRONT = "front";
    public static final String TOP = "top";
    public static final String BOTTOM = "bottom";
    private final String modId;

    public BlockStateProvider(DataGenerator gen, String modid, ExistingFileHelper exFileHelper) {
        super(gen, modid, exFileHelper);
        this.modId = modid;
    }

    @Override
    public String getModId() {
        return this.modId;
    }

    public void promiseGeneration(ResourceLocation model) {
        this.models().existingFileHelper.trackGenerated(model, ResourcePackType.CLIENT_RESOURCES, ".json", "models");
    }

    public void simpleBlockTinted(Block block) {
        this.simpleBlock(block, this.cubeAllTinted(block));
    }

    public ModelFile cubeAllTinted(Block block) {
        return ((BlockModelBuilder)this.models().withExistingParent(this.name(block), TintedBlockStateGenerator.CUBE_ALL_TINTED)).texture(ALL, this.blockTexture(block));
    }

    protected String name(Block block) {
        return block.getRegistryName().func_110623_a();
    }

    public ModelFile cubeAllTinted(String name, ResourceLocation texture) {
        return ((BlockModelBuilder)this.models().withExistingParent(name, TintedBlockStateGenerator.CUBE_ALL_TINTED)).texture(ALL, texture);
    }

    public void axisBlockTinted(RotatedPillarBlock block) {
        this.axisBlockTinted(block, this.blockTexture((Block)block));
    }

    public void axisBlockTinted(RotatedPillarBlock block, ResourceLocation baseName) {
        this.axisBlockTinted(block, this.extend(baseName, "_side"), this.extend(baseName, "_end"));
    }

    protected ResourceLocation extend(ResourceLocation rl, String suffix) {
        return new ResourceLocation(rl.func_110624_b(), rl.func_110623_a() + suffix);
    }

    public void axisBlockTinted(RotatedPillarBlock block, ResourceLocation side, ResourceLocation end) {
        AxisBlockModels models = this.axisBlockTinted(this.name((Block)block), side, end);
        this.axisBlock(block, models.getCubeColumn(), models.getCubeColumnHorizontal());
    }

    public AxisBlockModels axisBlockTinted(String name, ResourceLocation side, ResourceLocation end) {
        return new AxisBlockModels((ModelFile)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(name, TintedBlockStateGenerator.CUBE_COLUMN_TINTED)).texture(SIDE, side)).texture(END, end), (ModelFile)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(name + "_horizontal", TintedBlockStateGenerator.CUBE_COLUMN_HORIZONTAL_TINTED)).texture(SIDE, side)).texture(END, end));
    }

    public void logBlockTinted(RotatedPillarBlock block) {
        this.axisBlockTinted(block, this.blockTexture((Block)block), this.extend(this.blockTexture((Block)block), "_top"));
    }

    public void horizontalBlockTinted(Block block, ResourceLocation side, ResourceLocation front, ResourceLocation top) {
        this.horizontalBlock(block, this.horizontalBlockTinted(this.name(block), side, front, top));
    }

    public ModelFile horizontalBlockTinted(String name, ResourceLocation side, ResourceLocation front, ResourceLocation top) {
        return ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(name, TintedBlockStateGenerator.ORIENTABLE_TINTED)).texture(SIDE, side)).texture(FRONT, front)).texture(TOP, top);
    }

    public void stairsBlockTinted(StairsBlock block, ResourceLocation texture) {
        this.stairsBlockTinted(block, texture, texture, texture);
    }

    public void stairsBlockTinted(StairsBlock block, ResourceLocation side, ResourceLocation bottom, ResourceLocation top) {
        this.stairsBlockInternalTinted(block, block.getRegistryName().toString(), side, bottom, top);
    }

    protected void stairsBlockInternalTinted(StairsBlock block, String baseName, ResourceLocation side, ResourceLocation bottom, ResourceLocation top) {
        StairsBlockModels models = this.stairsBlockTinted(baseName, side, bottom, top);
        this.stairsBlock(block, models.getStairs(), models.getStairsInner(), models.getStairsOuter());
    }

    public StairsBlockModels stairsBlockTinted(String name, ResourceLocation side, ResourceLocation bottom, ResourceLocation top) {
        return new StairsBlockModels(this.sideBottomTop(name, TintedBlockStateGenerator.STAIRS_TINTED, side, bottom, top), this.sideBottomTop(name + "_inner", TintedBlockStateGenerator.STAIRS_INNER_TINTED, side, bottom, top), this.sideBottomTop(name + "_outer", TintedBlockStateGenerator.STAIRS_OUTER_TINTED, side, bottom, top));
    }

    protected ModelFile sideBottomTop(String name, ResourceLocation parent, ResourceLocation side, ResourceLocation bottom, ResourceLocation top) {
        return ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(name, parent)).texture(SIDE, side)).texture(BOTTOM, bottom)).texture(TOP, top);
    }

    public void stairsBlockTinted(StairsBlock block, String name, ResourceLocation texture) {
        this.stairsBlockTinted(block, name, texture, texture, texture);
    }

    public void stairsBlockTinted(StairsBlock block, String name, ResourceLocation side, ResourceLocation bottom, ResourceLocation top) {
        this.stairsBlockInternalTinted(block, name + "_stairs", side, bottom, top);
    }

    public void slabBlockTinted(SlabBlock block, ResourceLocation doubleslab, ResourceLocation texture) {
        this.slabBlockTinted(block, doubleslab, texture, texture, texture);
    }

    public void slabBlockTinted(SlabBlock block, ResourceLocation doubleslab, ResourceLocation side, ResourceLocation bottom, ResourceLocation top) {
        SlabBlockModels models = this.slabBlockTinted(this.name((Block)block), doubleslab, side, bottom, top);
        this.slabBlock(block, models.getSlab(), models.getSlabTop(), models.getDoubleSlab());
    }

    public SlabBlockModels slabBlockTinted(String name, ResourceLocation doubleslab, ResourceLocation side, ResourceLocation bottom, ResourceLocation top) {
        return new SlabBlockModels(this.sideBottomTop(name, TintedBlockStateGenerator.SLAB_TINTED, side, bottom, top), this.sideBottomTop(name + "_top", TintedBlockStateGenerator.SLAB_TOP_TINTED, side, bottom, top), (ModelFile)this.models().getExistingFile(doubleslab));
    }

    public void fenceBlockTinted(FenceBlock block, ResourceLocation texture) {
        FenceBlockModels models = this.fenceBlockTinted(block.getRegistryName().toString(), texture);
        this.fourWayBlock((FourWayBlock)block, models.getFencePost(), models.getFenceSide());
    }

    public FenceBlockModels fenceBlockTinted(String name, ResourceLocation texture) {
        return new FenceBlockModels((ModelFile)this.models().singleTexture(name + "_post", TintedBlockStateGenerator.FENCE_POST_TINTED, texture), (ModelFile)this.models().singleTexture(name + "_side", TintedBlockStateGenerator.FENCE_SIDE_TINTED, texture));
    }

    public void fenceBlockTinted(FenceBlock block, String name, ResourceLocation texture) {
        this.fourWayBlock((FourWayBlock)block, (ModelFile)this.models().singleTexture(name + "_fence_post", TintedBlockStateGenerator.FENCE_POST_TINTED, texture), (ModelFile)this.models().singleTexture(name + "_fence_side", TintedBlockStateGenerator.FENCE_SIDE_TINTED, texture));
    }

    public void fenceGateBlockTinted(FenceGateBlock block, ResourceLocation texture) {
        this.fenceGateBlockInternalTinted(block, block.getRegistryName().toString(), texture);
    }

    protected void fenceGateBlockInternalTinted(FenceGateBlock block, String baseName, ResourceLocation texture) {
        FenceGateBlockModels models = this.fenceGateBlockTinted(baseName, texture);
        this.fenceGateBlock(block, models.getGate(), models.getGateOpen(), models.getGateWall(), models.getGateWallOpen());
    }

    public FenceGateBlockModels fenceGateBlockTinted(String name, ResourceLocation texture) {
        return new FenceGateBlockModels((ModelFile)this.models().singleTexture(name, TintedBlockStateGenerator.FENCE_GATE_TINTED, texture), (ModelFile)this.models().singleTexture(name + "_open", TintedBlockStateGenerator.FENCE_GATE_OPEN_TINTED, texture), (ModelFile)this.models().singleTexture(name + "_wall", TintedBlockStateGenerator.FENCE_GATE_WALL_TINTED, texture), (ModelFile)this.models().singleTexture(name + "_wall_open", TintedBlockStateGenerator.FENCE_GATE_WALL_OPEN_TINTED, texture));
    }

    public void fenceGateBlockTinted(FenceGateBlock block, String name, ResourceLocation texture) {
        this.fenceGateBlockInternalTinted(block, name + "_fence_gate", texture);
    }

    public void wallBlockTinted(WallBlock block, ResourceLocation texture) {
        this.wallBlockInternalTinted(block, block.getRegistryName().toString(), texture);
    }

    protected void wallBlockInternalTinted(WallBlock block, String baseName, ResourceLocation texture) {
        WallBlockModels models = this.wallBlockTinted(baseName, texture);
        this.wallBlock(block, models.getPost(), models.getSide(), models.getSideTall());
    }

    public WallBlockModels wallBlockTinted(String baseName, ResourceLocation texture) {
        return new WallBlockModels((ModelFile)this.models().singleTexture(baseName + "_post", TintedBlockStateGenerator.WALL_POST_TINTED, "wall", texture), (ModelFile)this.models().singleTexture(baseName + "_side", TintedBlockStateGenerator.WALL_SIDE_TINTED, "wall", texture), (ModelFile)this.models().singleTexture(baseName + "_side_tall", TintedBlockStateGenerator.WALL_SIDE_TALL_TINTED, "wall", texture));
    }

    public void wallBlockTinted(WallBlock block, String name, ResourceLocation texture) {
        this.wallBlockInternalTinted(block, name + "_wall", texture);
    }

    public static class AxisBlockModels {
        private final ModelFile cubeColumn;
        private final ModelFile cubeColumnHorizontal;

        public AxisBlockModels(ModelFile cubeColumn, ModelFile cubeColumnHorizontal) {
            this.cubeColumn = cubeColumn;
            this.cubeColumnHorizontal = cubeColumnHorizontal;
        }

        public ModelFile getCubeColumn() {
            return this.cubeColumn;
        }

        public ModelFile getCubeColumnHorizontal() {
            return this.cubeColumnHorizontal;
        }
    }

    public static class SlabBlockModels {
        private final ModelFile slab;
        private final ModelFile slabTop;
        private final ModelFile doubleSlab;

        public SlabBlockModels(ModelFile slab, ModelFile slabTop, ModelFile doubleSlab) {
            this.slab = slab;
            this.slabTop = slabTop;
            this.doubleSlab = doubleSlab;
        }

        public ModelFile getSlab() {
            return this.slab;
        }

        public ModelFile getSlabTop() {
            return this.slabTop;
        }

        public ModelFile getDoubleSlab() {
            return this.doubleSlab;
        }
    }

    public static class FenceBlockModels {
        private final ModelFile fencePost;
        private final ModelFile fenceSide;

        public FenceBlockModels(ModelFile fencePost, ModelFile fenceSide) {
            this.fencePost = fencePost;
            this.fenceSide = fenceSide;
        }

        public ModelFile getFencePost() {
            return this.fencePost;
        }

        public ModelFile getFenceSide() {
            return this.fenceSide;
        }
    }

    public static class FenceGateBlockModels {
        private final ModelFile gate;
        private final ModelFile gateOpen;
        private final ModelFile gateWall;
        private final ModelFile gateWallOpen;

        public FenceGateBlockModels(ModelFile gate, ModelFile gateOpen, ModelFile gateWall, ModelFile gateWallOpen) {
            this.gate = gate;
            this.gateOpen = gateOpen;
            this.gateWall = gateWall;
            this.gateWallOpen = gateWallOpen;
        }

        public ModelFile getGate() {
            return this.gate;
        }

        public ModelFile getGateOpen() {
            return this.gateOpen;
        }

        public ModelFile getGateWall() {
            return this.gateWall;
        }

        public ModelFile getGateWallOpen() {
            return this.gateWallOpen;
        }
    }

    public static class WallBlockModels {
        private final ModelFile post;
        private final ModelFile side;
        private final ModelFile sideTall;

        public WallBlockModels(ModelFile post, ModelFile side, ModelFile sideTall) {
            this.post = post;
            this.side = side;
            this.sideTall = sideTall;
        }

        public ModelFile getPost() {
            return this.post;
        }

        public ModelFile getSide() {
            return this.side;
        }

        public ModelFile getSideTall() {
            return this.sideTall;
        }
    }

    public static class StairsBlockModels {
        private final ModelFile stairs;
        private final ModelFile stairsInner;
        private final ModelFile stairsOuter;

        public StairsBlockModels(ModelFile stairs, ModelFile stairsInner, ModelFile stairsOuter) {
            this.stairs = stairs;
            this.stairsInner = stairsInner;
            this.stairsOuter = stairsOuter;
        }

        public ModelFile getStairs() {
            return this.stairs;
        }

        public ModelFile getStairsInner() {
            return this.stairsInner;
        }

        public ModelFile getStairsOuter() {
            return this.stairsOuter;
        }
    }
}

