/*
 * Decompiled with CFR 0.152.
 */
package mrp_v2.mrplibrary.datagen.providers;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import mrp_v2.mrplibrary.util.IModLocProvider;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.data.DataGenerator;
import net.minecraft.item.ItemGroup;
import net.minecraft.util.text.TranslationTextComponent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class LanguageProvider
extends net.minecraftforge.common.data.LanguageProvider
implements IModLocProvider {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Map<String, Map<String, Map<String, String>>> staticTranslations = new HashMap<String, Map<String, Map<String, String>>>();
    protected final String modid;
    protected final String locale;

    public LanguageProvider(DataGenerator gen, String modid, String locale) {
        super(gen, modid, locale);
        this.modid = modid;
        this.locale = locale;
    }

    public static TranslationTextComponent makeTextTranslation(String prefix, String modId, String suffix, String locale, String name) {
        return new TranslationTextComponent(LanguageProvider.makeStringTranslation(prefix, modId, suffix, locale, name));
    }

    public static String makeStringTranslation(String prefix, String modId, String suffix, String locale, String name) {
        String id;
        Map modMap = staticTranslations.computeIfAbsent(modId, k -> new HashMap());
        Map localeMap = modMap.computeIfAbsent(locale, k -> new HashMap());
        if (localeMap.containsKey(id = prefix + modId + suffix)) {
            LOGGER.warn("Overriding translation '" + id + "'");
        }
        localeMap.put(id, name);
        return id;
    }

    public static Function<Object[], TranslationTextComponent> makeFormattedTextTranslation(String prefix, String modId, String suffix, String locale, String name) {
        String unformattedName = LanguageProvider.makeStringTranslation(prefix, modId, suffix, locale, name);
        return args -> new TranslationTextComponent(unformattedName, args);
    }

    protected void addTranslations() {
        Map<String, String> localeMap;
        Map<String, Map<String, String>> modMap = staticTranslations.get(this.modid);
        if (modMap != null && (localeMap = modMap.get(this.locale)) != null) {
            localeMap.forEach((arg_0, arg_1) -> ((LanguageProvider)this).add(arg_0, arg_1));
        }
    }

    public String func_200397_b() {
        return super.func_200397_b() + " " + this.modid;
    }

    @Override
    public String getModId() {
        return this.modid;
    }

    public void add(ItemGroup key, String name) {
        TranslationTextComponent test;
        TranslationTextComponent translationTextComponent = test = key.func_242392_c() instanceof TranslationTextComponent ? (TranslationTextComponent)key.func_242392_c() : null;
        if (test != null) {
            this.add(test.func_150268_i(), name);
        } else {
            LogManager.getLogger().warn("Could not make a translation for " + key + " because its groupName is not a TranslationTextComponent!");
        }
    }

    public void add(KeyBinding keybind, String description, String category) {
        this.add(keybind, description);
        this.add(keybind.func_151466_e(), category);
    }

    public void add(KeyBinding keybind, String description) {
        this.add(keybind.func_151464_g(), description);
    }
}

