/*
 * Decompiled with CFR 0.152.
 */
package mrp_v2.mrplibrary.datagen.providers;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import mrp_v2.mrplibrary.datagen.BlockLootTables;
import mrp_v2.mrplibrary.util.IModLocProvider;
import net.minecraft.data.DataGenerator;
import net.minecraft.loot.LootParameterSet;
import net.minecraft.loot.LootParameterSets;
import net.minecraft.loot.LootTable;
import net.minecraft.loot.LootTableManager;
import net.minecraft.loot.ValidationTracker;
import net.minecraft.util.ResourceLocation;

public class LootTableProvider
extends net.minecraft.data.LootTableProvider
implements IModLocProvider {
    private final List<Pair<Supplier<Consumer<BiConsumer<ResourceLocation, LootTable.Builder>>>, LootParameterSet>> lootTables;
    private final String modId;

    public LootTableProvider(DataGenerator dataGeneratorIn, BlockLootTables blockLootTables, String modId) {
        this(dataGeneratorIn, () -> blockLootTables, modId);
    }

    public LootTableProvider(DataGenerator dataGeneratorIn, Supplier<Consumer<BiConsumer<ResourceLocation, LootTable.Builder>>> lootTablesProvider, String modId) {
        super(dataGeneratorIn);
        this.lootTables = ImmutableList.of((Object)Pair.of(lootTablesProvider, (Object)LootParameterSets.field_216267_h));
        this.modId = modId;
    }

    protected List<Pair<Supplier<Consumer<BiConsumer<ResourceLocation, LootTable.Builder>>>, LootParameterSet>> getTables() {
        return this.lootTables;
    }

    protected void validate(Map<ResourceLocation, LootTable> map, ValidationTracker validationtracker) {
        map.forEach((resourceLocation, lootTable) -> LootTableManager.func_227508_a_((ValidationTracker)validationtracker, (ResourceLocation)resourceLocation, (LootTable)lootTable));
    }

    public String func_200397_b() {
        return super.func_200397_b() + ": " + this.modId;
    }

    @Override
    public String getModId() {
        return this.modId;
    }
}

