/*
 * Decompiled with CFR 0.152.
 */
package mrp_v2.morewires.block;

import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import mrp_v2.morewires.block.AdjustedRedstoneDiodeBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.ComparatorBlock;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.entity.item.ItemFrameEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.ComparatorMode;
import net.minecraft.tileentity.ComparatorTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.TickPriority;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class AdjustedComparatorBlock
extends AdjustedRedstoneDiodeBlock
implements ITileEntityProvider {
    public static final EnumProperty<ComparatorMode> MODE = BlockStateProperties.field_208141_ap;
    private final ComparatorBlock vanilla = (ComparatorBlock)Blocks.field_196762_fd;

    public AdjustedComparatorBlock() {
        super(Block.Properties.func_200950_a((Block)Blocks.field_196762_fd));
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)field_185512_D, (Comparable)Direction.NORTH)).func_206870_a((IProperty)field_196348_c, (Comparable)Boolean.FALSE)).func_206870_a(MODE, (Comparable)ComparatorMode.COMPARE));
        this.setRegistryName(this.vanilla.getRegistryName());
    }

    private int calculateOutput(World worldIn, BlockPos pos, BlockState state) {
        return state.func_177229_b(MODE) == ComparatorMode.SUBTRACT ? Math.max(this.func_176397_f(worldIn, pos, state) - this.func_176407_c((IWorldReader)worldIn, pos, state), 0) : this.func_176397_f(worldIn, pos, state);
    }

    @Override
    protected int func_176397_f(World worldIn, BlockPos pos, BlockState state) {
        int i = super.func_176397_f(worldIn, pos, state);
        Direction direction = (Direction)state.func_177229_b((IProperty)field_185512_D);
        BlockPos blockpos = pos.func_177972_a(direction);
        BlockState blockstate = worldIn.func_180495_p(blockpos);
        if (blockstate.func_185912_n()) {
            i = blockstate.func_185888_a(worldIn, blockpos);
        } else if (i < 15 && blockstate.func_215686_e((IBlockReader)worldIn, blockpos)) {
            ItemFrameEntity itemframeentity;
            blockstate = worldIn.func_180495_p(blockpos = blockpos.func_177972_a(direction));
            if (blockstate.func_185912_n()) {
                i = blockstate.func_185888_a(worldIn, blockpos);
            } else if (blockstate.isAir((IBlockReader)worldIn, blockpos) && (itemframeentity = this.findItemFrame(worldIn, direction, blockpos)) != null) {
                i = itemframeentity.func_174866_q();
            }
        }
        return i;
    }

    @Nullable
    private ItemFrameEntity findItemFrame(World worldIn, Direction facing, BlockPos pos) {
        List entitiesWithinAABB = worldIn.func_175647_a(ItemFrameEntity.class, new AxisAlignedBB((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (double)(pos.func_177958_n() + 1), (double)(pos.func_177956_o() + 1), (double)(pos.func_177952_p() + 1)), itemFrameEntity -> itemFrameEntity != null && itemFrameEntity.func_174811_aO() == facing);
        return entitiesWithinAABB.size() == 1 ? (ItemFrameEntity)entitiesWithinAABB.get(0) : null;
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        if (!player.field_71075_bZ.field_75099_e) {
            return ActionResultType.PASS;
        }
        float f = (state = (BlockState)state.func_177231_a(MODE)).func_177229_b(MODE) == ComparatorMode.SUBTRACT ? 0.55f : 0.5f;
        worldIn.func_184133_a(player, pos, SoundEvents.field_187556_aj, SoundCategory.BLOCKS, 0.3f, f);
        worldIn.func_180501_a(pos, state, 2);
        this.onStateChange(worldIn, pos, state);
        return ActionResultType.SUCCESS;
    }

    public boolean func_189539_a(BlockState state, World worldIn, BlockPos pos, int id, int param) {
        return this.vanilla.func_189539_a(state, worldIn, pos, id, param);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{field_185512_D, MODE, field_196348_c});
    }

    private void onStateChange(World worldIn, BlockPos pos, BlockState state) {
        int output = this.calculateOutput(worldIn, pos, state);
        TileEntity tileEntity = worldIn.func_175625_s(pos);
        int j = 0;
        if (tileEntity instanceof ComparatorTileEntity) {
            ComparatorTileEntity comparatorTileEntity = (ComparatorTileEntity)tileEntity;
            j = comparatorTileEntity.func_145996_a();
            comparatorTileEntity.func_145995_a(output);
        }
        if (j != output || state.func_177229_b(MODE) == ComparatorMode.COMPARE) {
            boolean shouldBePowered = this.func_176404_e(worldIn, pos, state);
            boolean isPowered = (Boolean)state.func_177229_b((IProperty)field_196348_c);
            if (isPowered && !shouldBePowered) {
                worldIn.func_180501_a(pos, (BlockState)state.func_206870_a((IProperty)field_196348_c, (Comparable)Boolean.FALSE), 2);
            } else if (!isPowered && shouldBePowered) {
                worldIn.func_180501_a(pos, (BlockState)state.func_206870_a((IProperty)field_196348_c, (Comparable)Boolean.TRUE), 2);
            }
            this.func_176400_h(worldIn, pos, state);
        }
    }

    public void func_225534_a_(BlockState state, ServerWorld worldIn, BlockPos pos, Random rand) {
        this.onStateChange((World)worldIn, pos, state);
    }

    protected void func_176398_g(World worldIn, BlockPos pos, BlockState state) {
        if (!worldIn.func_205220_G_().func_205361_b(pos, (Object)this)) {
            int j;
            int i = this.calculateOutput(worldIn, pos, state);
            TileEntity tileentity = worldIn.func_175625_s(pos);
            int n = j = tileentity instanceof ComparatorTileEntity ? ((ComparatorTileEntity)tileentity).func_145996_a() : 0;
            if (i != j || ((Boolean)state.func_177229_b((IProperty)field_196348_c)).booleanValue() != this.func_176404_e(worldIn, pos, state)) {
                TickPriority tickpriority = this.func_176402_i((IBlockReader)worldIn, pos, state) ? TickPriority.HIGH : TickPriority.NORMAL;
                worldIn.func_205220_G_().func_205362_a(pos, (Object)this, 2, tickpriority);
            }
        }
    }

    protected boolean func_176404_e(World worldIn, BlockPos pos, BlockState state) {
        int i = this.func_176397_f(worldIn, pos, state);
        if (i == 0) {
            return false;
        }
        int j = this.func_176407_c((IWorldReader)worldIn, pos, state);
        if (i > j) {
            return true;
        }
        return i == j && state.func_177229_b(MODE) == ComparatorMode.COMPARE;
    }

    protected int func_176408_a(IBlockReader worldIn, BlockPos pos, BlockState state) {
        TileEntity tileentity = worldIn.func_175625_s(pos);
        return tileentity instanceof ComparatorTileEntity ? ((ComparatorTileEntity)tileentity).func_145996_a() : 0;
    }

    protected int func_196346_i(BlockState state) {
        return 2;
    }

    public TileEntity func_196283_a_(IBlockReader worldIn) {
        return this.vanilla.func_196283_a_(worldIn);
    }

    public void onNeighborChange(BlockState state, IWorldReader world, BlockPos pos, BlockPos neighbor) {
        this.vanilla.onNeighborChange(state, world, pos, neighbor);
    }

    public boolean getWeakChanges(BlockState state, IWorldReader world, BlockPos pos) {
        return this.vanilla.getWeakChanges(state, world, pos);
    }
}

