/*
 * Decompiled with CFR 0.152.
 */
package mrp_v2.morewires.block;

import java.awt.Color;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Random;
import javax.annotation.Nullable;
import mrp_v2.morewires.item.AdjustedRedstoneItem;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.RedstoneDiodeBlock;
import net.minecraft.block.RedstoneWireBlock;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.Items;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.RedstoneParticleData;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.RedstoneSide;
import net.minecraft.tags.Tag;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import org.apache.commons.lang3.tuple.Pair;

public class AdjustedRedstoneWireBlock
extends RedstoneWireBlock {
    private static final HashMap<AdjustedRedstoneWireBlock, HashMap<Integer, Pair<Integer, Vector3f>>> blockAndStrengthToColorMap = new HashMap();
    private static final HashSet<Block> redstoneWires = new HashSet();
    protected static boolean globalCanProvidePower = true;

    public AdjustedRedstoneWireBlock(float hueChange, String id) {
        this(Block.Properties.func_200950_a((Block)Blocks.field_150488_af), hueChange, id + "_wire");
    }

    protected AdjustedRedstoneWireBlock(Block.Properties properties, float hueChange, String id) {
        super(properties);
        this.setRegistryName(id);
        redstoneWires.add((Block)this);
        blockAndStrengthToColorMap.put(this, AdjustedRedstoneWireBlock.calculateColors(hueChange));
    }

    protected static HashMap<Integer, Pair<Integer, Vector3f>> calculateColors(float hueChange) {
        while (hueChange > 1.0f) {
            hueChange -= 1.0f;
        }
        while (hueChange < 0.0f) {
            hueChange += 1.0f;
        }
        HashMap<Integer, Pair<Integer, Vector3f>> colors = new HashMap<Integer, Pair<Integer, Vector3f>>();
        for (int i = 0; i <= 15; ++i) {
            int originalColorInt = RedstoneWireBlock.func_176337_b((int)i);
            float[] hsb = Color.RGBtoHSB(originalColorInt >> 16 & 0xFF, originalColorInt >> 8 & 0xFF, originalColorInt & 0xFF, null);
            hsb[0] = hsb[0] + hueChange;
            if (hsb[0] > 1.0f) {
                hsb[0] = hsb[0] - 1.0f;
            }
            int color = Color.HSBtoRGB(hsb[0], hsb[1], hsb[2]);
            Vector3f colorVec = new Vector3f((float)(color >> 16 & 0xFF) / 255.0f, (float)(color >> 8 & 0xFF) / 255.0f, (float)(color & 0xFF) / 255.0f);
            colors.put(i, (Pair<Integer, Vector3f>)Pair.of((Object)color, (Object)colorVec));
        }
        return colors;
    }

    public static boolean isWireBlock(BlockState state) {
        return AdjustedRedstoneWireBlock.isWireBlock(state.func_177230_c());
    }

    public static boolean isWireBlock(Block block) {
        return redstoneWires.contains(block);
    }

    public static int getColor(BlockState state) {
        return (Integer)blockAndStrengthToColorMap.get(state.func_177230_c()).get(state.func_177229_b((IProperty)field_176351_O)).getLeft();
    }

    public AdjustedRedstoneItem createBlockItem(Tag<Item> dyeTag) {
        AdjustedRedstoneItem item = new AdjustedRedstoneItem((Block)this, new Item.Properties().func_200916_a(ItemGroup.field_78028_d), dyeTag);
        if (this.getRegistryName().equals((Object)Blocks.field_150488_af.getRegistryName())) {
            item.setRegistryName(Items.field_151137_ax.getRegistryName());
        } else {
            item.setRegistryName(this.getRegistryName());
        }
        return item;
    }

    public int hashCode() {
        return this.getRegistryName().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AdjustedRedstoneWireBlock)) {
            return false;
        }
        AdjustedRedstoneWireBlock other = (AdjustedRedstoneWireBlock)((Object)obj);
        return this.getRegistryName().equals((Object)other.getRegistryName());
    }

    protected RedstoneSide func_208074_a(IBlockReader worldIn, BlockPos pos, Direction face) {
        BlockPos offsetPos = pos.func_177972_a(face);
        BlockState offsetState = worldIn.func_180495_p(offsetPos);
        BlockPos upPos = pos.func_177984_a();
        BlockState upState = worldIn.func_180495_p(upPos);
        if (!upState.func_215686_e(worldIn, upPos)) {
            boolean canPlaceOnTopOfOffset;
            boolean bl = canPlaceOnTopOfOffset = offsetState.func_224755_d(worldIn, offsetPos, Direction.UP) || offsetState.func_177230_c() == Blocks.field_150438_bZ;
            if (canPlaceOnTopOfOffset && this.canThisConnectTo(worldIn.func_180495_p(offsetPos.func_177984_a()), worldIn, offsetPos.func_177984_a(), null)) {
                if (offsetState.func_224756_o(worldIn, offsetPos)) {
                    return RedstoneSide.UP;
                }
                return RedstoneSide.SIDE;
            }
        }
        return !this.canThisConnectTo(offsetState, worldIn, offsetPos, face) && (offsetState.func_215686_e(worldIn, offsetPos) || !this.canThisConnectTo(worldIn.func_180495_p(offsetPos.func_177977_b()), worldIn, offsetPos.func_177977_b(), null)) ? RedstoneSide.NONE : RedstoneSide.SIDE;
    }

    protected BlockState func_212568_b(World worldIn, BlockPos pos, BlockState state) {
        int maxSignalMinus1;
        BlockState blockstate = state;
        int i = (Integer)state.func_177229_b((IProperty)field_176351_O);
        globalCanProvidePower = false;
        int j = worldIn.func_175687_A(pos);
        globalCanProvidePower = true;
        int maxSignal = 0;
        if (j < 15) {
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                BlockPos offsetPos = pos.func_177972_a(direction);
                BlockState offsetState = worldIn.func_180495_p(offsetPos);
                maxSignal = this.func_212567_a(maxSignal, offsetState);
                BlockPos upPos = pos.func_177984_a();
                if (offsetState.func_215686_e((IBlockReader)worldIn, offsetPos) && !worldIn.func_180495_p(upPos).func_215686_e((IBlockReader)worldIn, upPos)) {
                    maxSignal = this.func_212567_a(maxSignal, worldIn.func_180495_p(offsetPos.func_177984_a()));
                    continue;
                }
                if (offsetState.func_215686_e((IBlockReader)worldIn, offsetPos)) continue;
                maxSignal = this.func_212567_a(maxSignal, worldIn.func_180495_p(offsetPos.func_177977_b()));
            }
        }
        if (j > (maxSignalMinus1 = maxSignal - 1)) {
            maxSignalMinus1 = j;
        }
        if (i != maxSignalMinus1) {
            state = (BlockState)state.func_206870_a((IProperty)field_176351_O, (Comparable)Integer.valueOf(maxSignalMinus1));
            if (worldIn.func_180495_p(pos) == blockstate) {
                worldIn.func_180501_a(pos, state, 2);
            }
            this.field_150179_b.add(pos);
            for (Direction direction1 : Direction.values()) {
                this.field_150179_b.add(pos.func_177972_a(direction1));
            }
        }
        return state;
    }

    public int func_176211_b(BlockState blockState, IBlockReader blockAccess, BlockPos pos, Direction side) {
        return !globalCanProvidePower ? 0 : blockState.func_185911_a(blockAccess, pos, side);
    }

    public int func_180656_a(BlockState blockState, IBlockReader blockAccess, BlockPos pos, Direction side) {
        if (!globalCanProvidePower) {
            return 0;
        }
        int power = (Integer)blockState.func_177229_b((IProperty)field_176351_O);
        if (power == 0) {
            return 0;
        }
        if (side == Direction.UP) {
            return power;
        }
        EnumSet<Direction> connectedDirections = EnumSet.noneOf(Direction.class);
        for (Direction horizontalDir : Direction.Plane.HORIZONTAL) {
            if (!this.func_176339_d(blockAccess, pos, horizontalDir)) continue;
            connectedDirections.add(horizontalDir);
        }
        if (side.func_176740_k().func_176722_c() && connectedDirections.isEmpty()) {
            return power;
        }
        return connectedDirections.contains(side) && !connectedDirections.contains(side.func_176735_f()) && !connectedDirections.contains(side.func_176746_e()) ? power : 0;
    }

    protected boolean func_176339_d(IBlockReader worldIn, BlockPos pos, Direction side) {
        BlockPos sidePos = pos.func_177972_a(side);
        BlockState sideState = worldIn.func_180495_p(sidePos);
        boolean sideIsNormalCube = sideState.func_215686_e(worldIn, sidePos);
        BlockPos upPos = pos.func_177984_a();
        boolean upIsNormalCube = worldIn.func_180495_p(upPos).func_215686_e(worldIn, upPos);
        if (!upIsNormalCube && sideIsNormalCube && this.canThisConnectTo(worldIn.func_180495_p(sidePos.func_177984_a()), worldIn, sidePos.func_177984_a(), null)) {
            return true;
        }
        if (this.canThisConnectTo(sideState, worldIn, sidePos, side)) {
            return true;
        }
        if (sideState.func_177230_c() == Blocks.field_196633_cV && ((Boolean)sideState.func_177229_b((IProperty)RedstoneDiodeBlock.field_196348_c)).booleanValue() && sideState.func_177229_b((IProperty)RedstoneDiodeBlock.field_185512_D) == side) {
            return true;
        }
        return !sideIsNormalCube && this.canThisConnectTo(worldIn.func_180495_p(sidePos.func_177977_b()), worldIn, sidePos.func_177977_b(), null);
    }

    public boolean func_149744_f(BlockState state) {
        return globalCanProvidePower;
    }

    public void func_180655_c(BlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        int i = (Integer)stateIn.func_177229_b((IProperty)field_176351_O);
        Vector3f color = (Vector3f)blockAndStrengthToColorMap.get((Object)this).get(i).getRight();
        if (i != 0) {
            double d0 = (double)pos.func_177958_n() + 0.5 + ((double)rand.nextFloat() - 0.5) * 0.2;
            double d1 = (float)pos.func_177956_o() + 0.0625f;
            double d2 = (double)pos.func_177952_p() + 0.5 + ((double)rand.nextFloat() - 0.5) * 0.2;
            worldIn.func_195594_a((IParticleData)new RedstoneParticleData(color.func_195899_a(), color.func_195900_b(), color.func_195902_c(), 1.0f), d0, d1, d2, 0.0, 0.0, 0.0);
        }
    }

    protected boolean canThisConnectTo(BlockState blockState, IBlockReader world, BlockPos pos, @Nullable Direction side) {
        if (blockState.func_177230_c() == this) {
            return true;
        }
        if (redstoneWires.contains(blockState.func_177230_c())) {
            return false;
        }
        return RedstoneWireBlock.canConnectTo((BlockState)blockState, (IBlockReader)world, (BlockPos)pos, (Direction)side);
    }
}

