/*
 * Decompiled with CFR 0.152.
 */
package mrp_v2.morewires.block;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import mrp_v2.morewires.block.AdjustedRedstoneWireBlock;
import mrp_v2.morewires.item.AdjustedRedstoneItem;
import mrp_v2.morewires.item.InfiniwireItem;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.state.IProperty;
import net.minecraft.tags.Tag;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public class InfiniwireBlock
extends AdjustedRedstoneWireBlock {
    private boolean doingUpdate = false;

    public InfiniwireBlock(float hueChange, String id) {
        super(Block.Properties.func_200950_a((Block)Blocks.field_150488_af), hueChange, id + "_infiniwire");
    }

    @Override
    public AdjustedRedstoneItem createBlockItem(Tag<Item> dyeTag) {
        InfiniwireItem item = new InfiniwireItem((Block)this, new Item.Properties().func_200916_a(ItemGroup.field_78028_d), dyeTag);
        item.setRegistryName(this.getRegistryName());
        return item;
    }

    public void func_220082_b(BlockState state, World worldIn, BlockPos pos, BlockState oldState, boolean isMoving) {
        if (oldState.func_177230_c() == state.func_177230_c() || worldIn.field_72995_K) {
            return;
        }
        int test = this.getStrongestNonWireSignal(worldIn, pos);
        int neighborTest = this.getNeighborEquivalency(worldIn, pos);
        if (neighborTest == -2) {
            if (test != 0) {
                worldIn.func_175656_a(pos, (BlockState)state.func_206870_a((IProperty)field_176351_O, (Comparable)Integer.valueOf(test)));
                this.updateRelevantNeighbors(worldIn, pos);
            }
        } else if (neighborTest == -1) {
            this.updateChain(worldIn, pos);
        } else if (neighborTest >= test) {
            worldIn.func_175656_a(pos, (BlockState)state.func_206870_a((IProperty)field_176351_O, (Comparable)Integer.valueOf(neighborTest)));
            this.updateRelevantNeighbors(worldIn, pos);
        } else {
            this.updateChain(worldIn, pos);
        }
    }

    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.func_177230_c() == newState.func_177230_c() || isMoving) {
            return;
        }
        if (state.hasTileEntity() && (state.func_177230_c() != newState.func_177230_c() || !newState.hasTileEntity())) {
            worldIn.func_175713_t(pos);
        }
        if (worldIn.field_72995_K) {
            return;
        }
        if (newState.func_177230_c() == this || state.func_177230_c() != this) {
            return;
        }
        if ((Integer)state.func_177229_b((IProperty)field_176351_O) == 0) {
            this.updateRelevantNeighbors(worldIn, pos);
            return;
        }
        HashSet<HashMap<BlockPos, BlockState>> neighborChains = new HashSet<HashMap<BlockPos, BlockState>>();
        for (BlockPos blockPos : this.getConnectedWireNeighbors(worldIn, pos).keySet()) {
            neighborChains.add(this.getBlocksInChain(worldIn, blockPos));
        }
        if (neighborChains.size() > 1) {
            for (HashMap hashMap : neighborChains) {
                this.updateChain(worldIn, hashMap);
            }
        } else if (this.getStrongestNonWireSignal(worldIn, pos) == ((Integer)state.func_177229_b((IProperty)field_176351_O)).intValue()) {
            for (HashMap hashMap : neighborChains) {
                this.updateChain(worldIn, hashMap);
            }
        }
        this.updateRelevantNeighbors(worldIn, pos);
    }

    public void func_220069_a(BlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        if (worldIn.field_72995_K) {
            return;
        }
        if (state.func_196955_c((IWorldReader)worldIn, pos)) {
            BlockState neighborState = worldIn.func_180495_p(fromPos);
            if (InfiniwireBlock.isWireBlock(neighborState) || InfiniwireBlock.isWireBlock(blockIn)) {
                return;
            }
            this.updateChain(worldIn, pos);
        } else {
            InfiniwireBlock.func_220075_c((BlockState)state, (World)worldIn, (BlockPos)pos);
            worldIn.func_217377_a(pos, false);
        }
    }

    private int getStrongestNonWireSignal(World world, BlockPos pos) {
        globalCanProvidePower = false;
        int strongest = world.func_175687_A(pos);
        globalCanProvidePower = true;
        return strongest;
    }

    private int getNeighborEquivalency(World world, BlockPos pos) {
        int foundPower = -2;
        for (Map.Entry<BlockPos, BlockState> neighbor : this.getConnectedWireNeighbors(world, pos).entrySet()) {
            int neighborPower = (Integer)neighbor.getValue().func_177229_b((IProperty)field_176351_O);
            if (foundPower == -2) {
                foundPower = neighborPower;
                continue;
            }
            if (neighborPower == foundPower) continue;
            return -1;
        }
        return foundPower;
    }

    private HashMap<BlockPos, BlockState> getConnectedWireNeighbors(World world, BlockPos pos) {
        HashMap<BlockPos, BlockState> relevantWireNeighbors = new HashMap<BlockPos, BlockState>();
        for (Direction horizontalDirection : Direction.Plane.HORIZONTAL) {
            BlockPos neighborPos = pos.func_177972_a(horizontalDirection);
            BlockState neighborState = world.func_180495_p(neighborPos);
            if (neighborState.func_215686_e((IBlockReader)world, neighborPos)) {
                BlockPos neighborUp;
                BlockState neighborUpState;
                BlockPos thisUp = pos.func_177984_a();
                if (world.func_180495_p(thisUp).func_215686_e((IBlockReader)world, thisUp) || (neighborUpState = world.func_180495_p(neighborUp = neighborPos.func_177984_a())).func_177230_c() != this) continue;
                relevantWireNeighbors.put(neighborUp, neighborUpState);
                continue;
            }
            BlockPos neighborDown = neighborPos.func_177977_b();
            if (neighborState.func_177230_c() == this) {
                relevantWireNeighbors.put(neighborPos, neighborState);
                continue;
            }
            BlockState neighborDownState = world.func_180495_p(neighborDown);
            if (neighborDownState.func_177230_c() != this) continue;
            relevantWireNeighbors.put(neighborDown, neighborDownState);
        }
        return relevantWireNeighbors;
    }

    private void updateRelevantNeighbors(World world, BlockPos pos) {
        for (BlockPos updatePos : this.getRelevantUpdateNeighbors(pos)) {
            world.func_195593_d(updatePos, (Block)this);
        }
    }

    private HashSet<BlockPos> getRelevantUpdateNeighbors(BlockPos pos) {
        HashSet<BlockPos> relevantNeighbors = new HashSet<BlockPos>();
        relevantNeighbors.add(pos);
        for (Direction direction : Direction.values()) {
            relevantNeighbors.add(pos.func_177972_a(direction));
        }
        return relevantNeighbors;
    }

    private void updateChain(World world, HashMap<BlockPos, BlockState> chain) {
        if (this.doingUpdate) {
            return;
        }
        int newStrength = this.getStrongestNonWireSignal(world, chain.keySet());
        this.doingUpdate = true;
        this.updateNeighbors(world, this.updateInfiniwireChain(world, chain, newStrength));
        this.doingUpdate = false;
    }

    private void updateNeighbors(World world, HashSet<BlockPos> updatedBlocks) {
        HashSet<BlockPos> toUpdate = new HashSet<BlockPos>();
        for (BlockPos pos : updatedBlocks) {
            toUpdate.addAll(this.getRelevantUpdateNeighbors(pos));
        }
        for (BlockPos updatePos : toUpdate) {
            world.func_195593_d(updatePos, (Block)this);
        }
    }

    private HashSet<BlockPos> updateInfiniwireChain(World world, HashMap<BlockPos, BlockState> chain, int strength) {
        HashSet<BlockPos> updatedBlocks = new HashSet<BlockPos>();
        for (Map.Entry<BlockPos, BlockState> entry : chain.entrySet()) {
            if (strength == (Integer)entry.getValue().func_177229_b((IProperty)field_176351_O)) continue;
            world.func_180501_a(entry.getKey(), (BlockState)entry.getValue().func_206870_a((IProperty)field_176351_O, (Comparable)Integer.valueOf(strength)), 2);
            updatedBlocks.add(entry.getKey());
        }
        return updatedBlocks;
    }

    private int getStrongestNonWireSignal(World world, Set<BlockPos> chain) {
        int strongest = 0;
        globalCanProvidePower = false;
        for (BlockPos pos : chain) {
            int test = world.func_175687_A(pos);
            if (test <= strongest) continue;
            strongest = test;
        }
        globalCanProvidePower = true;
        return strongest;
    }

    private void updateChain(World world, BlockPos pos) {
        if (this.doingUpdate) {
            return;
        }
        HashMap<BlockPos, BlockState> chain = this.getBlocksInChain(world, pos);
        this.updateChain(world, chain);
    }

    private HashMap<BlockPos, BlockState> getBlocksInChain(World world, BlockPos pos) {
        HashMap<BlockPos, BlockState> blocks = new HashMap<BlockPos, BlockState>();
        BlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() == this) {
            blocks.put(pos, state);
            this.getBlocksInChain(world, pos, blocks);
        }
        return blocks;
    }

    private void getBlocksInChain(World world, BlockPos pos, HashMap<BlockPos, BlockState> foundBlocks) {
        for (Map.Entry<BlockPos, BlockState> neighbor : this.getConnectedWireNeighbors(world, pos).entrySet()) {
            if (foundBlocks.put(neighbor.getKey(), neighbor.getValue()) != null) continue;
            this.getBlocksInChain(world, neighbor.getKey(), foundBlocks);
        }
    }
}

