/*
 * Decompiled with CFR 0.152.
 */
package mrp_v2.morewires.datagen;

import mrp_v2.morewires.block.AdjustedRedstoneWireBlock;
import mrp_v2.morewires.block.InfiniwireBlock;
import mrp_v2.morewires.util.ObjectHolder;
import mrp_v2.morewires.util.Util;
import net.minecraft.block.Block;
import net.minecraft.block.RedstoneWireBlock;
import net.minecraft.data.DataGenerator;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.RedstoneSide;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ExistingFileHelper;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.client.model.generators.MultiPartBlockStateBuilder;
import org.apache.commons.lang3.tuple.Pair;

public class BlockStateGenerator
extends BlockStateProvider {
    private final ExistingFileHelper existingFileHelper;

    public BlockStateGenerator(DataGenerator gen, ExistingFileHelper exFileHelper) {
        super(gen, "morewires", exFileHelper);
        this.existingFileHelper = exFileHelper;
    }

    protected void registerStatesAndModels() {
        Pair particleDot = Pair.of((Object)"particle", (Object)"dot");
        Pair line0 = Pair.of((Object)"line", (Object)"line0");
        Pair line1 = Pair.of((Object)"line", (Object)"line1");
        this.registerModel("dot", particleDot, Pair.of((Object)"line", (Object)"dot"));
        this.registerModel("side", particleDot);
        this.registerModel("side0", line0);
        this.registerModel("side1", line1);
        this.registerModel("side_alt", particleDot);
        this.registerModel("side_alt0", line0);
        this.registerModel("side_alt1", line1);
        this.registerModel("up", particleDot, line0);
        this.registerWireStates();
        this.registerInfiniwireStates();
    }

    public String func_200397_b() {
        return super.func_200397_b() + ": " + "morewires";
    }

    @SafeVarargs
    private final void registerModel(String suffix, Pair<String, String> ... textures) {
        ModelBuilder modelBuilder = this.models().withExistingParent("morewires:block/infiniwire_" + suffix, "minecraft:block/redstone_dust_" + suffix);
        for (Pair<String, String> texture : textures) {
            modelBuilder = modelBuilder.texture((String)texture.getLeft(), Util.makeResourceLocation("block", "infiniwire_" + (String)texture.getRight()));
        }
    }

    private void registerWireStates() {
        for (AdjustedRedstoneWireBlock block : ObjectHolder.WIRE_BLOCKS_EXCLUDING_REDSTONE) {
            this.registerWireBasedStates(block, "redstone_dust", true);
        }
    }

    private void registerInfiniwireStates() {
        for (InfiniwireBlock block : ObjectHolder.INFINIWIRE_BLOCKS) {
            this.registerWireBasedStates(block, "infiniwire", false);
        }
    }

    private void registerWireBasedStates(AdjustedRedstoneWireBlock wireBasedBlock, String stem, boolean vanillaModel) {
        ModelFile.ExistingModelFile dotModel = this.getModel(vanillaModel, "block/" + stem + "_dot");
        ModelFile.ExistingModelFile upModel = this.getModel(vanillaModel, "block/" + stem + "_up");
        ModelFile.ExistingModelFile side0Model = this.getModel(vanillaModel, "block/" + stem + "_side0");
        ModelFile.ExistingModelFile side1Model = this.getModel(vanillaModel, "block/" + stem + "_side1");
        ModelFile.ExistingModelFile sideAlt0Model = this.getModel(vanillaModel, "block/" + stem + "_side_alt0");
        ModelFile.ExistingModelFile sideAlt1Model = this.getModel(vanillaModel, "block/" + stem + "_side_alt1");
        ((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)this.getMultipartBuilder((Block)wireBasedBlock).part().modelFile((ModelFile)dotModel).addModel()).condition((IProperty)RedstoneWireBlock.field_176348_a, (Comparable[])new RedstoneSide[]{RedstoneSide.NONE}).condition((IProperty)RedstoneWireBlock.field_176349_M, (Comparable[])new RedstoneSide[]{RedstoneSide.NONE}).condition((IProperty)RedstoneWireBlock.field_176347_b, (Comparable[])new RedstoneSide[]{RedstoneSide.NONE}).condition((IProperty)RedstoneWireBlock.field_176350_N, (Comparable[])new RedstoneSide[]{RedstoneSide.NONE}).end().part().modelFile((ModelFile)dotModel).addModel()).condition((IProperty)RedstoneWireBlock.field_176348_a, (Comparable[])new RedstoneSide[]{RedstoneSide.SIDE, RedstoneSide.UP}).condition((IProperty)RedstoneWireBlock.field_176347_b, (Comparable[])new RedstoneSide[]{RedstoneSide.SIDE, RedstoneSide.UP}).end().part().modelFile((ModelFile)dotModel).addModel()).condition((IProperty)RedstoneWireBlock.field_176349_M, (Comparable[])new RedstoneSide[]{RedstoneSide.SIDE, RedstoneSide.UP}).condition((IProperty)RedstoneWireBlock.field_176347_b, (Comparable[])new RedstoneSide[]{RedstoneSide.SIDE, RedstoneSide.UP}).end().part().modelFile((ModelFile)dotModel).addModel()).condition((IProperty)RedstoneWireBlock.field_176349_M, (Comparable[])new RedstoneSide[]{RedstoneSide.SIDE, RedstoneSide.UP}).condition((IProperty)RedstoneWireBlock.field_176350_N, (Comparable[])new RedstoneSide[]{RedstoneSide.SIDE, RedstoneSide.UP}).end().part().modelFile((ModelFile)dotModel).addModel()).condition((IProperty)RedstoneWireBlock.field_176348_a, (Comparable[])new RedstoneSide[]{RedstoneSide.SIDE, RedstoneSide.UP}).condition((IProperty)RedstoneWireBlock.field_176350_N, (Comparable[])new RedstoneSide[]{RedstoneSide.SIDE, RedstoneSide.UP}).end().part().modelFile((ModelFile)side0Model).addModel()).condition((IProperty)RedstoneWireBlock.field_176348_a, (Comparable[])new RedstoneSide[]{RedstoneSide.SIDE, RedstoneSide.UP}).end().part().modelFile((ModelFile)side0Model).addModel()).condition((IProperty)RedstoneWireBlock.field_176348_a, (Comparable[])new RedstoneSide[]{RedstoneSide.NONE}).condition((IProperty)RedstoneWireBlock.field_176347_b, (Comparable[])new RedstoneSide[]{RedstoneSide.NONE}).condition((IProperty)RedstoneWireBlock.field_176349_M, (Comparable[])new RedstoneSide[]{RedstoneSide.SIDE, RedstoneSide.UP}).condition((IProperty)RedstoneWireBlock.field_176350_N, (Comparable[])new RedstoneSide[]{RedstoneSide.NONE}).end().part().modelFile((ModelFile)sideAlt0Model).addModel()).condition((IProperty)RedstoneWireBlock.field_176349_M, (Comparable[])new RedstoneSide[]{RedstoneSide.SIDE, RedstoneSide.UP}).end().part().modelFile((ModelFile)sideAlt0Model).addModel()).condition((IProperty)RedstoneWireBlock.field_176348_a, (Comparable[])new RedstoneSide[]{RedstoneSide.SIDE, RedstoneSide.UP}).condition((IProperty)RedstoneWireBlock.field_176347_b, (Comparable[])new RedstoneSide[]{RedstoneSide.NONE}).condition((IProperty)RedstoneWireBlock.field_176349_M, (Comparable[])new RedstoneSide[]{RedstoneSide.NONE}).condition((IProperty)RedstoneWireBlock.field_176350_N, (Comparable[])new RedstoneSide[]{RedstoneSide.NONE}).end().part().modelFile((ModelFile)sideAlt1Model).rotationY(270).addModel()).condition((IProperty)RedstoneWireBlock.field_176347_b, (Comparable[])new RedstoneSide[]{RedstoneSide.SIDE, RedstoneSide.UP}).end().part().modelFile((ModelFile)sideAlt1Model).rotationY(270).addModel()).condition((IProperty)RedstoneWireBlock.field_176348_a, (Comparable[])new RedstoneSide[]{RedstoneSide.NONE}).condition((IProperty)RedstoneWireBlock.field_176347_b, (Comparable[])new RedstoneSide[]{RedstoneSide.NONE}).condition((IProperty)RedstoneWireBlock.field_176349_M, (Comparable[])new RedstoneSide[]{RedstoneSide.NONE}).condition((IProperty)RedstoneWireBlock.field_176350_N, (Comparable[])new RedstoneSide[]{RedstoneSide.SIDE, RedstoneSide.UP}).end().part().modelFile((ModelFile)side1Model).rotationY(270).addModel()).condition((IProperty)RedstoneWireBlock.field_176350_N, (Comparable[])new RedstoneSide[]{RedstoneSide.SIDE, RedstoneSide.UP}).end().part().modelFile((ModelFile)side1Model).rotationY(270).addModel()).condition((IProperty)RedstoneWireBlock.field_176348_a, (Comparable[])new RedstoneSide[]{RedstoneSide.NONE}).condition((IProperty)RedstoneWireBlock.field_176347_b, (Comparable[])new RedstoneSide[]{RedstoneSide.SIDE, RedstoneSide.UP}).condition((IProperty)RedstoneWireBlock.field_176349_M, (Comparable[])new RedstoneSide[]{RedstoneSide.NONE}).condition((IProperty)RedstoneWireBlock.field_176350_N, (Comparable[])new RedstoneSide[]{RedstoneSide.NONE}).end().part().modelFile((ModelFile)upModel).addModel()).condition((IProperty)RedstoneWireBlock.field_176348_a, (Comparable[])new RedstoneSide[]{RedstoneSide.UP}).end().part().modelFile((ModelFile)upModel).rotationY(90).addModel()).condition((IProperty)RedstoneWireBlock.field_176347_b, (Comparable[])new RedstoneSide[]{RedstoneSide.UP}).end().part().modelFile((ModelFile)upModel).rotationY(180).addModel()).condition((IProperty)RedstoneWireBlock.field_176349_M, (Comparable[])new RedstoneSide[]{RedstoneSide.UP}).end().part().modelFile((ModelFile)upModel).rotationY(270).addModel()).condition((IProperty)RedstoneWireBlock.field_176350_N, (Comparable[])new RedstoneSide[]{RedstoneSide.UP}).end();
    }

    private ModelFile.ExistingModelFile getModel(boolean vanilla, String path) {
        ResourceLocation location = vanilla ? this.mcLoc(path) : this.modLoc(path);
        return new ModelFile.ExistingModelFile(location, this.existingFileHelper);
    }
}

