/*
 * Decompiled with CFR 0.152.
 */
package mrp_v2.morewires.datagen;

import java.util.function.Consumer;
import mrp_v2.morewires.item.AdjustedRedstoneItem;
import mrp_v2.morewires.util.ObjectHolder;
import mrp_v2.morewires.util.Util;
import net.minecraft.advancements.ICriterionInstance;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.data.RecipeProvider;
import net.minecraft.data.ShapelessRecipeBuilder;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.tags.Tag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.registry.Registry;
import net.minecraftforge.common.Tags;

public class RecipeGenerator
extends RecipeProvider {
    public static final String DYEING_ID = "dyeing";

    public RecipeGenerator(DataGenerator generatorIn) {
        super(generatorIn);
    }

    protected void func_200404_a(Consumer<IFinishedRecipe> iFinishedRecipeConsumer) {
        this.makeWireRecipes(iFinishedRecipeConsumer);
        this.makeInfiniwireRecipes(iFinishedRecipeConsumer);
    }

    public String func_200397_b() {
        return super.func_200397_b() + ": " + "morewires";
    }

    private void makeWireRecipes(Consumer<IFinishedRecipe> iFinishedRecipeConsumer) {
        for (AdjustedRedstoneItem item : ObjectHolder.WIRE_BLOCK_ITEMS_EXCLUDING_REDSTONE) {
            this.makeDyeingWireRecipe(iFinishedRecipeConsumer, (IItemProvider)item, item.getDyeTag());
        }
    }

    private void makeDyeingWireRecipe(Consumer<IFinishedRecipe> iFinishedRecipeConsumer, IItemProvider result, Tag<Item> dyeTag) {
        ShapelessRecipeBuilder.func_200488_a((IItemProvider)result, (int)8).func_200492_a(Ingredient.func_199805_a(ObjectHolder.WIRES_TAG), 8).func_203221_a(dyeTag).func_200483_a("has_wire", (ICriterionInstance)this.func_200409_a(ObjectHolder.WIRES_TAG)).func_200490_a(result.func_199767_j().getRegistryName().func_110623_a()).func_200485_a(iFinishedRecipeConsumer, Util.makeResourceLocation(DYEING_ID, RecipeGenerator.getID(result)));
    }

    private static String getID(IItemProvider item) {
        return Registry.field_212630_s.func_177774_c((Object)item.func_199767_j()).func_110623_a();
    }

    private void makeInfiniwireRecipes(Consumer<IFinishedRecipe> iFinishedRecipeConsumer) {
        for (int i = 0; i < ObjectHolder.INFINIWIRE_BLOCK_ITEMS.length; ++i) {
            AdjustedRedstoneItem item = ObjectHolder.INFINIWIRE_BLOCK_ITEMS[i];
            if (item.getRegistryName().equals((Object)Items.field_151137_ax.getRegistryName())) {
                this.makeDyedInfiniwireRecipe(iFinishedRecipeConsumer, (IItemProvider)item, (Tag<Item>)Tags.Items.DUSTS_REDSTONE);
            } else {
                this.makeDyedInfiniwireRecipe(iFinishedRecipeConsumer, (IItemProvider)item, (IItemProvider)ObjectHolder.WIRE_BLOCK_ITEMS[i]);
            }
            this.makeDyeingInfiniwireRecipe(iFinishedRecipeConsumer, (IItemProvider)item, item.getDyeTag());
        }
    }

    private void makeDyedInfiniwireRecipe(Consumer<IFinishedRecipe> iFinishedRecipeConsumer, IItemProvider result, IItemProvider ingredient) {
        ShapelessRecipeBuilder.func_200488_a((IItemProvider)result, (int)8).func_200491_b(ingredient, 8).func_203221_a(Tags.Items.INGOTS_IRON).func_200483_a("has_wire", (ICriterionInstance)this.func_200403_a(ingredient)).func_200490_a(result.func_199767_j().getRegistryName().func_110623_a()).func_200482_a(iFinishedRecipeConsumer);
    }

    private void makeDyeingInfiniwireRecipe(Consumer<IFinishedRecipe> iFinishedRecipeConsumer, IItemProvider result, Tag<Item> dyeTag) {
        ShapelessRecipeBuilder.func_200488_a((IItemProvider)result, (int)8).func_200492_a(Ingredient.func_199805_a(ObjectHolder.INFINIWIRES_TAG), 8).func_203221_a(dyeTag).func_200483_a("has_infiniwire", (ICriterionInstance)this.func_200409_a(ObjectHolder.INFINIWIRES_TAG)).func_200490_a(result.func_199767_j().getRegistryName().func_110623_a()).func_200485_a(iFinishedRecipeConsumer, Util.makeResourceLocation(DYEING_ID, RecipeGenerator.getID(result)));
    }

    private void makeDyedInfiniwireRecipe(Consumer<IFinishedRecipe> iFinishedRecipeConsumer, IItemProvider result, Tag<Item> ingredient) {
        ShapelessRecipeBuilder.func_200488_a((IItemProvider)result, (int)8).func_200492_a(Ingredient.func_199805_a(ingredient), 8).func_203221_a(Tags.Items.INGOTS_IRON).func_200483_a("has_wire", (ICriterionInstance)this.func_200409_a(ingredient)).func_200490_a(result.func_199767_j().getRegistryName().func_110623_a()).func_200482_a(iFinishedRecipeConsumer);
    }
}

