/*
 * Decompiled with CFR 0.152.
 */
package mrp_v2.morewires.util;

import com.mojang.datafixers.DataFixUtils;
import com.mojang.datafixers.types.Type;
import java.util.ArrayList;
import mrp_v2.morewires.block.AdjustedComparatorBlock;
import mrp_v2.morewires.block.AdjustedRedstoneWireBlock;
import mrp_v2.morewires.block.AdjustedRepeaterBlock;
import mrp_v2.morewires.block.InfiniwireBlock;
import mrp_v2.morewires.item.AdjustedRedstoneItem;
import mrp_v2.morewires.util.Util;
import net.minecraft.block.Block;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.Tag;
import net.minecraft.tileentity.ComparatorTileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.SharedConstants;
import net.minecraft.util.datafix.DataFixesManager;
import net.minecraft.util.datafix.TypeReferences;
import net.minecraftforge.common.Tags;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.commons.lang3.tuple.Triple;
import org.apache.logging.log4j.LogManager;

@Mod.EventBusSubscriber(modid="morewires", bus=Mod.EventBusSubscriber.Bus.MOD)
public class ObjectHolder {
    public static final AdjustedRedstoneWireBlock[] WIRE_BLOCKS;
    public static final AdjustedRedstoneWireBlock[] WIRE_BLOCKS_EXCLUDING_REDSTONE;
    public static final AdjustedRedstoneItem[] WIRE_BLOCK_ITEMS;
    public static final AdjustedRedstoneItem[] WIRE_BLOCK_ITEMS_EXCLUDING_REDSTONE;
    public static final InfiniwireBlock[] INFINIWIRE_BLOCKS;
    public static final AdjustedRedstoneItem[] INFINIWIRE_BLOCK_ITEMS;
    public static final ArrayList<Triple<Float, String, Tag<Item>>> COLORS;
    public static final Tag<Item> WIRES_TAG;
    public static final Tag<Item> INFINIWIRES_TAG;
    public static final AdjustedComparatorBlock ADJUSTED_COMPARATOR_BLOCK;
    private static final ArrayList<Item> queuedItems;

    @SubscribeEvent
    public static void registerBlocks(RegistryEvent.Register<Block> event) {
        Util.doOperationOn(arg_0 -> ((IForgeRegistry)event.getRegistry()).register(arg_0), WIRE_BLOCKS);
        Util.doOperationOn(arg_0 -> ((IForgeRegistry)event.getRegistry()).register(arg_0), INFINIWIRE_BLOCKS);
        event.getRegistry().registerAll((IForgeRegistryEntry[])new Block[]{ObjectHolder.queueRedstoneGroupBlockItem((Block)ADJUSTED_COMPARATOR_BLOCK), ObjectHolder.queueRedstoneGroupBlockItem((Block)new AdjustedRepeaterBlock())});
    }

    private static Block queueRedstoneGroupBlockItem(Block block) {
        BlockItem blockItem = new BlockItem(block, new Item.Properties().func_200916_a(ItemGroup.field_78028_d));
        blockItem.setRegistryName(block.getRegistryName());
        queuedItems.add((Item)blockItem);
        return block;
    }

    @SubscribeEvent
    public static void registerItems(RegistryEvent.Register<Item> event) {
        Util.doOperationOn(arg_0 -> ((IForgeRegistry)event.getRegistry()).register(arg_0), WIRE_BLOCK_ITEMS);
        Util.doOperationOn(arg_0 -> ((IForgeRegistry)event.getRegistry()).register(arg_0), INFINIWIRE_BLOCK_ITEMS);
        event.getRegistry().registerAll((IForgeRegistryEntry[])queuedItems.toArray(new Item[0]));
        queuedItems.clear();
    }

    @SubscribeEvent
    public static void registerTileEntityTypes(RegistryEvent.Register<TileEntityType<?>> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])new TileEntityType[]{ObjectHolder.createAdjustedComparatorTileEntityType()});
    }

    private static TileEntityType<ComparatorTileEntity> createAdjustedComparatorTileEntityType() {
        Type type;
        TileEntityType.Builder builder;
        String key;
        block2: {
            key = "comparator";
            builder = TileEntityType.Builder.func_223042_a(ComparatorTileEntity::new, (Block[])new Block[]{ADJUSTED_COMPARATOR_BLOCK});
            type = null;
            try {
                type = DataFixesManager.func_210901_a().getSchema(DataFixUtils.makeKey((int)SharedConstants.func_215069_a().getWorldVersion())).getChoiceType(TypeReferences.field_211294_j, key);
            }
            catch (IllegalArgumentException illegalargumentexception) {
                LogManager.getLogger().error("No data fixer registered for block entity {}", (Object)key);
                if (!SharedConstants.field_206244_b) break block2;
                throw illegalargumentexception;
            }
        }
        TileEntityType tileEntityType = builder.func_206865_a(type);
        tileEntityType.setRegistryName(key);
        return tileEntityType;
    }

    static {
        COLORS = new ArrayList();
        WIRES_TAG = new ItemTags.Wrapper(Util.makeResourceLocation("wires"));
        INFINIWIRES_TAG = new ItemTags.Wrapper(Util.makeResourceLocation("infiniwires"));
        ADJUSTED_COMPARATOR_BLOCK = new AdjustedComparatorBlock();
        queuedItems = new ArrayList();
        COLORS.add((Triple<Float, String, Tag<Item>>)Triple.of((Object)Float.valueOf(0.0f), (Object)"red", (Object)Tags.Items.DYES_RED));
        COLORS.add((Triple<Float, String, Tag<Item>>)Triple.of((Object)Float.valueOf(0.6666667f), (Object)"blue", (Object)Tags.Items.DYES_BLUE));
        COLORS.add((Triple<Float, String, Tag<Item>>)Triple.of((Object)Float.valueOf(0.33333334f), (Object)"green", (Object)Tags.Items.DYES_GREEN));
        COLORS.add((Triple<Float, String, Tag<Item>>)Triple.of((Object)Float.valueOf(0.083333336f), (Object)"orange", (Object)Tags.Items.DYES_ORANGE));
        COLORS.add((Triple<Float, String, Tag<Item>>)Triple.of((Object)Float.valueOf(0.8333333f), (Object)"pink", (Object)Tags.Items.DYES_PINK));
        COLORS.add((Triple<Float, String, Tag<Item>>)Triple.of((Object)Float.valueOf(0.16666667f), (Object)"yellow", (Object)Tags.Items.DYES_YELLOW));
        WIRE_BLOCKS = new AdjustedRedstoneWireBlock[COLORS.size()];
        WIRE_BLOCKS_EXCLUDING_REDSTONE = new AdjustedRedstoneWireBlock[COLORS.size() - 1];
        WIRE_BLOCK_ITEMS = new AdjustedRedstoneItem[COLORS.size()];
        WIRE_BLOCK_ITEMS_EXCLUDING_REDSTONE = new AdjustedRedstoneItem[COLORS.size() - 1];
        int i = 0;
        ObjectHolder.WIRE_BLOCKS[i] = new AdjustedRedstoneWireBlock(((Float)COLORS.get(i).getLeft()).floatValue(), "minecraft:redstone");
        ObjectHolder.WIRE_BLOCK_ITEMS[i] = WIRE_BLOCKS[i].createBlockItem((Tag<Item>)((Tag)COLORS.get(i).getRight()));
        ++i;
        for (Triple<Float, String, Tag<Item>> color : COLORS.subList(1, COLORS.size())) {
            ObjectHolder.WIRE_BLOCKS[i] = new AdjustedRedstoneWireBlock(((Float)color.getLeft()).floatValue(), (String)color.getMiddle());
            ObjectHolder.WIRE_BLOCKS_EXCLUDING_REDSTONE[i - 1] = WIRE_BLOCKS[i];
            ObjectHolder.WIRE_BLOCK_ITEMS[i] = WIRE_BLOCKS[i].createBlockItem((Tag<Item>)((Tag)color.getRight()));
            ObjectHolder.WIRE_BLOCK_ITEMS_EXCLUDING_REDSTONE[i - 1] = WIRE_BLOCK_ITEMS[i];
            ++i;
        }
        INFINIWIRE_BLOCKS = new InfiniwireBlock[COLORS.size()];
        INFINIWIRE_BLOCK_ITEMS = new AdjustedRedstoneItem[COLORS.size()];
        i = 0;
        for (Triple<Float, String, Tag<Item>> color : COLORS) {
            ObjectHolder.INFINIWIRE_BLOCKS[i] = new InfiniwireBlock(((Float)color.getLeft()).floatValue(), (String)color.getMiddle());
            ObjectHolder.INFINIWIRE_BLOCK_ITEMS[i] = INFINIWIRE_BLOCKS[i].createBlockItem((Tag<Item>)((Tag)color.getRight()));
            ++i;
        }
    }
}

