/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.mysterymilk.item;

import java.util.function.BiConsumer;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.UseAction;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tags.Tag;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvents;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fluids.capability.wrappers.FluidBucketWrapper;

public class ItemMysteryMilk
extends Item {
    private final int useTicks;
    private final BiConsumer<World, ServerPlayerEntity> effect;
    private final Predicate<Entity> milkingPredicate;

    public ItemMysteryMilk(int useTicks, Tag<Entity> type, BiConsumer<World, ServerPlayerEntity> effect) {
        this(useTicks, (Entity e) -> type.func_199685_a_(e), effect);
    }

    public ItemMysteryMilk(int useTicks, EntityType<?> type, BiConsumer<World, ServerPlayerEntity> effect) {
        this(useTicks, (Entity e) -> e.func_200600_R() == type, effect);
    }

    public ItemMysteryMilk(int useTicks, Predicate<Entity> milkingPredicate, BiConsumer<World, ServerPlayerEntity> effect) {
        super(new Item.Properties().func_200917_a(1).func_200919_a(Items.field_151133_ar));
        this.useTicks = useTicks;
        this.milkingPredicate = milkingPredicate;
        this.effect = effect;
        MinecraftForge.EVENT_BUS.addListener(this::tryToMilk);
    }

    private void tryToMilk(PlayerInteractEvent.EntityInteract event) {
        ItemStack heldItem = event.getItemStack();
        PlayerEntity player = event.getPlayer();
        if (this.milkingPredicate.test(event.getTarget()) && heldItem.func_77973_b() == Items.field_151133_ar && !player.field_71075_bZ.field_75098_d && !event.getEntityLiving().func_70631_g_()) {
            player.func_184185_a(SoundEvents.field_187564_an, 1.0f, 1.0f);
            heldItem.func_190918_g(1);
            if (heldItem.func_190926_b()) {
                player.func_184611_a(event.getHand(), new ItemStack((IItemProvider)this));
            } else if (!player.field_71071_by.func_70441_a(new ItemStack((IItemProvider)this))) {
                player.func_71019_a(new ItemStack((IItemProvider)this), false);
            }
        }
    }

    public ItemStack func_77654_b(ItemStack stack, World world, LivingEntity living) {
        if (living instanceof ServerPlayerEntity) {
            this.effect.accept(world, (ServerPlayerEntity)living);
        }
        if (living instanceof PlayerEntity && !((PlayerEntity)living).field_71075_bZ.field_75098_d) {
            stack.func_190918_g(1);
        }
        return stack.func_190926_b() ? new ItemStack((IItemProvider)Items.field_151133_ar) : stack;
    }

    public int func_77626_a(ItemStack stack) {
        return this.useTicks;
    }

    public UseAction func_77661_b(ItemStack stack) {
        return UseAction.DRINK;
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        player.func_184598_c(hand);
        return ActionResult.func_226248_a_((Object)player.func_184586_b(hand));
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundNBT nbt) {
        return new FluidBucketWrapper(stack);
    }
}

