/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.mysterymilk;

import net.darkhax.bookshelf.crafting.brewing.BrewingRecipePotion;
import net.darkhax.bookshelf.item.ItemGroupBase;
import net.darkhax.bookshelf.potion.ModPotion;
import net.darkhax.bookshelf.registry.RegistryHelper;
import net.darkhax.mysterymilk.item.ItemMysteryMilk;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.monster.RavagerEntity;
import net.minecraft.entity.monster.SlimeEntity;
import net.minecraft.entity.monster.SpiderEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.potion.Potion;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvents;
import net.minecraft.world.World;
import net.minecraftforge.common.brewing.BrewingRecipeRegistry;
import net.minecraftforge.common.brewing.IBrewingRecipe;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="mysterymilk")
public class MysteryMilk {
    private final Logger log = LogManager.getLogger((String)"Mystery Milk");
    private final RegistryHelper registry = new RegistryHelper("mysterymilk", this.log).withItemGroup((ItemGroup)new ItemGroupBase("mysterymilk", () -> new ItemStack((IItemProvider)Items.field_151117_aB)));
    private final Item squidMilk;
    private final Potion inkyPotion;
    private final Item ravagerMilk;
    private final Potion cursedPotion;
    private final Item slimeMilk;
    private final Potion slimePotion;
    private final Item phantomMilk;
    private final Potion phantomSightPotion;
    private final Item spiderMilk;
    private final Potion venomPotion;

    public MysteryMilk() {
        this.squidMilk = (Item)this.registry.items.register((IForgeRegistryEntry)new ItemMysteryMilk(32, EntityType.field_200749_ao, this::drinkSquidMilk), "squid_milk");
        this.inkyPotion = (Potion)this.registry.potions.register((IForgeRegistryEntry)new ModPotion(new EffectInstance[]{new EffectInstance(Effects.field_76440_q, 600, 1)}), "inky");
        this.ravagerMilk = (Item)this.registry.items.register((IForgeRegistryEntry)new ItemMysteryMilk(32, EntityType.field_220352_aU, this::drinkRavengerMilk).withMilkingEffect(this::onRavagerMilked), "ravager_milk");
        this.cursedPotion = (Potion)this.registry.potions.register((IForgeRegistryEntry)new ModPotion(new EffectInstance[]{new EffectInstance(Effects.field_220309_E, 1200)}), "cursed");
        this.slimeMilk = (Item)this.registry.items.register((IForgeRegistryEntry)new ItemMysteryMilk(32, EntityType.field_200743_ai, this::drinkSlimeMilk).withMilkingEffect(this::onSlimeMilked), "slime_milk");
        this.slimePotion = (Potion)this.registry.potions.register((IForgeRegistryEntry)new ModPotion(new EffectInstance[]{new EffectInstance(Effects.field_76430_j, 400, 1)}), "slime");
        this.phantomMilk = (Item)this.registry.items.register((IForgeRegistryEntry)new ItemMysteryMilk(32, EntityType.field_203097_aH, this::drinkPhantomMilk), "phantom_milk");
        this.phantomSightPotion = (Potion)this.registry.potions.register((IForgeRegistryEntry)new ModPotion(new EffectInstance[]{new EffectInstance(Effects.field_76439_r, 500, 1)}), "phantom_sight");
        this.spiderMilk = (Item)this.registry.items.register((IForgeRegistryEntry)new ItemMysteryMilk(32, e -> e instanceof SpiderEntity, this::drinkSpiderMilk), "spider_milk");
        this.venomPotion = (Potion)this.registry.potions.register((IForgeRegistryEntry)new ModPotion(new EffectInstance[]{new EffectInstance(Effects.field_76436_u, 120, 3)}), "venom");
        this.registry.initialize(FMLJavaModLoadingContext.get().getModEventBus());
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setup);
    }

    private void setup(FMLCommonSetupEvent event) {
        BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new BrewingRecipePotion(this.squidMilk, this.inkyPotion));
        BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new BrewingRecipePotion(this.ravagerMilk, this.cursedPotion));
        BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new BrewingRecipePotion(this.slimeMilk, this.slimePotion));
        BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new BrewingRecipePotion(this.phantomMilk, this.phantomSightPotion));
        BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new BrewingRecipePotion(this.spiderMilk, this.venomPotion));
    }

    private void drinkSquidMilk(World world, ServerPlayerEntity player) {
        player.func_195064_c(new EffectInstance(Effects.field_76440_q, 300));
    }

    private void drinkRavengerMilk(World world, ServerPlayerEntity player) {
        player.func_195064_c(new EffectInstance(Effects.field_76428_l, 100));
        player.func_195064_c(new EffectInstance(Effects.field_76420_g, 300));
        player.func_195064_c(new EffectInstance(Effects.field_220309_E, 1200));
    }

    private void drinkSlimeMilk(World world, ServerPlayerEntity player) {
        player.func_195064_c(new EffectInstance(Effects.field_76430_j, 600, 3));
    }

    private void drinkPhantomMilk(World world, ServerPlayerEntity player) {
        player.func_195064_c(new EffectInstance(Effects.field_76439_r, 600));
    }

    private void drinkSpiderMilk(World world, ServerPlayerEntity player) {
        player.func_195064_c(new EffectInstance(Effects.field_76436_u, 600));
    }

    private ItemStack onSlimeMilked(PlayerEntity player, ItemStack milkStack, Entity entity) {
        if (entity instanceof SlimeEntity) {
            ((SlimeEntity)entity).func_70606_j(-5.0f);
        }
        return milkStack;
    }

    private ItemStack onRavagerMilked(PlayerEntity player, ItemStack milkStack, Entity entity) {
        if (entity instanceof RavagerEntity) {
            entity.func_184185_a(SoundEvents.field_219649_fi, 1.0f, 1.0f);
            ((RavagerEntity)entity).func_70604_c((LivingEntity)player);
        }
        return milkStack;
    }
}

