/*
 * Decompiled with CFR 0.152.
 */
package pugz.omni.common.block.cavier_caves;

import javax.annotation.Nonnull;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.Direction;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import pugz.omni.core.registry.OmniBlocks;

public class MalachiteBudBlock
extends Block
implements IWaterLoggable {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;
    public static final DirectionProperty FACING = BlockStateProperties.field_208155_H;
    protected static final VoxelShape[] UP_SHAPES = new VoxelShape[]{Block.func_208617_a((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)3.0, (double)11.0), Block.func_208617_a((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)4.0, (double)12.0), Block.func_208617_a((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)5.0, (double)12.0), Block.func_208617_a((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)7.0, (double)12.0)};
    protected static final VoxelShape[] DOWN_SHAPES = new VoxelShape[]{Block.func_208617_a((double)5.0, (double)3.0, (double)5.0, (double)11.0, (double)0.0, (double)11.0), Block.func_208617_a((double)4.0, (double)4.0, (double)4.0, (double)12.0, (double)0.0, (double)12.0), Block.func_208617_a((double)4.0, (double)5.0, (double)4.0, (double)12.0, (double)0.0, (double)12.0), Block.func_208617_a((double)4.0, (double)7.0, (double)4.0, (double)12.0, (double)0.0, (double)12.0)};
    protected static final VoxelShape[] NORTH_SHAPES = new VoxelShape[]{Block.func_208617_a((double)5.0, (double)5.0, (double)13.0, (double)11.0, (double)11.0, (double)16.0), Block.func_208617_a((double)4.0, (double)4.0, (double)12.0, (double)12.0, (double)12.0, (double)16.0), Block.func_208617_a((double)4.0, (double)4.0, (double)11.0, (double)12.0, (double)12.0, (double)16.0), Block.func_208617_a((double)4.0, (double)4.0, (double)9.0, (double)12.0, (double)12.0, (double)16.0)};
    protected static final VoxelShape[] SOUTH_SHAPES = new VoxelShape[]{Block.func_208617_a((double)5.0, (double)5.0, (double)0.0, (double)11.0, (double)11.0, (double)3.0), Block.func_208617_a((double)4.0, (double)4.0, (double)0.0, (double)12.0, (double)12.0, (double)4.0), Block.func_208617_a((double)4.0, (double)4.0, (double)0.0, (double)12.0, (double)12.0, (double)5.0), Block.func_208617_a((double)4.0, (double)4.0, (double)0.0, (double)12.0, (double)12.0, (double)7.0)};
    protected static final VoxelShape[] WEST_SHAPES = new VoxelShape[]{Block.func_208617_a((double)13.0, (double)5.0, (double)5.0, (double)16.0, (double)11.0, (double)11.0), Block.func_208617_a((double)12.0, (double)4.0, (double)4.0, (double)16.0, (double)12.0, (double)12.0), Block.func_208617_a((double)11.0, (double)4.0, (double)4.0, (double)16.0, (double)12.0, (double)12.0), Block.func_208617_a((double)9.0, (double)4.0, (double)4.0, (double)16.0, (double)12.0, (double)12.0)};
    protected static final VoxelShape[] EAST_SHAPES = new VoxelShape[]{Block.func_208617_a((double)0.0, (double)5.0, (double)5.0, (double)3.0, (double)11.0, (double)11.0), Block.func_208617_a((double)0.0, (double)4.0, (double)4.0, (double)4.0, (double)12.0, (double)12.0), Block.func_208617_a((double)0.0, (double)4.0, (double)4.0, (double)5.0, (double)12.0, (double)12.0), Block.func_208617_a((double)0.0, (double)4.0, (double)4.0, (double)7.0, (double)12.0, (double)12.0)};
    private final int age;

    public MalachiteBudBlock(AbstractBlock.Properties properties, int age) {
        super(properties.func_235838_a_(state -> 14));
        this.age = age;
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)FACING, (Comparable)Direction.UP)).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public boolean func_149653_t(BlockState state) {
        return state.func_177230_c() != OmniBlocks.MALACHITE_CLUSTER.get();
    }

    @Nonnull
    public BlockState func_185499_a(BlockState state, Rotation rot) {
        return (BlockState)state.func_206870_a((Property)FACING, (Comparable)rot.func_185831_a((Direction)state.func_177229_b((Property)FACING)));
    }

    @Nonnull
    public BlockState func_185471_a(BlockState state, Mirror mirrorIn) {
        return (BlockState)state.func_206870_a((Property)FACING, (Comparable)mirrorIn.func_185803_b((Direction)state.func_177229_b((Property)FACING)));
    }

    @Nonnull
    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        switch ((Direction)state.func_177229_b((Property)FACING)) {
            case UP: {
                return UP_SHAPES[this.age];
            }
            case DOWN: {
                return DOWN_SHAPES[this.age];
            }
            case EAST: {
                return EAST_SHAPES[this.age];
            }
            case WEST: {
                return WEST_SHAPES[this.age];
            }
            case NORTH: {
                return NORTH_SHAPES[this.age];
            }
        }
        return SOUTH_SHAPES[this.age];
    }

    @Nonnull
    public FluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((Property)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        Direction direction = context.func_196000_l();
        BlockState blockstate = context.func_195991_k().func_180495_p(context.func_195995_a().func_177972_a(direction.func_176734_d()));
        FluidState fluidState = context.func_195991_k().func_204610_c(context.func_195995_a().func_177972_a(direction.func_176734_d()));
        return blockstate.func_203425_a((Block)this) && blockstate.func_177229_b((Property)FACING) == direction ? (BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)direction.func_176734_d())).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.func_206884_a((ITag)FluidTags.field_206959_a))) : (BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)direction)).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.func_206884_a((ITag)FluidTags.field_206959_a)));
    }

    public boolean func_196260_a(BlockState state, IWorldReader worldIn, BlockPos pos) {
        return MalachiteBudBlock.isSideSolidForDirection(worldIn, pos, ((Direction)state.func_177229_b((Property)FACING)).func_176734_d());
    }

    public static boolean isSideSolidForDirection(IWorldReader reader, BlockPos pos, Direction direction) {
        BlockPos blockpos = pos.func_177972_a(direction);
        return reader.func_180495_p(blockpos).func_224755_d((IBlockReader)reader, blockpos, direction.func_176734_d());
    }

    @Nonnull
    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.func_177229_b((Property)WATERLOGGED)).booleanValue()) {
            worldIn.func_205219_F_().func_205360_a(currentPos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)worldIn));
        }
        return !this.func_196260_a(stateIn, (IWorldReader)worldIn, currentPos) ? Blocks.field_150350_a.func_176223_P() : super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public boolean func_196266_a(BlockState state, IBlockReader worldIn, BlockPos pos, PathType type) {
        return type == PathType.WATER && worldIn.func_204610_c(pos).func_206884_a((ITag)FluidTags.field_206959_a);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{FACING, WATERLOGGED});
    }
}

