/*
 * Decompiled with CFR 0.152.
 */
package pugz.omni.common.block.cavier_caves;

import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.CauldronBlock;
import net.minecraft.block.FallingBlock;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.FallingBlockEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.ProjectileEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.PickaxeItem;
import net.minecraft.particles.BasicParticleType;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import pugz.omni.core.registry.OmniBlocks;

public class SpeleothemBlock
extends FallingBlock
implements IWaterLoggable {
    public static final EnumProperty<Size> SIZE = EnumProperty.func_177709_a((String)"size", Size.class);
    public static final EnumProperty<Part> PART = EnumProperty.func_177709_a((String)"part", Part.class);
    public static final BooleanProperty STATIC = BooleanProperty.func_177716_a((String)"static");
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;

    public SpeleothemBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a(SIZE, (Comparable)((Object)Size.LARGE))).func_206870_a(PART, (Comparable)((Object)Part.FULL))).func_206870_a((Property)STATIC, (Comparable)Boolean.valueOf(true))).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public Vector3d getOffset(IBlockReader access, BlockPos pos) {
        long i = MathHelper.func_180187_c((int)pos.func_177958_n(), (int)0, (int)pos.func_177952_p());
        return new Vector3d(((double)((float)(i & 0xFL) / 15.0f) - 0.5) * 0.25, 0.0, ((double)((float)(i >> 8 & 0xFL) / 15.0f) - 0.5) * 0.25);
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        Item held = context.func_195996_i().func_77973_b();
        FluidState fluidstate = context.func_195991_k().func_204610_c(context.func_195995_a());
        BlockState state = this.func_176223_P();
        Direction face = context.func_196000_l();
        if (face == Direction.UP || face == Direction.DOWN) {
            state = face == Direction.UP ? (BlockState)state.func_206870_a(PART, (Comparable)((Object)Part.LOWER)) : (BlockState)state.func_206870_a(PART, (Comparable)((Object)Part.UPPER));
            state = held == ((Block)OmniBlocks.ICE_SPELEOTHEM.get()).func_199767_j() ? (BlockState)state.func_206870_a(SIZE, (Comparable)((Object)Size.ICE_LARGE)) : (BlockState)state.func_206870_a(SIZE, (Comparable)((Object)Size.LARGE));
            return (BlockState)((BlockState)state.func_206870_a((Property)STATIC, (Comparable)Boolean.valueOf(true))).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.func_206884_a((ITag)FluidTags.field_206959_a)));
        }
        return null;
    }

    @Nonnull
    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult ray) {
        ItemStack held = player.func_184586_b(handIn);
        Size size = (Size)((Object)state.func_177229_b(SIZE));
        if (!worldIn.field_72995_K && held.func_77973_b() instanceof PickaxeItem) {
            FluidState fluidstate = worldIn.func_204610_c(pos);
            if (size == Size.LARGE || size == Size.ICE_LARGE) {
                worldIn.func_180501_a(pos, (BlockState)((BlockState)((BlockState)((BlockState)this.func_176223_P().func_206870_a(SIZE, (Comparable)((Object)Size.MEDIUM))).func_206870_a(PART, state.func_177229_b(PART))).func_206870_a((Property)STATIC, state.func_177229_b((Property)STATIC))).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.func_206884_a((ITag)FluidTags.field_206959_a))), 1);
            } else if (size == Size.MEDIUM) {
                worldIn.func_180501_a(pos, (BlockState)((BlockState)((BlockState)((BlockState)this.func_176223_P().func_206870_a(SIZE, (Comparable)((Object)Size.SMALL))).func_206870_a(PART, state.func_177229_b(PART))).func_206870_a((Property)STATIC, state.func_177229_b((Property)STATIC))).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.func_206884_a((ITag)FluidTags.field_206959_a))), 1);
            } else if (size == Size.SMALL) {
                worldIn.func_217377_a(pos, false);
            }
            if (held.func_77984_f()) {
                held.func_222118_a(1, (LivingEntity)player, living -> living.func_213334_d(handIn));
            }
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.FAIL;
    }

    public boolean func_200123_i(BlockState state, IBlockReader reader, BlockPos pos) {
        return true;
    }

    public void func_225534_a_(BlockState state, ServerWorld world, BlockPos pos, Random rand) {
        if (!((Boolean)state.func_177229_b((Property)STATIC)).booleanValue()) {
            this.trySpawnEntity((World)world, pos);
        }
    }

    private void trySpawnEntity(World world, BlockPos pos) {
        if (world.func_175623_d(pos.func_177977_b()) || SpeleothemBlock.canFallThrough(world.func_180495_p(pos.func_177977_b()))) {
            FallingBlockEntity fallingblockentity = new FallingBlockEntity(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5, world.func_180495_p(pos));
            this.func_149829_a(fallingblockentity);
            fallingblockentity.func_145806_a(true);
            world.func_217376_c((Entity)fallingblockentity);
            world.func_205220_G_().func_205360_a(pos.func_177984_a(), (Object)this, 1);
        }
    }

    public void func_225542_b_(BlockState state, ServerWorld world, BlockPos pos, Random rand) {
        for (int y = pos.func_177956_o(); y >= Math.max(0, pos.func_177956_o() - 64); --y) {
            int level;
            BlockPos check = new BlockPos(pos.func_177958_n(), y, pos.func_177952_p());
            BlockState block = world.func_180495_p(check);
            if (block.func_177230_c() != Blocks.field_150383_bp || rand.nextInt(40) != 0 || state.func_177230_c() == OmniBlocks.NETHERRACK_SPELEOTHEM.get() || (level = ((Integer)block.func_177229_b((Property)CauldronBlock.field_176591_a)).intValue()) >= 3) continue;
            world.func_180501_a(check, (BlockState)block.func_206870_a((Property)CauldronBlock.field_176591_a, (Comparable)Integer.valueOf(level + 1)), 3);
        }
    }

    public boolean func_149653_t(BlockState state) {
        return true;
    }

    @Nonnull
    public BlockState func_196271_a(BlockState state, Direction facing, BlockState facingState, IWorld world, BlockPos currentPos, BlockPos facingPos) {
        BlockState down = world.func_180495_p(currentPos.func_177977_b());
        BlockState up = world.func_180495_p(currentPos.func_177984_a());
        Part part = (Part)((Object)state.func_177229_b(PART));
        if (!state.func_196955_c((IWorldReader)world, currentPos) && !((Boolean)state.func_177229_b((Property)STATIC)).booleanValue()) {
            world.func_205220_G_().func_205360_a(currentPos, (Object)this, 1);
        }
        if ((down.func_177230_c() instanceof SpeleothemBlock || down.func_200132_m()) && (up.func_177230_c() instanceof SpeleothemBlock || up.func_200132_m())) {
            return (BlockState)state.func_206870_a(PART, (Comparable)((Object)Part.FULL));
        }
        if (part == Part.FULL) {
            if (!down.func_200132_m() && up.func_200132_m()) {
                if (world.func_175623_d(currentPos.func_177977_b()) || SpeleothemBlock.canFallThrough(world.func_180495_p(currentPos.func_177977_b()))) {
                    world.func_205220_G_().func_205360_a(currentPos.func_177984_a(), (Object)this, 1);
                    return (BlockState)((BlockState)state.func_206870_a(PART, (Comparable)((Object)Part.UPPER))).func_206870_a((Property)STATIC, (Comparable)Boolean.valueOf(false));
                }
                return (BlockState)((BlockState)state.func_206870_a(PART, (Comparable)((Object)Part.UPPER))).func_206870_a((Property)STATIC, (Comparable)Boolean.valueOf(true));
            }
            if (!up.func_200132_m() && down.func_200132_m()) {
                if (world.func_175623_d(currentPos.func_177977_b()) || SpeleothemBlock.canFallThrough(world.func_180495_p(currentPos.func_177977_b()))) {
                    world.func_205220_G_().func_205360_a(currentPos.func_177984_a(), (Object)this, 1);
                    return (BlockState)((BlockState)state.func_206870_a(PART, (Comparable)((Object)Part.UPPER))).func_206870_a((Property)STATIC, (Comparable)Boolean.valueOf(false));
                }
                return (BlockState)((BlockState)state.func_206870_a(PART, (Comparable)((Object)Part.LOWER))).func_206870_a((Property)STATIC, (Comparable)Boolean.valueOf(true));
            }
            if (!down.func_200132_m() && !up.func_200132_m()) {
                world.func_205220_G_().func_205360_a(currentPos.func_177984_a(), (Object)this, 1);
                return (BlockState)state.func_206870_a((Property)STATIC, (Comparable)Boolean.valueOf(false));
            }
        } else if (part == Part.UPPER) {
            if (!up.func_200132_m()) {
                world.func_205220_G_().func_205360_a(currentPos, (Object)this, 1);
                return (BlockState)state.func_206870_a((Property)STATIC, (Comparable)Boolean.valueOf(false));
            }
        } else if (!down.func_200132_m()) {
            world.func_205220_G_().func_205360_a(currentPos, (Object)this, 1);
            return (BlockState)state.func_206870_a((Property)STATIC, (Comparable)Boolean.valueOf(false));
        }
        return super.func_196271_a(state, facing, facingState, world, currentPos, facingPos);
    }

    public boolean func_196260_a(BlockState state, IWorldReader worldIn, BlockPos pos) {
        BlockState down = worldIn.func_180495_p(pos.func_177977_b());
        BlockState up = worldIn.func_180495_p(pos.func_177984_a());
        return down.func_200132_m() || up.func_200132_m();
    }

    @Nonnull
    public FluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((Property)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }

    public boolean func_196266_a(@Nonnull BlockState state, @Nonnull IBlockReader worldIn, @Nonnull BlockPos pos, PathType type) {
        return type == PathType.WATER && worldIn.func_204610_c(pos).func_206884_a((ITag)FluidTags.field_206959_a);
    }

    @Nonnull
    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        Vector3d offset = state.func_191059_e(worldIn, pos);
        return ((Size)((Object)state.func_177229_b(SpeleothemBlock.SIZE))).shape.func_197751_a(offset.func_82615_a(), offset.func_82617_b(), offset.func_82616_c());
    }

    protected int func_230329_c_() {
        return 4;
    }

    public static boolean canFallThrough(BlockState state) {
        Material material = state.func_185904_a();
        return state.func_196958_f() || state.func_235714_a_((ITag)BlockTags.field_232872_am_) || material.func_76224_d() || material.func_76222_j();
    }

    public void func_176502_a_(World worldIn, BlockPos pos, BlockState fallingState, BlockState hitState, FallingBlockEntity fallingBlock) {
        worldIn.func_175655_b(pos, false);
    }

    public int func_189876_x(BlockState state, IBlockReader reader, BlockPos pos) {
        return state.func_185909_g((IBlockReader)reader, (BlockPos)pos).field_76291_p;
    }

    public void func_180658_a(World worldIn, BlockPos pos, Entity entityIn, float fallDistance) {
        BlockState state = worldIn.func_180495_p(pos);
        entityIn.func_225503_b_(fallDistance, 4.0f + 1.0f / ((float)((Size)((Object)state.func_177229_b(SIZE))).width * 0.5f));
    }

    public void func_220066_a(World world, BlockState state, BlockRayTraceResult hit, ProjectileEntity projectile) {
        this.trySpawnEntity(world, hit.func_216350_a());
    }

    public void func_180655_c(BlockState state, World world, BlockPos pos, Random rand) {
        if (world.func_175623_d(pos.func_177977_b()) || world.func_180495_p(pos.func_177977_b()).func_177230_c() == Blocks.field_150383_bp) {
            for (int i = 0; i < rand.nextInt(1) + 1; ++i) {
                this.addDripParticle(world, pos, state);
            }
        }
    }

    private void addDripParticle(World world, BlockPos pos, BlockState state) {
        VoxelShape shape;
        double d0;
        if (state.func_204520_s().func_206888_e() && !(world.field_73012_v.nextFloat() < 0.3f) && (d0 = (shape = state.func_196952_d((IBlockReader)world, pos)).func_197758_c(Direction.Axis.Y)) >= 1.0 && !state.func_235714_a_((ITag)BlockTags.field_211923_H)) {
            double d1 = shape.func_197762_b(Direction.Axis.Y);
            if (d1 > 0.0) {
                this.addDripParticle(world, pos, state, shape, (double)pos.func_177956_o() + d1 - 0.05);
            } else {
                BlockPos down = pos.func_177977_b();
                BlockState downState = world.func_180495_p(down);
                double d2 = downState.func_196952_d((IBlockReader)world, down).func_197758_c(Direction.Axis.Y);
                if ((d2 < 1.0 || !downState.func_235785_r_((IBlockReader)world, down)) && downState.func_204520_s().func_206888_e()) {
                    this.addDripParticle(world, pos, state, shape, (double)pos.func_177956_o() - 0.05);
                }
            }
        }
    }

    private void addDripParticle(World world, BlockPos pos, BlockState state, VoxelShape shape, double y) {
        BasicParticleType type = state.func_177230_c() != OmniBlocks.NETHERRACK_SPELEOTHEM.get() ? ParticleTypes.field_197618_k : ParticleTypes.field_197617_j;
        world.func_195594_a((IParticleData)type, MathHelper.func_219803_d((double)world.field_73012_v.nextDouble(), (double)((double)pos.func_177958_n() + shape.func_197762_b(Direction.Axis.X)), (double)((double)pos.func_177958_n() + shape.func_197758_c(Direction.Axis.X))), y, MathHelper.func_219803_d((double)world.field_73012_v.nextDouble(), (double)((double)pos.func_177952_p() + shape.func_197762_b(Direction.Axis.Z)), (double)((double)pos.func_177952_p() + shape.func_197758_c(Direction.Axis.Z))), 0.0, 0.0, 0.0);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{SIZE, PART, STATIC, WATERLOGGED});
    }

    public static enum Part implements IStringSerializable
    {
        LOWER("lower"),
        UPPER("upper"),
        FULL("full");

        public String name;

        private Part(String nameIn) {
            this.name = nameIn;
        }

        @Nonnull
        public String func_176610_l() {
            return this.name;
        }
    }

    public static enum Size implements IStringSerializable
    {
        SMALL("small", 4),
        MEDIUM("medium", 8),
        ICE_LARGE("ice_large", 12),
        LARGE("large", 14);

        public VoxelShape shape;
        public String name;
        private final int width;

        private Size(String nameIn, int width) {
            int pad = (16 - width) / 2;
            this.shape = Block.func_208617_a((double)pad, (double)0.0, (double)pad, (double)(16 - pad), (double)16.0, (double)(16 - pad));
            this.name = nameIn;
            this.width = width;
        }

        @Nonnull
        public String func_176610_l() {
            return this.name;
        }
    }
}

