/*
 * Decompiled with CFR 0.152.
 */
package pugz.omni.common.block.colormatic;

import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FallingBlock;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.PushReaction;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.FallingBlockEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.DyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ShovelItem;
import net.minecraft.particles.BlockParticleData;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import pugz.omni.common.block.colormatic.LayerConcreteBlock;
import pugz.omni.common.entity.colormatic.FallingConcretePowderEntity;

public class LayerConcretePowderBlock
extends FallingBlock
implements IWaterLoggable {
    public static final IntegerProperty LAYERS = BlockStateProperties.field_208129_ad;
    protected static final VoxelShape[] SHAPES = new VoxelShape[]{VoxelShapes.func_197880_a(), Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0), Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)16.0), Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)6.0, (double)16.0), Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0), Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)10.0, (double)16.0), Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)12.0, (double)16.0), Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)14.0, (double)16.0), Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)};
    private final BlockState solidifiedState;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;

    public LayerConcretePowderBlock(Block solidifiedIn, DyeColor color) {
        super(AbstractBlock.Properties.func_200952_a((Material)Material.field_151595_p, (DyeColor)color).func_200943_b(0.5f).func_200947_a(SoundType.field_185855_h));
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)LAYERS, (Comparable)Integer.valueOf(8))).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
        this.solidifiedState = solidifiedIn.func_176223_P();
    }

    public BlockState getSolidifiedState() {
        return this.solidifiedState;
    }

    @Nonnull
    public PushReaction func_149656_h(BlockState state) {
        return (Integer)state.func_177229_b((Property)LAYERS) == 1 ? PushReaction.DESTROY : PushReaction.NORMAL;
    }

    @Nonnull
    public FluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((Property)WATERLOGGED) != false && (Integer)state.func_177229_b((Property)LAYERS) < 7 ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }

    public boolean func_196266_a(BlockState state, IBlockReader worldIn, BlockPos pos, PathType type) {
        if (type == PathType.LAND) {
            return (Integer)state.func_177229_b((Property)LAYERS) < 5;
        }
        return false;
    }

    @Nonnull
    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return SHAPES[(Integer)state.func_177229_b((Property)LAYERS)];
    }

    @Nonnull
    public VoxelShape func_220071_b(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return SHAPES[(Integer)state.func_177229_b((Property)LAYERS)];
    }

    @Nonnull
    public VoxelShape func_230335_e_(BlockState state, IBlockReader reader, BlockPos pos) {
        return SHAPES[(Integer)state.func_177229_b((Property)LAYERS)];
    }

    @Nonnull
    public VoxelShape func_230322_a_(BlockState state, IBlockReader reader, BlockPos pos, ISelectionContext context) {
        return SHAPES[(Integer)state.func_177229_b((Property)LAYERS)];
    }

    public boolean func_220074_n(BlockState state) {
        return true;
    }

    @Nonnull
    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        worldIn.func_205220_G_().func_205360_a(currentPos, (Object)this, this.func_230329_c_());
        return !stateIn.func_196955_c((IWorldReader)worldIn, currentPos) ? Blocks.field_150350_a.func_176223_P() : (LayerConcretePowderBlock.isTouchingLiquid((IBlockReader)worldIn, currentPos) ? (BlockState)((BlockState)this.solidifiedState.func_206870_a((Property)LAYERS, stateIn.func_177229_b((Property)LAYERS))).func_206870_a((Property)WATERLOGGED, stateIn.func_177229_b((Property)WATERLOGGED)) : super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos));
    }

    @Nonnull
    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        ItemStack held = player.func_184586_b(handIn);
        if (held.func_77973_b() instanceof ShovelItem && hit.func_216354_b() == Direction.UP) {
            held.func_222118_a(1, (LivingEntity)player, e -> e.func_213334_d(handIn));
            if ((Integer)state.func_177229_b((Property)LAYERS) > 1) {
                worldIn.func_180501_a(pos, (BlockState)state.func_206870_a((Property)LAYERS, (Comparable)Integer.valueOf((Integer)state.func_177229_b((Property)LAYERS) - 1)), 3);
            } else {
                worldIn.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 3);
            }
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.FAIL;
    }

    public void func_225534_a_(BlockState state, ServerWorld world, BlockPos pos, Random rand) {
        super.func_225534_a_(state, world, pos, rand);
        if (world.func_175623_d(pos.func_177977_b()) || LayerConcretePowderBlock.canFallThrough(world.func_180495_p(pos.func_177977_b())) && pos.func_177956_o() >= 0) {
            FallingConcretePowderEntity entity = new FallingConcretePowderEntity((World)world, (double)pos.func_177958_n() + 0.5, pos.func_177956_o(), (double)pos.func_177952_p() + 0.5, (Integer)state.func_177229_b((Property)LAYERS), state);
            entity.field_145813_c = false;
            world.func_217376_c((Entity)entity);
        }
    }

    protected int func_230329_c_() {
        return 2;
    }

    public static boolean canFallThrough(BlockState state) {
        if (state.func_177230_c() instanceof LayerConcretePowderBlock || state.func_177230_c() instanceof LayerConcreteBlock) {
            return false;
        }
        Material material = state.func_185904_a();
        return state.func_196958_f() || state.func_235714_a_((ITag)BlockTags.field_232872_am_) || material.func_76224_d() || material.func_76222_j();
    }

    public void func_176502_a_(World worldIn, BlockPos pos, BlockState fallingState, BlockState hitState, FallingBlockEntity entity) {
        System.out.println("end");
        if (LayerConcretePowderBlock.shouldSolidify((IBlockReader)worldIn, pos, fallingState)) {
            worldIn.func_180501_a(pos, (BlockState)((BlockState)this.solidifiedState.func_206870_a((Property)LAYERS, fallingState.func_177229_b((Property)LAYERS))).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf((Integer)fallingState.func_177229_b((Property)LAYERS) < 7)), 3);
        }
        if (!(entity instanceof FallingConcretePowderEntity)) {
            worldIn.func_217377_a(entity.func_233580_cy_(), false);
        }
    }

    private static boolean shouldSolidify(IBlockReader reader, BlockPos pos, BlockState state) {
        return LayerConcretePowderBlock.causesSolidify(state) || LayerConcretePowderBlock.isTouchingLiquid(reader, pos);
    }

    private static boolean isTouchingLiquid(IBlockReader world, BlockPos pos) {
        BlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() instanceof LayerConcretePowderBlock && ((Boolean)state.func_177229_b((Property)WATERLOGGED)).booleanValue()) {
            return true;
        }
        for (Direction d : Direction.values()) {
            BlockState check;
            if (d == Direction.DOWN || !((check = world.func_180495_p(pos.func_177972_a(d))).func_177230_c() instanceof LayerConcretePowderBlock || check.func_177230_c() instanceof LayerConcreteBlock ? (Boolean)check.func_177229_b((Property)WATERLOGGED) != false && (Integer)check.func_177229_b((Property)LAYERS) < (Integer)state.func_177229_b((Property)LAYERS) : LayerConcretePowderBlock.causesSolidify(check) && !check.func_224755_d(world, pos, d.func_176734_d()))) continue;
            return true;
        }
        return false;
    }

    private static boolean causesSolidify(BlockState state) {
        return state.func_204520_s().func_206884_a((ITag)FluidTags.field_206959_a);
    }

    public boolean func_204509_a(IWorld worldIn, BlockPos pos, BlockState state, FluidState fluidStateIn) {
        if (!((Boolean)state.func_177229_b((Property)BlockStateProperties.field_208198_y)).booleanValue() && fluidStateIn.func_206886_c() == Fluids.field_204546_a) {
            if (!worldIn.func_201670_d()) {
                worldIn.func_180501_a(pos, (BlockState)((BlockState)this.solidifiedState.func_206870_a((Property)LAYERS, state.func_177229_b((Property)LAYERS))).func_206870_a((Property)BlockStateProperties.field_208198_y, (Comparable)Boolean.TRUE), 3);
                worldIn.func_205219_F_().func_205360_a(pos, (Object)fluidStateIn.func_206886_c(), fluidStateIn.func_206886_c().func_205569_a((IWorldReader)worldIn));
            }
            return true;
        }
        return false;
    }

    public boolean func_204510_a(IBlockReader worldIn, BlockPos pos, BlockState state, Fluid fluidIn) {
        return super.func_204510_a(worldIn, pos, state, fluidIn) && (Integer)state.func_177229_b((Property)LAYERS) < 8;
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        BlockState blockstate;
        BlockPos pos;
        World world = context.func_195991_k();
        return LayerConcretePowderBlock.shouldSolidify((IBlockReader)world, pos = context.func_195995_a(), blockstate = world.func_180495_p(pos)) ? (BlockState)this.solidifiedState.func_206870_a((Property)LAYERS, (Comparable)Integer.valueOf(8)) : super.func_196258_a(context);
    }

    public void func_180655_c(BlockState state, World world, BlockPos pos, Random rand) {
        BlockPos blockpos;
        if (rand.nextInt(16) == 0 && (world.func_175623_d(blockpos = pos.func_177977_b()) || LayerConcretePowderBlock.canFallThrough(world.func_180495_p(blockpos)))) {
            double d0 = (double)pos.func_177958_n() + rand.nextDouble();
            double d1 = (double)pos.func_177956_o() - 0.05;
            double d2 = (double)pos.func_177952_p() + rand.nextDouble();
            world.func_195594_a((IParticleData)new BlockParticleData(ParticleTypes.field_197628_u, state), d0, d1, d2, 0.0, 0.0, 0.0);
        }
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{LAYERS, WATERLOGGED});
    }
}

