/*
 * Decompiled with CFR 0.152.
 */
package pugz.omni.common.block.colormatic;

import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.SixWayBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.DyeColor;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.util.Direction;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public class QuiltedCarpetBlock
extends Block {
    protected static final VoxelShape SHAPE = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0);
    public static final BooleanProperty NORTH = SixWayBlock.field_196488_a;
    public static final BooleanProperty EAST = SixWayBlock.field_196490_b;
    public static final BooleanProperty SOUTH = SixWayBlock.field_196492_c;
    public static final BooleanProperty WEST = SixWayBlock.field_196495_y;
    protected static final Map<Direction, BooleanProperty> FACING_TO_PROPERTY_MAP = (Map)SixWayBlock.field_196491_B.entrySet().stream().filter(directions -> ((Direction)directions.getKey()).func_176740_k().func_176722_c()).collect(Util.func_199749_a());

    public QuiltedCarpetBlock(DyeColor color) {
        super(AbstractBlock.Properties.func_200952_a((Material)Material.field_151593_r, (DyeColor)color).func_200943_b(0.1f).func_200947_a(SoundType.field_185854_g));
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)NORTH, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)SOUTH, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)EAST, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)WEST, (Comparable)Boolean.valueOf(false)));
    }

    @Nonnull
    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
        return SHAPE;
    }

    @Nonnull
    public BlockState func_196271_a(BlockState state, Direction direction, BlockState state2, IWorld world, BlockPos pos, BlockPos pos2) {
        if (!state.func_196955_c((IWorldReader)world, pos)) {
            return Blocks.field_150350_a.func_176223_P();
        }
        return direction.func_176740_k().func_176716_d() == Direction.Plane.HORIZONTAL ? (BlockState)state.func_206870_a((Property)FACING_TO_PROPERTY_MAP.get(direction), (Comparable)Boolean.valueOf(this.canConnect(state, state2))) : super.func_196271_a(state, direction, state2, world, pos, pos2);
    }

    public boolean func_196260_a(BlockState state, IWorldReader world, BlockPos pos) {
        return !world.func_175623_d(pos.func_177977_b());
    }

    @Nonnull
    public BlockState func_185499_a(BlockState state, Rotation rotation) {
        switch (rotation) {
            case CLOCKWISE_180: {
                return (BlockState)((BlockState)((BlockState)((BlockState)state.func_206870_a((Property)NORTH, state.func_177229_b((Property)SOUTH))).func_206870_a((Property)EAST, state.func_177229_b((Property)WEST))).func_206870_a((Property)SOUTH, state.func_177229_b((Property)NORTH))).func_206870_a((Property)WEST, state.func_177229_b((Property)EAST));
            }
            case COUNTERCLOCKWISE_90: {
                return (BlockState)((BlockState)((BlockState)((BlockState)state.func_206870_a((Property)NORTH, state.func_177229_b((Property)EAST))).func_206870_a((Property)EAST, state.func_177229_b((Property)SOUTH))).func_206870_a((Property)SOUTH, state.func_177229_b((Property)WEST))).func_206870_a((Property)WEST, state.func_177229_b((Property)NORTH));
            }
            case CLOCKWISE_90: {
                return (BlockState)((BlockState)((BlockState)((BlockState)state.func_206870_a((Property)NORTH, state.func_177229_b((Property)WEST))).func_206870_a((Property)EAST, state.func_177229_b((Property)NORTH))).func_206870_a((Property)SOUTH, state.func_177229_b((Property)EAST))).func_206870_a((Property)WEST, state.func_177229_b((Property)SOUTH));
            }
        }
        return state;
    }

    @Nonnull
    public BlockState func_185471_a(BlockState state, Mirror mirror) {
        switch (mirror) {
            case LEFT_RIGHT: {
                return (BlockState)((BlockState)state.func_206870_a((Property)NORTH, state.func_177229_b((Property)SOUTH))).func_206870_a((Property)SOUTH, state.func_177229_b((Property)NORTH));
            }
            case FRONT_BACK: {
                return (BlockState)((BlockState)state.func_206870_a((Property)EAST, state.func_177229_b((Property)WEST))).func_206870_a((Property)WEST, state.func_177229_b((Property)EAST));
            }
        }
        return super.func_185471_a(state, mirror);
    }

    public boolean canConnect(BlockState state, BlockState state2) {
        Block block = state.func_177230_c();
        return !QuiltedCarpetBlock.func_220073_a((Block)block) && block instanceof QuiltedCarpetBlock && block == state2.func_177230_c();
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        World world = context.func_195991_k();
        BlockPos pos = context.func_195995_a();
        BlockState state = world.func_180495_p(pos);
        BlockPos north = pos.func_177978_c();
        BlockPos east = pos.func_177974_f();
        BlockPos south = pos.func_177968_d();
        BlockPos west = pos.func_177976_e();
        BlockState lvt_9_1_ = world.func_180495_p(north);
        BlockState lvt_10_1_ = world.func_180495_p(east);
        BlockState lvt_11_1_ = world.func_180495_p(south);
        BlockState lvt_12_1_ = world.func_180495_p(west);
        return (BlockState)((BlockState)((BlockState)((BlockState)super.func_196258_a(context).func_206870_a((Property)NORTH, (Comparable)Boolean.valueOf(this.canConnect(state, lvt_9_1_)))).func_206870_a((Property)EAST, (Comparable)Boolean.valueOf(this.canConnect(state, lvt_10_1_)))).func_206870_a((Property)SOUTH, (Comparable)Boolean.valueOf(this.canConnect(state, lvt_11_1_)))).func_206870_a((Property)WEST, (Comparable)Boolean.valueOf(this.canConnect(state, lvt_12_1_)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{NORTH, SOUTH, EAST, WEST});
    }
}

