/*
 * Decompiled with CFR 0.152.
 */
package pugz.omni.common.entity.paradise;

import java.util.Arrays;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractCoralPlantBlock;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.CoralFanBlock;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.RandomPositionGenerator;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.controller.MovementController;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.RandomSwimmingGoal;
import net.minecraft.entity.passive.WaterMobEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.pathfinding.SwimmerPathNavigator;
import net.minecraft.state.Property;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;
import pugz.omni.core.registry.OmniEntities;
import pugz.omni.core.registry.OmniItems;

public class SeahorseEntity
extends WaterMobEntity {
    private static final DataParameter<Boolean> DYING = EntityDataManager.func_187226_a(SeahorseEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> CORAL_TYPE = EntityDataManager.func_187226_a(SeahorseEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Byte> CORAL_TYPE_FLAGS = EntityDataManager.func_187226_a(SeahorseEntity.class, (IDataSerializer)DataSerializers.field_187191_a);
    private int remainingCooldownBeforeLocatingNewCoral = 0;
    private BlockPos savedCoralPos = null;

    public SeahorseEntity(EntityType<? extends SeahorseEntity> type, World worldIn) {
        super(type, worldIn);
        this.field_70765_h = new MoveHelperController(this);
    }

    public SeahorseEntity(World world, double posX, double posY, double posZ) {
        this((EntityType<? extends SeahorseEntity>)((EntityType)OmniEntities.SEAHORSE.get()), world);
        this.func_70107_b(posX, posY, posZ);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(DYING, (Object)false);
        this.field_70180_af.func_187214_a(CORAL_TYPE, (Object)0);
        this.field_70180_af.func_187214_a(CORAL_TYPE_FLAGS, (Object)0);
    }

    public static AttributeModifierMap.MutableAttribute registerAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 8.0).func_233815_a_(Attributes.field_233821_d_, (double)0.8f);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(4, (Goal)new RandomSwimmingGoal((CreatureEntity)this, 1.0, 25));
        this.field_70714_bg.func_75776_a(4, (Goal)new GrowCoralGoal());
        this.field_70714_bg.func_75776_a(6, (Goal)new FindCoralGoal());
    }

    @Nonnull
    protected PathNavigator func_175447_b(World worldIn) {
        return new SwimmerPathNavigator((MobEntity)this, worldIn);
    }

    private boolean isCoral(BlockPos pos) {
        return this.field_70170_p.func_195588_v(pos) && this.field_70170_p.func_180495_p(pos).func_177230_c().func_203417_a((ITag)BlockTags.field_205598_B);
    }

    @Nonnull
    protected SoundEvent func_184184_Z() {
        return SoundEvents.field_203817_bZ;
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_203253_U;
    }

    public void func_203004_j(boolean downwards) {
    }

    public void func_203002_i(boolean downwards) {
    }

    public ItemStack getPickedResult(RayTraceResult target) {
        return new ItemStack((IItemProvider)OmniItems.SEAHORSE_SPAWN_EGG.get());
    }

    public int func_70641_bl() {
        return 6;
    }

    @Nullable
    public BlockPos getCoralPos() {
        return this.savedCoralPos;
    }

    private void setCoralTypeFlag(int p_213505_1_, boolean p_213505_2_) {
        if (p_213505_2_) {
            this.field_70180_af.func_187227_b(CORAL_TYPE_FLAGS, (Object)((byte)((Byte)this.field_70180_af.func_187225_a(CORAL_TYPE_FLAGS) | p_213505_1_)));
        } else {
            this.field_70180_af.func_187227_b(CORAL_TYPE_FLAGS, (Object)((byte)((Byte)this.field_70180_af.func_187225_a(CORAL_TYPE_FLAGS) & ~p_213505_1_)));
        }
    }

    private boolean getCoralTypeFlag(int p_213507_1_) {
        return ((Byte)this.field_70180_af.func_187225_a(CORAL_TYPE_FLAGS) & p_213507_1_) != 0;
    }

    public CoralType getVariantType() {
        return CoralType.getTypeByIndex((Integer)this.field_70180_af.func_187225_a(CORAL_TYPE));
    }

    private void setVariantType(CoralType typeIn) {
        this.field_70180_af.func_187227_b(CORAL_TYPE, (Object)typeIn.getIndex());
    }

    public boolean isDying() {
        return this.getCoralTypeFlag(16);
    }

    public void setDying(boolean p_213466_1_) {
        this.setCoralTypeFlag(16, p_213466_1_);
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        if (this.hasCoral()) {
            compound.func_218657_a("CoralPos", (INBT)NBTUtil.func_186859_a((BlockPos)this.getCoralPos()));
        }
        compound.func_74778_a("Type", this.getVariantType().getName());
        compound.func_74757_a("Dying", this.isDying());
    }

    public void func_70037_a(CompoundNBT compound) {
        this.setVariantType(CoralType.getTypeByName(compound.func_74779_i("Type")));
        this.setDying(compound.func_74767_n("Dying"));
        this.savedCoralPos = null;
        if (compound.func_74764_b("CoralPos")) {
            this.savedCoralPos = NBTUtil.func_186861_c((CompoundNBT)compound.func_74775_l("CoralPos"));
        }
        super.func_70037_a(compound);
    }

    private boolean isTooFar(BlockPos pos) {
        return this.isWithinDistance(pos, 32);
    }

    private boolean isWithinDistance(BlockPos pos, int distance) {
        return !pos.func_218141_a((Vector3i)this.func_233580_cy_(), (double)distance);
    }

    private void startMovingTo(BlockPos pos) {
        Vector3d vector3d1;
        Vector3d vector3d = Vector3d.func_237492_c_((Vector3i)pos);
        int i = 0;
        BlockPos blockpos = this.func_233580_cy_();
        int j = (int)vector3d.field_72448_b - blockpos.func_177956_o();
        if (j > 2) {
            i = 4;
        } else if (j < -2) {
            i = -4;
        }
        int k = 6;
        int l = 8;
        int i1 = blockpos.func_218139_n((Vector3i)pos);
        if (i1 < 15) {
            k = i1 / 2;
            l = i1 / 2;
        }
        if ((vector3d1 = RandomPositionGenerator.func_226344_b_((CreatureEntity)this, (int)k, (int)l, (int)i, (Vector3d)vector3d, (double)0.3141592741012573)) != null) {
            this.field_70699_by.func_226335_a_(0.5f);
            this.field_70699_by.func_75492_a(vector3d1.field_72450_a, vector3d1.field_72448_b, vector3d1.field_72449_c, 1.0);
        }
    }

    public boolean hasCoral() {
        return this.savedCoralPos != null;
    }

    public static enum CoralType {
        BUBBLE(0, "bubble", Blocks.field_204280_jL.func_176223_P(), Blocks.field_204745_jT.func_176223_P()),
        FIRE(1, "fire", Blocks.field_204281_jM.func_176223_P(), Blocks.field_204746_jU.func_176223_P()),
        TUBE(2, "tube", Blocks.field_204278_jJ.func_176223_P(), Blocks.field_204743_jR.func_176223_P()),
        BRAIN(3, "brain", Blocks.field_204279_jK.func_176223_P(), Blocks.field_204744_jS.func_176223_P()),
        HORN(4, "horn", Blocks.field_204282_jN.func_176223_P(), Blocks.field_204747_jV.func_176223_P());

        private static final CoralType[] field_221088_c;
        private static final Map<String, CoralType> TYPES_BY_NAME;
        private final int index;
        private final String name;
        private final BlockState coral;
        private final BlockState fan;

        private CoralType(int index, String name, BlockState coral, BlockState fan) {
            this.index = index;
            this.name = name;
            this.coral = coral;
            this.fan = fan;
        }

        public String getName() {
            return this.name;
        }

        public int getIndex() {
            return this.index;
        }

        public BlockState getCoral() {
            return this.coral;
        }

        public BlockState getFan() {
            return this.fan;
        }

        public static CoralType getTypeByName(String nameIn) {
            return TYPES_BY_NAME.getOrDefault(nameIn, HORN);
        }

        public static CoralType getTypeByIndex(int indexIn) {
            if (indexIn < 0 || indexIn > field_221088_c.length) {
                indexIn = 0;
            }
            return field_221088_c[indexIn];
        }

        static {
            field_221088_c = (CoralType[])Arrays.stream(CoralType.values()).sorted(Comparator.comparingInt(CoralType::getIndex)).toArray(CoralType[]::new);
            TYPES_BY_NAME = Arrays.stream(CoralType.values()).collect(Collectors.toMap(CoralType::getName, p_221081_0_ -> p_221081_0_));
        }
    }

    class GrowCoralGoal
    extends Goal {
        private final Predicate<BlockState> coralPredicate = state -> state.func_235714_a_((ITag)BlockTags.field_205598_B);
        private int growTicks = 0;
        private int lastPollinationTick = 0;
        private boolean running;
        private Vector3d nextTarget;
        private int ticks = 0;

        GrowCoralGoal() {
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean func_75250_a() {
            if (SeahorseEntity.this.remainingCooldownBeforeLocatingNewCoral > 0) {
                return false;
            }
            if (SeahorseEntity.this.field_70170_p.func_72896_J()) {
                return false;
            }
            if (SeahorseEntity.this.field_70146_Z.nextFloat() < 0.7f) {
                return false;
            }
            Optional<BlockPos> optional = this.getCoral();
            if (optional.isPresent()) {
                SeahorseEntity.this.savedCoralPos = optional.get();
                SeahorseEntity.this.field_70699_by.func_75492_a((double)SeahorseEntity.this.savedCoralPos.func_177958_n() + 0.5, (double)SeahorseEntity.this.savedCoralPos.func_177956_o() + 0.5, (double)SeahorseEntity.this.savedCoralPos.func_177952_p() + 0.5, (double)1.2f);
                return true;
            }
            return false;
        }

        public boolean func_75253_b() {
            if (!this.running) {
                return false;
            }
            if (!SeahorseEntity.this.hasCoral()) {
                return false;
            }
            if (SeahorseEntity.this.field_70170_p.func_72896_J()) {
                return false;
            }
            if (this.completedGrowth()) {
                return SeahorseEntity.this.field_70146_Z.nextFloat() < 0.2f;
            }
            if (SeahorseEntity.this.field_70173_aa % 20 == 0 && !SeahorseEntity.this.isCoral(SeahorseEntity.this.savedCoralPos)) {
                SeahorseEntity.this.savedCoralPos = null;
                return false;
            }
            return true;
        }

        private boolean completedGrowth() {
            return this.growTicks > 400;
        }

        public void func_75249_e() {
            this.growTicks = 0;
            this.ticks = 0;
            this.lastPollinationTick = 0;
            this.running = true;
        }

        public void func_75251_c() {
            this.running = false;
            SeahorseEntity.this.field_70699_by.func_75499_g();
            SeahorseEntity.this.remainingCooldownBeforeLocatingNewCoral = 200;
        }

        public void func_75246_d() {
            ++this.ticks;
            if (this.ticks > 600) {
                SeahorseEntity.this.savedCoralPos = null;
            } else {
                Vector3d vector3d = Vector3d.func_237492_c_((Vector3i)SeahorseEntity.this.savedCoralPos).func_72441_c(0.0, (double)0.6f, 0.0);
                if (vector3d.func_72438_d(SeahorseEntity.this.func_213303_ch()) > 1.0) {
                    this.nextTarget = vector3d;
                    this.moveToNextTarget();
                } else {
                    if (this.nextTarget == null) {
                        this.nextTarget = vector3d;
                    }
                    boolean flag = SeahorseEntity.this.func_213303_ch().func_72438_d(this.nextTarget) <= 0.1;
                    boolean flag1 = true;
                    if (!flag && this.ticks > 600) {
                        SeahorseEntity.this.savedCoralPos = null;
                    } else {
                        if (flag) {
                            boolean flag2;
                            boolean bl = flag2 = SeahorseEntity.this.field_70146_Z.nextInt(25) == 0;
                            if (flag2) {
                                BlockPos coralPos = new BlockPos(this.nextTarget.field_72450_a, this.nextTarget.field_72448_b, this.nextTarget.field_72449_c);
                                Direction direction = Direction.func_82600_a((int)SeahorseEntity.this.field_70146_Z.nextInt(Direction.values().length));
                                BlockPos place = coralPos.func_177972_a(direction);
                                if ((SeahorseEntity.this.field_70170_p.func_175623_d(place) || SeahorseEntity.this.field_70170_p.func_180495_p(place).func_185904_a().func_76224_d()) && direction != Direction.DOWN) {
                                    if (direction == Direction.UP) {
                                        SeahorseEntity.this.field_70170_p.func_180501_a(place, (BlockState)SeahorseEntity.this.getVariantType().getCoral().func_206870_a((Property)AbstractCoralPlantBlock.field_212560_b, (Comparable)Boolean.valueOf(SeahorseEntity.this.field_70170_p.func_204610_c(place).func_206884_a((ITag)FluidTags.field_206959_a))), 3);
                                    } else {
                                        SeahorseEntity.this.field_70170_p.func_180501_a(place, (BlockState)SeahorseEntity.this.getVariantType().getFan().func_206870_a((Property)CoralFanBlock.field_212560_b, (Comparable)Boolean.valueOf(SeahorseEntity.this.field_70170_p.func_204610_c(place).func_206884_a((ITag)FluidTags.field_206959_a))), 3);
                                    }
                                }
                                this.nextTarget = new Vector3d(vector3d.func_82615_a() + (double)this.getRandomOffset(), vector3d.func_82617_b(), vector3d.func_82616_c() + (double)this.getRandomOffset());
                                SeahorseEntity.this.field_70699_by.func_75499_g();
                            } else {
                                flag1 = false;
                            }
                            SeahorseEntity.this.func_70671_ap().func_220679_a(vector3d.func_82615_a(), vector3d.func_82617_b(), vector3d.func_82616_c());
                        }
                        if (flag1) {
                            this.moveToNextTarget();
                        }
                        ++this.growTicks;
                        if (SeahorseEntity.this.field_70146_Z.nextFloat() < 0.05f && this.growTicks > this.lastPollinationTick + 60) {
                            this.lastPollinationTick = this.growTicks;
                            SeahorseEntity.this.func_184185_a(SoundEvents.field_203253_U, 1.0f, 1.0f);
                        }
                    }
                }
            }
        }

        private void moveToNextTarget() {
            SeahorseEntity.this.func_70605_aq().func_75642_a(this.nextTarget.func_82615_a(), this.nextTarget.func_82617_b(), this.nextTarget.func_82616_c(), (double)0.35f);
        }

        private float getRandomOffset() {
            return (SeahorseEntity.this.field_70146_Z.nextFloat() * 2.0f - 1.0f) * 0.33333334f;
        }

        private Optional<BlockPos> getCoral() {
            return this.findCoral(this.coralPredicate, 5.0);
        }

        private Optional<BlockPos> findCoral(Predicate<BlockState> p_226500_1_, double distance) {
            BlockPos blockpos = SeahorseEntity.this.func_233580_cy_();
            BlockPos.Mutable blockpos$mutable = new BlockPos.Mutable();
            int i = 0;
            while ((double)i <= distance) {
                int j = 0;
                while ((double)j < distance) {
                    int k = 0;
                    while (k <= j) {
                        int l;
                        int n = l = k < j && k > -j ? j : 0;
                        while (l <= j) {
                            blockpos$mutable.func_239621_a_((Vector3i)blockpos, k, i - 1, l);
                            if (blockpos.func_218141_a((Vector3i)blockpos$mutable, distance) && p_226500_1_.test(SeahorseEntity.this.field_70170_p.func_180495_p((BlockPos)blockpos$mutable))) {
                                return Optional.of(blockpos$mutable);
                            }
                            l = l > 0 ? -l : 1 - l;
                        }
                        k = k > 0 ? -k : 1 - k;
                    }
                    ++j;
                }
                i = i > 0 ? -i : 1 - i;
            }
            return Optional.empty();
        }
    }

    public class FindCoralGoal
    extends Goal {
        private int ticks;

        FindCoralGoal() {
            this.ticks = SeahorseEntity.this.field_70170_p.field_73012_v.nextInt(10);
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean canStart() {
            return SeahorseEntity.this.savedCoralPos != null && SeahorseEntity.this.isCoral(SeahorseEntity.this.savedCoralPos) && SeahorseEntity.this.isWithinDistance(SeahorseEntity.this.savedCoralPos, 2);
        }

        public boolean func_75250_a() {
            return this.canStart();
        }

        public boolean func_75253_b() {
            return this.canStart();
        }

        public void func_75249_e() {
            this.ticks = 0;
            super.func_75249_e();
        }

        public void func_75251_c() {
            this.ticks = 0;
            SeahorseEntity.this.field_70699_by.func_75499_g();
            SeahorseEntity.this.field_70699_by.func_226336_g_();
        }

        public void func_75246_d() {
            if (SeahorseEntity.this.savedCoralPos != null) {
                ++this.ticks;
                if (this.ticks > 600) {
                    SeahorseEntity.this.savedCoralPos = null;
                } else if (!SeahorseEntity.this.field_70699_by.func_226337_n_()) {
                    if (SeahorseEntity.this.isTooFar(SeahorseEntity.this.savedCoralPos)) {
                        SeahorseEntity.this.savedCoralPos = null;
                    } else {
                        SeahorseEntity.this.startMovingTo(SeahorseEntity.this.savedCoralPos);
                    }
                }
            }
        }
    }

    static class MoveHelperController
    extends MovementController {
        private final SeahorseEntity seahorse;

        public MoveHelperController(SeahorseEntity seahorse) {
            super((MobEntity)seahorse);
            this.seahorse = seahorse;
        }

        public void func_75641_c() {
            if (this.seahorse.func_70090_H()) {
                if (this.field_188491_h != MovementController.Action.MOVE_TO || this.seahorse.func_70661_as().func_75500_f()) {
                    this.seahorse.func_70659_e(0.0f);
                    return;
                }
                double d0 = this.field_75646_b - this.seahorse.func_226277_ct_();
                double d1 = this.field_75647_c - this.seahorse.func_226278_cu_();
                double d2 = this.field_75644_d - this.seahorse.func_226281_cx_();
                double d3 = MathHelper.func_76133_a((double)(d0 * d0 + d1 * d1 + d2 * d2));
                d1 /= d3;
                float f = (float)(MathHelper.func_181159_b((double)d2, (double)d0) * 57.2957763671875) - 90.0f;
                this.seahorse.field_70761_aq = this.seahorse.field_70177_z = this.func_75639_a(this.seahorse.field_70177_z, f, 90.0f);
                float f1 = (float)(this.field_75645_e * this.seahorse.func_233637_b_(Attributes.field_233821_d_));
                float f2 = MathHelper.func_219799_g((float)0.125f, (float)this.seahorse.func_70689_ay(), (float)f1);
                this.seahorse.func_70659_e(f2);
                this.seahorse.func_213317_d(this.seahorse.func_213322_ci().func_72441_c((double)f2 * d0 * 0.005, (double)f2 * d1 * 0.1, (double)f2 * d2 * 0.005));
            } else {
                if (!this.seahorse.field_70122_E) {
                    this.seahorse.func_213317_d(this.seahorse.func_213322_ci().func_72441_c(0.0, -0.008, 0.0));
                }
                super.func_75641_c();
            }
        }
    }
}

