/*
 * Decompiled with CFR 0.152.
 */
package pugz.omni.common.world.feature.cavier_caves;

import com.mojang.serialization.Codec;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.state.Property;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.Feature;
import pugz.omni.common.block.cavier_caves.SpeleothemBlock;
import pugz.omni.common.world.feature.cavier_caves.SpeleothemFeatureConfig;
import pugz.omni.core.util.CaveGenUtils;

public class SpeleothemFeature
extends Feature<SpeleothemFeatureConfig> {
    public SpeleothemFeature(Codec<SpeleothemFeatureConfig> config) {
        super(config);
    }

    public boolean generate(ISeedReader world, ChunkGenerator generator, Random random, BlockPos pos, SpeleothemFeatureConfig config) {
        if (random.nextBoolean() && config.variant != SpeleothemFeatureConfig.Variant.ICE) {
            BlockPos.Mutable lowerStart = CaveGenUtils.getCaveFloorPosition(world, pos, config.variant);
            if (world.func_180495_p(lowerStart.func_177984_a()).func_177230_c() instanceof SpeleothemBlock || world.func_180495_p(lowerStart.func_177977_b()).func_177230_c() instanceof SpeleothemBlock) {
                return false;
            }
            int lowerLength = CaveGenUtils.getCaveHeight(world, (BlockPos)lowerStart, config.variant);
            if (lowerLength == 0) {
                return false;
            }
            lowerLength = MathHelper.func_76125_a((int)random.nextInt(lowerLength), (int)3, (int)lowerLength);
            int third = Math.round((float)lowerLength / 3.0f);
            int runs = 0;
            boolean run1 = false;
            boolean run2 = false;
            for (int y = lowerStart.func_177956_o(); y <= lowerStart.func_177956_o() + lowerLength; ++y) {
                if (y > lowerStart.func_177956_o() + third && !run1) {
                    run1 = true;
                    ++runs;
                }
                if (y > lowerStart.func_177956_o() + third * 2 && !run2) {
                    run2 = true;
                    ++runs;
                }
                BlockPos place = new BlockPos(lowerStart.func_177958_n(), y, lowerStart.func_177952_p());
                SpeleothemFeature.placeFullSpeleothem(world, place, config, runs, false);
            }
            return true;
        }
        BlockPos.Mutable upperStart = CaveGenUtils.getCaveFloorPosition(world, pos, config.variant);
        if (world.func_180495_p(upperStart.func_177984_a()).func_177230_c() instanceof SpeleothemBlock || world.func_180495_p(upperStart.func_177977_b()).func_177230_c() instanceof SpeleothemBlock) {
            return false;
        }
        int upperLength = CaveGenUtils.getCaveHeight(world, (BlockPos)upperStart, config.variant);
        if (upperLength == 0 || !CaveGenUtils.isValidCavePos(world.func_180495_p(upperStart.func_177981_b(upperLength + 1)).func_177230_c(), config.variant)) {
            return false;
        }
        upperStart.func_185336_p(upperStart.func_177956_o() + (upperLength - 1));
        upperLength = MathHelper.func_76125_a((int)random.nextInt(upperLength), (int)3, (int)upperLength);
        int runs = 0;
        int third = Math.round((float)upperLength / 3.0f);
        boolean run1 = false;
        boolean run2 = false;
        for (int y = upperStart.func_177956_o(); y >= upperStart.func_177956_o() - upperLength; --y) {
            if (y < upperStart.func_177956_o() - third && !run1) {
                run1 = true;
                ++runs;
            }
            if (y < upperStart.func_177956_o() - third * 2 && !run2) {
                run2 = true;
                ++runs;
            }
            BlockPos place = new BlockPos(upperStart.func_177958_n(), y, upperStart.func_177952_p());
            SpeleothemFeature.placeFullSpeleothem(world, place, config, runs, true);
        }
        return true;
    }

    public static void placeSpeleothem(ISeedReader world, BlockPos pos, SpeleothemBlock.Size size, SpeleothemFeatureConfig config, boolean part) {
        Block block = world.func_180495_p(pos).func_177230_c();
        if (block == Blocks.field_201941_jj || block == Blocks.field_150355_j) {
            world.func_180501_a(pos, (BlockState)((BlockState)((BlockState)((BlockState)config.variant.getState().func_206870_a(SpeleothemBlock.SIZE, (Comparable)((Object)size))).func_206870_a(SpeleothemBlock.PART, (Comparable)((Object)(part ? SpeleothemBlock.Part.UPPER : SpeleothemBlock.Part.LOWER)))).func_206870_a((Property)SpeleothemBlock.STATIC, (Comparable)Boolean.valueOf(true))).func_206870_a((Property)SpeleothemBlock.WATERLOGGED, (Comparable)Boolean.valueOf(world.func_180495_p(pos).func_177230_c() == Blocks.field_150355_j)), 0);
        }
    }

    public static void placeFullSpeleothem(ISeedReader world, BlockPos pos, SpeleothemFeatureConfig config, int i, boolean part) {
        switch (i) {
            case 0: {
                if (config.variant == SpeleothemFeatureConfig.Variant.ICE) {
                    SpeleothemFeature.placeSpeleothem(world, pos, SpeleothemBlock.Size.ICE_LARGE, config, part);
                } else {
                    SpeleothemFeature.placeSpeleothem(world, pos, SpeleothemBlock.Size.LARGE, config, part);
                }
            }
            case 1: {
                SpeleothemFeature.placeSpeleothem(world, pos, SpeleothemBlock.Size.MEDIUM, config, part);
            }
            case 2: {
                SpeleothemFeature.placeSpeleothem(world, pos, SpeleothemBlock.Size.SMALL, config, part);
            }
        }
    }
}

