/*
 * Decompiled with CFR 0.152.
 */
package pugz.omni.common.world.noise;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.doubles.DoubleArrayList;
import it.unimi.dsi.fastutil.doubles.DoubleList;
import it.unimi.dsi.fastutil.ints.IntBidirectionalIterator;
import it.unimi.dsi.fastutil.ints.IntRBTreeSet;
import it.unimi.dsi.fastutil.ints.IntSortedSet;
import java.util.List;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import pugz.omni.common.world.noise.ImprovedNoise;
import pugz.omni.common.world.noise.SurfaceNoise;
import pugz.omni.common.world.noise.WorldGenRandom;

public class PerlinNoise
implements SurfaceNoise {
    private final ImprovedNoise[] improvedNoises;
    private final DoubleList doubles;
    private final double c;
    private final double d;

    public PerlinNoise(WorldGenRandom random, IntStream stream) {
        this(random, (List)stream.boxed().collect(ImmutableList.toImmutableList()));
    }

    public PerlinNoise(WorldGenRandom random, List<Integer> integers) {
        this(random, (IntSortedSet)new IntRBTreeSet(integers));
    }

    public static PerlinNoise a(WorldGenRandom random, int var1, DoubleList doubles) {
        return new PerlinNoise(random, (Pair<Integer, DoubleList>)Pair.of((Object)var1, (Object)doubles));
    }

    private static Pair<Integer, DoubleList> a(IntSortedSet integers) {
        int var2;
        if (integers.isEmpty()) {
            throw new IllegalArgumentException("Need some octaves!");
        }
        int var1 = -integers.firstInt();
        int var3 = var1 + (var2 = integers.lastInt()) + 1;
        if (var3 < 1) {
            throw new IllegalArgumentException("Total number of octaves needs to be >= 1");
        }
        DoubleArrayList var4 = new DoubleArrayList(new double[var3]);
        IntBidirectionalIterator var5 = integers.iterator();
        while (var5.hasNext()) {
            int var6 = var5.nextInt();
            var4.set(var6 + var1, 1.0);
        }
        return Pair.of((Object)(-var1), (Object)var4);
    }

    private PerlinNoise(WorldGenRandom random, IntSortedSet var2) {
        this(random, PerlinNoise.a(var2));
    }

    private PerlinNoise(WorldGenRandom random, Pair<Integer, DoubleList> var2) {
        double var7;
        int var3 = (Integer)var2.getFirst();
        this.doubles = (DoubleList)var2.getSecond();
        ImprovedNoise noise = new ImprovedNoise(random);
        int var5 = this.doubles.size();
        int var6 = -var3;
        this.improvedNoises = new ImprovedNoise[var5];
        if (var6 >= 0 && var6 < var5 && (var7 = this.doubles.getDouble(var6)) != 0.0) {
            this.improvedNoises[var6] = noise;
        }
        for (int var13 = var6 - 1; var13 >= 0; --var13) {
            if (var13 < var5) {
                double var8 = this.doubles.getDouble(var13);
                if (var8 != 0.0) {
                    this.improvedNoises[var13] = new ImprovedNoise(random);
                    continue;
                }
                random.a(262);
                continue;
            }
            random.a(262);
        }
        if (var6 < var5 - 1) {
            long var14 = (long)(noise.a(0.0, 0.0, 0.0, 0.0, 0.0) * 9.223372036854776E18);
            WorldGenRandom random1 = new WorldGenRandom(var14);
            for (int var10 = var6 + 1; var10 < var5; ++var10) {
                if (var10 >= 0) {
                    double var11 = this.doubles.getDouble(var10);
                    if (var11 != 0.0) {
                        this.improvedNoises[var10] = new ImprovedNoise(random1);
                        continue;
                    }
                    random1.a(262);
                    continue;
                }
                random1.a(262);
            }
        }
        this.d = Math.pow(2.0, -var6);
        this.c = Math.pow(2.0, var5 - 1) / (Math.pow(2.0, var5) - 1.0);
    }

    public double a(double var1, double var3, double var5) {
        return this.a(var1, var3, var5, 0.0, 0.0, false);
    }

    public double a(double var1, double var3, double var5, double var7, double var9, boolean var11) {
        double var12 = 0.0;
        double var14 = this.d;
        double var16 = this.c;
        for (int var18 = 0; var18 < this.improvedNoises.length; ++var18) {
            ImprovedNoise noise = this.improvedNoises[var18];
            if (noise != null) {
                var12 += this.doubles.getDouble(var18) * noise.a(PerlinNoise.a(var1 * var14), var11 ? -noise.b : PerlinNoise.a(var3 * var14), PerlinNoise.a(var5 * var14), var7 * var14, var9 * var14) * var16;
            }
            var14 *= 2.0;
            var16 /= 2.0;
        }
        return var12;
    }

    @Nullable
    public ImprovedNoise a(int var1) {
        return this.improvedNoises[this.improvedNoises.length - 1 - var1];
    }

    public static double a(double var0) {
        return var0 - Math.floor(var0 / 3.3554432E7 + 0.5) * 3.3554432E7;
    }

    @Override
    public double a(double var1, double var3, double var5, double var7) {
        return this.a(var1, var3, 0.0, var5, var7, false);
    }
}

