/*
 * Decompiled with CFR 0.152.
 */
package pugz.omni.core.module;

public abstract class AbstractModule {
    private final String name;

    public AbstractModule(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    protected abstract void onInitialize();

    protected abstract void onClientInitialize();

    protected abstract void onPostInitialize();

    protected abstract void sendInitMessage();

    public void initialize() {
        this.registerBlocks();
        this.registerItems();
        this.registerTileEntities();
        this.registerEntities();
        this.registerBiomes();
        this.registerSurfaceBuilders();
        this.registerFeatures();
        this.registerStructures();
        this.registerEnchantments();
        this.registerEffects();
        this.registerSounds();
        this.registerParticles();
        this.registerStats();
        this.onInitialize();
        this.sendInitMessage();
    }

    public void initializeClient() {
        this.onClientInitialize();
    }

    public void initializePost() {
        this.onPostInitialize();
    }

    protected void registerBlocks() {
    }

    protected void registerItems() {
    }

    protected void registerTileEntities() {
    }

    protected void registerEntities() {
    }

    protected void registerBiomes() {
    }

    protected void registerSurfaceBuilders() {
    }

    protected void registerFeatures() {
    }

    protected void registerStructures() {
    }

    protected void registerEnchantments() {
    }

    protected void registerEffects() {
    }

    protected void registerParticles() {
    }

    protected void registerSounds() {
    }

    protected void registerStats() {
    }
}

