/*
 * Decompiled with CFR 0.152.
 */
package pugz.omni.core.module;

import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.item.ItemGroup;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.world.BiomeGenerationSettingsBuilder;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import pugz.omni.common.block.cavier_caves.BuddingMalachiteBlock;
import pugz.omni.common.block.cavier_caves.MalachiteBudBlock;
import pugz.omni.common.block.cavier_caves.SpeleothemBlock;
import pugz.omni.common.world.feature.cavier_caves.GeodeFeature;
import pugz.omni.common.world.feature.cavier_caves.GeodeFeatureConfig;
import pugz.omni.common.world.feature.cavier_caves.SpeleothemFeature;
import pugz.omni.common.world.feature.cavier_caves.SpeleothemFeatureConfig;
import pugz.omni.core.module.AbstractModule;
import pugz.omni.core.registry.OmniBlocks;
import pugz.omni.core.registry.OmniFeatures;
import pugz.omni.core.util.BiomeFeatures;
import pugz.omni.core.util.RegistryUtil;

public class CavierCavesModule
extends AbstractModule {
    public static final CavierCavesModule instance = new CavierCavesModule();

    public CavierCavesModule() {
        super("Cavier Caves");
    }

    @Override
    protected void sendInitMessage() {
        System.out.println("Explored the Depths of the Cavier Caves!");
    }

    @Override
    protected void onInitialize() {
        MinecraftForge.EVENT_BUS.addListener(this::onBiomeLoading);
    }

    @Override
    protected void onClientInitialize() {
        RenderTypeLookup.setRenderLayer((Block)((Block)OmniBlocks.MALACHITE_CLUSTER.get()), (RenderType)RenderType.func_228643_e_());
        RenderTypeLookup.setRenderLayer((Block)((Block)OmniBlocks.LARGE_MALACHITE_BUD.get()), (RenderType)RenderType.func_228643_e_());
        RenderTypeLookup.setRenderLayer((Block)((Block)OmniBlocks.MEDIUM_MALACHITE_BUD.get()), (RenderType)RenderType.func_228643_e_());
        RenderTypeLookup.setRenderLayer((Block)((Block)OmniBlocks.SMALL_MALACHITE_BUD.get()), (RenderType)RenderType.func_228643_e_());
    }

    @Override
    protected void onPostInitialize() {
    }

    @Override
    protected void registerBlocks() {
        OmniBlocks.STONE_SPELEOTHEM = RegistryUtil.createBlock("stone_speleothem", () -> new SpeleothemBlock(AbstractBlock.Properties.func_200949_a((Material)Material.field_151576_e, (MaterialColor)MaterialColor.field_151665_m).func_235861_h_().func_200948_a(1.25f, 4.5f)), ItemGroup.field_78031_c);
        OmniBlocks.ICE_SPELEOTHEM = RegistryUtil.createBlock("ice_speleothem", () -> new SpeleothemBlock(AbstractBlock.Properties.func_200945_a((Material)Material.field_151598_x).func_200941_a(0.98f).func_200943_b(0.4f).func_200947_a(SoundType.field_185853_f)), ItemGroup.field_78031_c);
        OmniBlocks.NETHERRACK_SPELEOTHEM = RegistryUtil.createBlock("netherrack_speleothem", () -> new SpeleothemBlock(AbstractBlock.Properties.func_200949_a((Material)Material.field_151576_e, (MaterialColor)MaterialColor.field_151655_K).func_235861_h_().func_200943_b(0.3f)), ItemGroup.field_78031_c);
        OmniBlocks.MALACHITE_BLOCK = RegistryUtil.createBlock("malachite_block", () -> new Block(AbstractBlock.Properties.func_200945_a((Material)Material.field_151576_e).func_200948_a(4.5f, 10.0f)), ItemGroup.field_78030_b);
        OmniBlocks.BUDDING_MALACHITE = RegistryUtil.createBlock("budding_malachite", BuddingMalachiteBlock::new, ItemGroup.field_78030_b);
        OmniBlocks.MALACHITE_CLUSTER = RegistryUtil.createBlock("malachite_cluster", () -> new MalachiteBudBlock(AbstractBlock.Properties.func_200945_a((Material)Material.field_151576_e).func_200948_a(4.5f, 9.5f), 3), ItemGroup.field_78031_c);
        OmniBlocks.LARGE_MALACHITE_BUD = RegistryUtil.createBlock("large_malachite_bud", () -> new MalachiteBudBlock(AbstractBlock.Properties.func_200945_a((Material)Material.field_151576_e).func_200948_a(4.0f, 9.0f), 2), ItemGroup.field_78031_c);
        OmniBlocks.MEDIUM_MALACHITE_BUD = RegistryUtil.createBlock("medium_malachite_bud", () -> new MalachiteBudBlock(AbstractBlock.Properties.func_200945_a((Material)Material.field_151576_e).func_200948_a(3.5f, 8.5f), 1), ItemGroup.field_78031_c);
        OmniBlocks.SMALL_MALACHITE_BUD = RegistryUtil.createBlock("small_malachite_bud", () -> new MalachiteBudBlock(AbstractBlock.Properties.func_200945_a((Material)Material.field_151576_e).func_200948_a(3.0f, 8.0f), 0), ItemGroup.field_78031_c);
    }

    @Override
    protected void registerItems() {
    }

    @Override
    protected void registerTileEntities() {
    }

    @Override
    protected void registerEntities() {
    }

    @Override
    protected void registerFeatures() {
        OmniFeatures.SPELEOTHEM = RegistryUtil.createFeature("speleothem", () -> new SpeleothemFeature(SpeleothemFeatureConfig.codec));
        OmniFeatures.GEODE = RegistryUtil.createFeature("geode", () -> new GeodeFeature(GeodeFeatureConfig.b));
    }

    @Override
    protected void registerStructures() {
    }

    @Override
    protected void registerEffects() {
    }

    @Override
    protected void registerParticles() {
    }

    @Override
    protected void registerStats() {
    }

    public void onBiomeLoading(BiomeLoadingEvent event) {
        Biome.Category category = event.getCategory();
        BiomeGenerationSettingsBuilder gen = event.getGeneration();
        if (category != Biome.Category.NETHER && category != Biome.Category.THEEND) {
            BiomeFeatures.addSpeleothems(gen, SpeleothemFeatureConfig.Variant.STONE, 0.004f);
            BiomeFeatures.addMalachiteGeodes(gen);
        }
        if (category == Biome.Category.ICY) {
            BiomeFeatures.addSpeleothems(gen, SpeleothemFeatureConfig.Variant.ICE, 0.006f);
        }
        if (category == Biome.Category.NETHER) {
            BiomeFeatures.addSpeleothems(gen, SpeleothemFeatureConfig.Variant.NETHERRACK, 0.008f);
        }
    }
}

