/*
 * Decompiled with CFR 0.152.
 */
package pugz.omni.core.module;

import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.block.ConcretePowderBlock;
import net.minecraft.block.FireBlock;
import net.minecraft.block.FlowerBlock;
import net.minecraft.block.FungusBlock;
import net.minecraft.block.MushroomBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.DyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.Features;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.BiomeManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.world.BiomeGenerationSettingsBuilder;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.village.WandererTradesEvent;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.StringUtils;
import pugz.omni.client.render.FallingConcretePowderRenderer;
import pugz.omni.common.block.AbstractStackableBlock;
import pugz.omni.common.block.colormatic.FlowersBlock;
import pugz.omni.common.block.colormatic.FungiBlock;
import pugz.omni.common.block.colormatic.GlazedTerracottaPillarBlock;
import pugz.omni.common.block.colormatic.LayerConcreteBlock;
import pugz.omni.common.block.colormatic.LayerConcretePowderBlock;
import pugz.omni.common.block.colormatic.MushroomsBlock;
import pugz.omni.common.block.colormatic.QuiltedCarpetBlock;
import pugz.omni.core.module.AbstractModule;
import pugz.omni.core.registry.OmniBiomes;
import pugz.omni.core.registry.OmniBlocks;
import pugz.omni.core.registry.OmniEntities;
import pugz.omni.core.util.RegistryUtil;
import pugz.omni.core.util.TradeUtils;

public class ColormaticModule
extends AbstractModule {
    public static final ColormaticModule instance = new ColormaticModule();
    public static List<Supplier<AbstractStackableBlock>> stackables = new ArrayList<Supplier<AbstractStackableBlock>>();
    public static List<Supplier<Block>> quilteds = new ArrayList<Supplier<Block>>();

    @Override
    protected void sendInitMessage() {
        System.out.println("Discovered the end of the Colormatic Rainbow!");
    }

    public ColormaticModule() {
        super("Colormatic");
    }

    @Override
    public void onInitialize() {
        MinecraftForge.EVENT_BUS.addListener(this::onWandererTrades);
        MinecraftForge.EVENT_BUS.addListener(this::onBiomeLoading);
        MinecraftForge.EVENT_BUS.addListener(this::onRightClickBlock);
    }

    @Override
    protected void onClientInitialize() {
        for (Supplier<AbstractStackableBlock> block : stackables) {
            RenderTypeLookup.setRenderLayer((Block)((Block)block.get()), (RenderType)RenderType.func_228643_e_());
        }
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)OmniEntities.FALLING_CONCRETE_POWDER.get()), FallingConcretePowderRenderer::new);
    }

    @Override
    protected void onPostInitialize() {
        FireBlock fire = (FireBlock)Blocks.field_150480_ab;
        fire.func_180686_a((Block)OmniBlocks.TRADERS_QUILTED_CARPET.get(), 60, 20);
        fire.func_180686_a((Block)OmniBlocks.TRADERS_QUILTED_WOOL.get(), 30, 60);
        for (Supplier<AbstractStackableBlock> supplier : stackables) {
            if (!(supplier.get() instanceof FlowersBlock)) continue;
            fire.func_180686_a((Block)supplier.get(), 60, 100);
        }
        for (Supplier<AbstractStackableBlock> supplier : quilteds) {
            if (StringUtils.contains((CharSequence)((Block)supplier.get()).getRegistryName().func_110623_a(), (CharSequence)"wool")) {
                fire.func_180686_a((Block)supplier.get(), 30, 60);
                continue;
            }
            fire.func_180686_a((Block)supplier.get(), 60, 20);
        }
    }

    @Override
    protected void registerBlocks() {
        for (DyeColor color : DyeColor.values()) {
            RegistryObject<Block> OVERRIDE_CONCRETE = RegistryUtil.createOverrideBlock(color.name().toLowerCase() + "_concrete", () -> new Block(AbstractBlock.Properties.func_200950_a((AbstractBlock)Blocks.field_196858_iR)), null);
            RegistryObject<Block> OVERRIDE_CONCRETE_POWDER = RegistryUtil.createOverrideBlock(color.name().toLowerCase() + "_concrete_powder", () -> new ConcretePowderBlock((Block)OVERRIDE_CONCRETE.get(), AbstractBlock.Properties.func_200950_a((AbstractBlock)Blocks.field_196884_jh)), null);
            RegistryObject<Block> QUILTED_CARPET = RegistryUtil.createBlock(color.name().toLowerCase() + "_quilted_carpet", () -> new QuiltedCarpetBlock(color), ItemGroup.field_78031_c);
            RegistryObject<Block> QUILTED_WOOL = RegistryUtil.createBlock(color.name().toLowerCase() + "_quilted_wool", () -> new Block(AbstractBlock.Properties.func_200952_a((Material)Material.field_151580_n, (DyeColor)color).func_200943_b(0.8f).func_200947_a(SoundType.field_185854_g)), ItemGroup.field_78030_b);
            RegistryObject<Block> GLAZED_TERRACOTTA_PILLAR = RegistryUtil.createBlock(color.name().toLowerCase() + "_glazed_terracotta_pillar", GlazedTerracottaPillarBlock::new, ItemGroup.field_78031_c);
            RegistryObject<Block> CONCRETE = RegistryUtil.createBlock(color.name().toLowerCase() + "_concrete", () -> new LayerConcreteBlock(color), ItemGroup.field_78030_b);
            RegistryObject<Block> CONCRETE_POWDER = RegistryUtil.createBlock(color.name().toLowerCase() + "_concrete_powder", () -> new LayerConcretePowderBlock((Block)CONCRETE.get(), color), ItemGroup.field_78030_b);
            quilteds.addAll((Collection<Supplier<Block>>)ImmutableSet.of(QUILTED_CARPET, QUILTED_WOOL));
        }
        for (Block block : ForgeRegistries.BLOCKS.getValues()) {
            ConfiguredFeature configuredFeature;
            if (block instanceof FlowerBlock) {
                String name = block.getRegistryName().func_110623_a() + "s";
                if (StringUtils.endsWith((CharSequence)name, (CharSequence)"ss")) {
                    name = StringUtils.removeEnd((String)name, (String)"ss") + "ses";
                }
                RegistryObject<AbstractStackableBlock> FLOWERS = RegistryUtil.createBlock(name, () -> new FlowersBlock(AbstractBlock.Properties.func_200950_a((AbstractBlock)block), block), null);
                stackables.add((Supplier<AbstractStackableBlock>)FLOWERS);
                continue;
            }
            if (block instanceof MushroomBlock) {
                String name = block.getRegistryName().func_110623_a() + "s";
                configuredFeature = StringUtils.contains((CharSequence)name, (CharSequence)"red") ? Features.field_243861_bG : Features.field_243860_bF;
                RegistryObject<AbstractStackableBlock> MUSHROOMS = RegistryUtil.createBlock(name, () -> new MushroomsBlock(AbstractBlock.Properties.func_200950_a((AbstractBlock)block), block, () -> configuredFeature), null);
                stackables.add((Supplier<AbstractStackableBlock>)MUSHROOMS);
                continue;
            }
            if (!(block instanceof FungusBlock)) continue;
            String name = StringUtils.replace((String)block.getRegistryName().func_110623_a(), (String)"us", (String)"i");
            configuredFeature = StringUtils.contains((CharSequence)name, (CharSequence)"crimson") ? Features.field_243857_bC : Features.field_243859_bE;
            RegistryObject<AbstractStackableBlock> FUNGI = RegistryUtil.createBlock(name, () -> new FungiBlock(AbstractBlock.Properties.func_200950_a((AbstractBlock)block), block, () -> configuredFeature), null);
            stackables.add((Supplier<AbstractStackableBlock>)FUNGI);
        }
        OmniBlocks.TRADERS_QUILTED_CARPET = RegistryUtil.createBlock("traders_quilted_carpet", () -> new QuiltedCarpetBlock(DyeColor.BLUE), ItemGroup.field_78031_c);
        OmniBlocks.TRADERS_QUILTED_WOOL = RegistryUtil.createBlock("traders_quilted_wool", () -> new Block(AbstractBlock.Properties.func_200952_a((Material)Material.field_151580_n, (DyeColor)DyeColor.BLUE).func_200943_b(0.8f).func_200947_a(SoundType.field_185854_g)), ItemGroup.field_78030_b);
    }

    @Override
    protected void registerItems() {
        for (DyeColor color : DyeColor.values()) {
            RegistryObject<Item> OVERRIDE_CONCRETE = RegistryUtil.createOverrideItem(color.name().toLowerCase() + "_concrete", () -> new BlockItem((Block)Objects.requireNonNull(ForgeRegistries.BLOCKS.getValue(new ResourceLocation("minecraft", color.name().toLowerCase() + "_concrete"))), new Item.Properties()), null);
            RegistryObject<Item> registryObject = RegistryUtil.createOverrideItem(color.name().toLowerCase() + "_concrete_powder", () -> new BlockItem((Block)Objects.requireNonNull(ForgeRegistries.BLOCKS.getValue(new ResourceLocation("minecraft", color.name().toLowerCase() + "_concrete"))), new Item.Properties()), null);
        }
    }

    @Override
    protected void registerEntities() {
        OmniEntities.FALLING_CONCRETE_POWDER = RegistryUtil.createEntity("falling_concrete_powder", OmniEntities::createFallingBlockEntity);
    }

    @Override
    protected void registerBiomes() {
        OmniBiomes.FLOWER_FIELD = RegistryUtil.createBiome("flower_field", OmniBiomes.createFlowerFieldBiome(), BiomeManager.BiomeType.WARM, 1, BiomeDictionary.Type.PLAINS, BiomeDictionary.Type.RARE, BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.LUSH);
    }

    @Override
    protected void registerFeatures() {
    }

    @Override
    protected void registerEffects() {
    }

    @Override
    protected void registerParticles() {
    }

    @Override
    protected void registerSounds() {
    }

    @Override
    protected void registerStats() {
    }

    public void onWandererTrades(WandererTradesEvent event) {
        event.getGenericTrades().addAll(ImmutableSet.of((Object)new TradeUtils.ItemsForEmeraldsTrade(new ItemStack((IItemProvider)OmniBlocks.RED_LOTUS_FLOWER.get()), 1, 1, 12, 1), (Object)new TradeUtils.ItemsForEmeraldsTrade(new ItemStack((IItemProvider)OmniBlocks.BLUE_LOTUS_FLOWER.get()), 1, 1, 12, 1), (Object)new TradeUtils.ItemsForEmeraldsTrade(new ItemStack((IItemProvider)OmniBlocks.PINK_LOTUS_FLOWER.get()), 1, 1, 12, 1), (Object)new TradeUtils.ItemsForEmeraldsTrade(new ItemStack((IItemProvider)OmniBlocks.BLACK_LOTUS_FLOWER.get()), 1, 1, 12, 1), (Object)new TradeUtils.ItemsForEmeraldsTrade(new ItemStack((IItemProvider)OmniBlocks.WHITE_LOTUS_FLOWER.get()), 1, 1, 12, 1), (Object)new TradeUtils.ItemsForEmeraldsTrade(new ItemStack((IItemProvider)OmniBlocks.PURPLE_LOTUS_FLOWER.get()), 1, 1, 12, 1), (Object[])new TradeUtils.ItemsForEmeraldsTrade[]{new TradeUtils.ItemsForEmeraldsTrade(new ItemStack((IItemProvider)OmniBlocks.ORANGE_LOTUS_FLOWER.get()), 1, 1, 12, 1), new TradeUtils.ItemsForEmeraldsTrade(new ItemStack((IItemProvider)OmniBlocks.YELLOW_LOTUS_FLOWER.get()), 1, 1, 12, 1), new TradeUtils.ItemsForEmeraldsTrade(new ItemStack((IItemProvider)OmniBlocks.TRADERS_QUILTED_WOOL.get()), 1, 8, 8, 2)}));
    }

    public void onBiomeLoading(BiomeLoadingEvent event) {
        BiomeGenerationSettingsBuilder gen = event.getGeneration();
        ResourceLocation name = event.getName();
        assert (name != null);
        if (name.equals((Object)new ResourceLocation("omni", "flower_field"))) {
            gen.getFeatures(GenerationStage.Decoration.VEGETAL_DECORATION).add(() -> Features.field_243931_cn);
            gen.getFeatures(GenerationStage.Decoration.VEGETAL_DECORATION).add(() -> Features.field_243927_cj);
        }
    }

    public void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        World world = event.getWorld();
        ItemStack stack = event.getItemStack();
        BlockPos pos = event.getPos();
        Block block = world.func_180495_p(pos).func_177230_c();
        PlayerEntity player = event.getPlayer();
        if (block instanceof FlowerBlock || block instanceof MushroomBlock || block instanceof FungusBlock) {
            for (Supplier<AbstractStackableBlock> b : stackables) {
                AbstractStackableBlock stackable = b.get();
                if (stack.func_77973_b() != block.func_199767_j() || stackable.getBase() != block || player.func_225608_bj_()) continue;
                if (!player.func_184812_l_()) {
                    stack.func_190918_g(1);
                }
                world.func_180501_a(pos, stackable.getBlock().func_176223_P(), 3);
                event.setCancellationResult(ActionResultType.func_233537_a_((boolean)world.field_72995_K));
                event.setCanceled(true);
            }
        }
    }
}

