/*
 * Decompiled with CFR 0.152.
 */
package pugz.omni.core.module;

import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.block.RotatedPillarBlock;
import net.minecraft.block.SlabBlock;
import net.minecraft.block.StairsBlock;
import net.minecraft.block.WallBlock;
import net.minecraft.item.ItemGroup;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.feature.OreFeatureConfig;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.world.BiomeGenerationSettingsBuilder;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.fml.ModList;
import pugz.omni.common.block.VerticalSlabBlock;
import pugz.omni.common.block.deserted.RedRockBrickButton;
import pugz.omni.common.block.deserted.RedRockBrickPressurePlate;
import pugz.omni.core.module.AbstractModule;
import pugz.omni.core.registry.OmniBlocks;
import pugz.omni.core.util.BiomeFeatures;
import pugz.omni.core.util.RegistryUtil;

public class DesertedModule
extends AbstractModule {
    public static final DesertedModule instance = new DesertedModule();

    public DesertedModule() {
        super("Deserted");
    }

    @Override
    protected void sendInitMessage() {
        System.out.println("Wandering the Deserted Desert...");
    }

    @Override
    protected void onInitialize() {
        MinecraftForge.EVENT_BUS.addListener(this::onBiomeLoading);
    }

    @Override
    protected void onClientInitialize() {
    }

    @Override
    protected void onPostInitialize() {
    }

    @Override
    protected void registerBlocks() {
        OmniBlocks.RED_ROCK = RegistryUtil.createBlock("red_rock", () -> new Block(AbstractBlock.Properties.func_200950_a((AbstractBlock)Blocks.field_150322_A)), ItemGroup.field_78030_b);
        OmniBlocks.RED_ROCK_STAIRS = RegistryUtil.createBlock("red_rock_stairs", () -> new StairsBlock(() -> ((Block)OmniBlocks.RED_ROCK.get()).func_176223_P(), AbstractBlock.Properties.func_200950_a((AbstractBlock)Blocks.field_150347_e)), ItemGroup.field_78030_b);
        OmniBlocks.RED_ROCK_SLAB = RegistryUtil.createBlock("red_rock_slab", () -> new SlabBlock(AbstractBlock.Properties.func_200950_a((AbstractBlock)((AbstractBlock)OmniBlocks.RED_ROCK.get()))), ItemGroup.field_78030_b);
        OmniBlocks.RED_ROCK_WALL = RegistryUtil.createBlock("red_rock_wall", () -> new WallBlock(AbstractBlock.Properties.func_200950_a((AbstractBlock)((AbstractBlock)OmniBlocks.RED_ROCK.get()))), ItemGroup.field_78031_c);
        OmniBlocks.RED_ROCK_BRICKS = RegistryUtil.createBlock("red_rock_bricks", () -> new Block(AbstractBlock.Properties.func_200950_a((AbstractBlock)((AbstractBlock)OmniBlocks.RED_ROCK.get()))), ItemGroup.field_78030_b);
        OmniBlocks.RED_ROCK_BRICK_STAIRS = RegistryUtil.createBlock("red_rock_brick_stairs", () -> new StairsBlock(() -> ((Block)OmniBlocks.RED_ROCK_BRICKS.get()).func_176223_P(), AbstractBlock.Properties.func_200950_a((AbstractBlock)Blocks.field_196696_di)), ItemGroup.field_78030_b);
        OmniBlocks.RED_ROCK_BRICK_SLAB = RegistryUtil.createBlock("red_rock_brick_slab", () -> new SlabBlock(AbstractBlock.Properties.func_200950_a((AbstractBlock)((AbstractBlock)OmniBlocks.RED_ROCK_BRICKS.get()))), ItemGroup.field_78030_b);
        OmniBlocks.RED_ROCK_BRICK_WALL = RegistryUtil.createBlock("red_rock_brick_wall", () -> new WallBlock(AbstractBlock.Properties.func_200950_a((AbstractBlock)((AbstractBlock)OmniBlocks.RED_ROCK_BRICKS.get()))), ItemGroup.field_78031_c);
        OmniBlocks.CHISELED_RED_ROCK_BRICKS = RegistryUtil.createBlock("chiseled_red_rock_bricks", () -> new Block(AbstractBlock.Properties.func_200950_a((AbstractBlock)((AbstractBlock)OmniBlocks.RED_ROCK_BRICKS.get()))), ItemGroup.field_78030_b);
        OmniBlocks.CRACKED_RED_ROCK_BRICKS = RegistryUtil.createBlock("cracked_red_rock_bricks", () -> new Block(AbstractBlock.Properties.func_200950_a((AbstractBlock)((AbstractBlock)OmniBlocks.RED_ROCK_BRICKS.get()))), ItemGroup.field_78030_b);
        OmniBlocks.RED_ROCK_PILLAR = RegistryUtil.createBlock("red_rock_pillar", () -> new RotatedPillarBlock(AbstractBlock.Properties.func_200950_a((AbstractBlock)((AbstractBlock)OmniBlocks.RED_ROCK_BRICKS.get()))), ItemGroup.field_78030_b);
        OmniBlocks.RED_ROCK_BRICK_BUTTON = RegistryUtil.createBlock("red_rock_brick_button", RedRockBrickButton::new, ItemGroup.field_78028_d);
        OmniBlocks.RED_ROCK_BRICK_PRESSURE_PLATE = RegistryUtil.createBlock("red_rock_brick_pressure_plate", RedRockBrickPressurePlate::new, ItemGroup.field_78028_d);
        if (ModList.get().isLoaded("quark")) {
            OmniBlocks.RED_ROCK_VERTICAL_SLAB = RegistryUtil.createBlock("red_rock_vertical_slab", () -> new VerticalSlabBlock(AbstractBlock.Properties.func_200950_a((AbstractBlock)((AbstractBlock)OmniBlocks.RED_ROCK.get()))), ItemGroup.field_78030_b);
            OmniBlocks.RED_ROCK_BRICK_VERICAL_SLAB = RegistryUtil.createBlock("red_rock_brick_vertical_slab", () -> new VerticalSlabBlock(AbstractBlock.Properties.func_200950_a((AbstractBlock)((AbstractBlock)OmniBlocks.RED_ROCK.get()))), ItemGroup.field_78030_b);
            OmniBlocks.RED_ROCK_PAVEMENT = RegistryUtil.createBlock("red_rock_pavement", () -> new Block(AbstractBlock.Properties.func_200950_a((AbstractBlock)((AbstractBlock)OmniBlocks.RED_ROCK_BRICKS.get()))), ItemGroup.field_78030_b);
        }
    }

    @Override
    protected void registerTileEntities() {
    }

    @Override
    protected void registerEntities() {
    }

    @Override
    protected void registerBiomes() {
    }

    @Override
    protected void registerSurfaceBuilders() {
    }

    @Override
    protected void registerFeatures() {
    }

    @Override
    protected void registerStructures() {
    }

    @Override
    protected void registerEffects() {
    }

    @Override
    protected void registerSounds() {
    }

    @Override
    protected void registerStats() {
    }

    public void onBiomeLoading(BiomeLoadingEvent event) {
        Biome.Category category = event.getCategory();
        BiomeGenerationSettingsBuilder gen = event.getGeneration();
        if (category == Biome.Category.MESA) {
            BiomeFeatures.addOreCluster(gen, OreFeatureConfig.FillerBlockType.field_241882_a, ((Block)OmniBlocks.RED_ROCK.get()).func_176223_P(), 36, 0, 0, 100, 10, 80);
        }
    }
}

