/*
 * Decompiled with CFR 0.152.
 */
package pugz.omni.core.module;

import net.minecraft.util.SoundEvent;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeAmbience;
import net.minecraft.world.biome.MoodSoundAmbience;
import net.minecraft.world.biome.ParticleEffectAmbience;
import net.minecraft.world.biome.SoundAdditionsAmbience;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import pugz.omni.core.module.AbstractModule;
import pugz.omni.core.registry.OmniSoundEvents;
import pugz.omni.core.util.RegistryUtil;

public class ForestryModule
extends AbstractModule {
    public static final ForestryModule instance = new ForestryModule();

    public ForestryModule() {
        super("Forestry");
    }

    @Override
    protected void sendInitMessage() {
        System.out.println("Relaxing within all the Forestry.");
    }

    @Override
    protected void onInitialize() {
        MinecraftForge.EVENT_BUS.addListener(this::onBiomeLoading);
    }

    @Override
    protected void onClientInitialize() {
    }

    @Override
    protected void onPostInitialize() {
    }

    @Override
    protected void registerBlocks() {
    }

    @Override
    protected void registerItems() {
    }

    @Override
    protected void registerEntities() {
    }

    @Override
    protected void registerBiomes() {
    }

    @Override
    protected void registerFeatures() {
    }

    @Override
    protected void registerSounds() {
        OmniSoundEvents.AMBIENT_FOREST = RegistryUtil.createSoundEvent("ambient.forest");
        OmniSoundEvents.AMBIENT_JUNGLE = RegistryUtil.createSoundEvent("ambient.jungle");
        OmniSoundEvents.AMBIENT_PLAINS = RegistryUtil.createSoundEvent("ambient.plains");
        OmniSoundEvents.AMBIENT_SWAMP = RegistryUtil.createSoundEvent("ambient.swamp");
    }

    public void onBiomeLoading(BiomeLoadingEvent event) {
        BiomeAmbience effects = event.getEffects();
        BiomeAmbience.Builder ambience = new BiomeAmbience.Builder().func_242537_a(effects.func_242531_g()).func_235246_b_(effects.func_235216_b_()).func_235248_c_(effects.func_235218_c_()).func_235239_a_(effects.func_235213_a_()).func_242539_d(effects.func_242527_d());
        if (effects.func_242528_e().isPresent()) {
            ambience = ambience.func_242540_e(((Integer)effects.func_242528_e().get()).intValue());
        }
        if (effects.func_242529_f().isPresent()) {
            ambience = ambience.func_242541_f(((Integer)effects.func_242529_f().get()).intValue());
        }
        if (effects.func_235224_f_().isPresent()) {
            ambience = ambience.func_235243_a_((MoodSoundAmbience)effects.func_235224_f_().get());
        }
        if (effects.func_235226_g_().isPresent()) {
            ambience = ambience.func_235242_a_((SoundAdditionsAmbience)effects.func_235226_g_().get());
        }
        if (effects.func_235220_d_().isPresent()) {
            ambience = ambience.func_235244_a_((ParticleEffectAmbience)effects.func_235220_d_().get());
        }
        if (event.getCategory() == Biome.Category.FOREST) {
            event.setEffects(ambience.func_235241_a_((SoundEvent)OmniSoundEvents.AMBIENT_FOREST.get()).func_235238_a_());
        } else if (event.getCategory() == Biome.Category.JUNGLE) {
            event.setEffects(ambience.func_235241_a_((SoundEvent)OmniSoundEvents.AMBIENT_JUNGLE.get()).func_235238_a_());
        } else if (event.getCategory() == Biome.Category.PLAINS) {
            event.setEffects(ambience.func_235241_a_((SoundEvent)OmniSoundEvents.AMBIENT_PLAINS.get()).func_235238_a_());
        } else if (event.getCategory() == Biome.Category.SWAMP) {
            event.setEffects(ambience.func_235241_a_((SoundEvent)OmniSoundEvents.AMBIENT_SWAMP.get()).func_235238_a_());
        }
    }
}

