/*
 * Decompiled with CFR 0.152.
 */
package pugz.omni.core.module;

import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.block.ComposterBlock;
import net.minecraft.block.FireBlock;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.potion.Effects;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeMaker;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.BiomeManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.world.BiomeGenerationSettingsBuilder;
import net.minecraftforge.common.world.MobSpawnInfoBuilder;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import pugz.omni.common.block.paradise.LotusFlowerBlock;
import pugz.omni.common.item.OmniSpawnEggItem;
import pugz.omni.core.module.AbstractModule;
import pugz.omni.core.registry.OmniBiomes;
import pugz.omni.core.registry.OmniBlocks;
import pugz.omni.core.registry.OmniEntities;
import pugz.omni.core.registry.OmniItems;
import pugz.omni.core.util.BiomeFeatures;
import pugz.omni.core.util.RegistryUtil;

public class ParadiseModule
extends AbstractModule {
    public static final ParadiseModule instance = new ParadiseModule();

    public ParadiseModule() {
        super("Paradise");
    }

    @Override
    protected void sendInitMessage() {
        System.out.println("Ah, yes. Vibing in Paradise...");
    }

    @Override
    protected void onInitialize() {
        MinecraftForge.EVENT_BUS.addListener(this::onBiomeLoading);
    }

    @Override
    protected void onClientInitialize() {
        RenderTypeLookup.setRenderLayer((Block)((Block)OmniBlocks.YELLOW_LOTUS_FLOWER.get()), (RenderType)RenderType.func_228643_e_());
        RenderTypeLookup.setRenderLayer((Block)((Block)OmniBlocks.ORANGE_LOTUS_FLOWER.get()), (RenderType)RenderType.func_228643_e_());
        RenderTypeLookup.setRenderLayer((Block)((Block)OmniBlocks.RED_LOTUS_FLOWER.get()), (RenderType)RenderType.func_228643_e_());
        RenderTypeLookup.setRenderLayer((Block)((Block)OmniBlocks.PINK_LOTUS_FLOWER.get()), (RenderType)RenderType.func_228643_e_());
        RenderTypeLookup.setRenderLayer((Block)((Block)OmniBlocks.PURPLE_LOTUS_FLOWER.get()), (RenderType)RenderType.func_228643_e_());
        RenderTypeLookup.setRenderLayer((Block)((Block)OmniBlocks.BLUE_LOTUS_FLOWER.get()), (RenderType)RenderType.func_228643_e_());
        RenderTypeLookup.setRenderLayer((Block)((Block)OmniBlocks.BLACK_LOTUS_FLOWER.get()), (RenderType)RenderType.func_228643_e_());
        RenderTypeLookup.setRenderLayer((Block)((Block)OmniBlocks.WHITE_LOTUS_FLOWER.get()), (RenderType)RenderType.func_228643_e_());
    }

    @Override
    protected void onPostInitialize() {
        FireBlock fire = (FireBlock)Blocks.field_150480_ab;
        fire.func_180686_a((Block)OmniBlocks.YELLOW_LOTUS_FLOWER.get(), 60, 100);
        fire.func_180686_a((Block)OmniBlocks.ORANGE_LOTUS_FLOWER.get(), 60, 100);
        fire.func_180686_a((Block)OmniBlocks.RED_LOTUS_FLOWER.get(), 60, 100);
        fire.func_180686_a((Block)OmniBlocks.PINK_LOTUS_FLOWER.get(), 60, 100);
        fire.func_180686_a((Block)OmniBlocks.PURPLE_LOTUS_FLOWER.get(), 60, 100);
        fire.func_180686_a((Block)OmniBlocks.BLUE_LOTUS_FLOWER.get(), 60, 100);
        fire.func_180686_a((Block)OmniBlocks.BLACK_LOTUS_FLOWER.get(), 60, 100);
        fire.func_180686_a((Block)OmniBlocks.WHITE_LOTUS_FLOWER.get(), 60, 100);
        ComposterBlock.field_220299_b.put((Object)((Block)OmniBlocks.YELLOW_LOTUS_FLOWER.get()).func_199767_j(), 0.65f);
        ComposterBlock.field_220299_b.put((Object)((Block)OmniBlocks.ORANGE_LOTUS_FLOWER.get()).func_199767_j(), 0.65f);
        ComposterBlock.field_220299_b.put((Object)((Block)OmniBlocks.RED_LOTUS_FLOWER.get()).func_199767_j(), 0.65f);
        ComposterBlock.field_220299_b.put((Object)((Block)OmniBlocks.PINK_LOTUS_FLOWER.get()).func_199767_j(), 0.65f);
        ComposterBlock.field_220299_b.put((Object)((Block)OmniBlocks.PURPLE_LOTUS_FLOWER.get()).func_199767_j(), 0.65f);
        ComposterBlock.field_220299_b.put((Object)((Block)OmniBlocks.BLUE_LOTUS_FLOWER.get()).func_199767_j(), 0.65f);
        ComposterBlock.field_220299_b.put((Object)((Block)OmniBlocks.BLACK_LOTUS_FLOWER.get()).func_199767_j(), 0.65f);
        ComposterBlock.field_220299_b.put((Object)((Block)OmniBlocks.WHITE_LOTUS_FLOWER.get()).func_199767_j(), 0.65f);
    }

    @Override
    protected void registerBlocks() {
        OmniBlocks.RED_LOTUS_FLOWER = RegistryUtil.createBlock("red_lotus_flower", () -> new LotusFlowerBlock(Effects.field_76431_k, 9), ItemGroup.field_78031_c);
        OmniBlocks.YELLOW_LOTUS_FLOWER = RegistryUtil.createBlock("yellow_lotus_flower", () -> new LotusFlowerBlock(Effects.field_76431_k, 9), ItemGroup.field_78031_c);
        OmniBlocks.ORANGE_LOTUS_FLOWER = RegistryUtil.createBlock("orange_lotus_flower", () -> new LotusFlowerBlock(Effects.field_76431_k, 9), ItemGroup.field_78031_c);
        OmniBlocks.BLUE_LOTUS_FLOWER = RegistryUtil.createBlock("blue_lotus_flower", () -> new LotusFlowerBlock(Effects.field_76431_k, 9), ItemGroup.field_78031_c);
        OmniBlocks.PINK_LOTUS_FLOWER = RegistryUtil.createBlock("pink_lotus_flower", () -> new LotusFlowerBlock(Effects.field_76431_k, 9), ItemGroup.field_78031_c);
        OmniBlocks.PURPLE_LOTUS_FLOWER = RegistryUtil.createBlock("purple_lotus_flower", () -> new LotusFlowerBlock(Effects.field_76431_k, 9), ItemGroup.field_78031_c);
        OmniBlocks.BLACK_LOTUS_FLOWER = RegistryUtil.createBlock("black_lotus_flower", () -> new LotusFlowerBlock(Effects.field_76440_q, 8), ItemGroup.field_78031_c);
        OmniBlocks.WHITE_LOTUS_FLOWER = RegistryUtil.createBlock("white_lotus_flower", () -> new LotusFlowerBlock(Effects.field_76439_r, 8), ItemGroup.field_78031_c);
    }

    @Override
    protected void registerItems() {
        OmniItems.SEAHORSE_SPAWN_EGG = RegistryUtil.createItem("seahorse_spawn_egg", () -> new OmniSpawnEggItem(() -> (EntityType)OmniEntities.SEAHORSE.get(), 3966437, 14827318, new Item.Properties().func_200916_a(ItemGroup.field_78026_f)));
    }

    @Override
    protected void registerEntities() {
    }

    @Override
    protected void registerBiomes() {
        OmniBiomes.TROPICAL_PLAINS = RegistryUtil.createBiome("tropical_plains", BiomeMaker.func_244227_b(), BiomeManager.BiomeType.WARM, 2, BiomeDictionary.Type.PLAINS, BiomeDictionary.Type.HOT, BiomeDictionary.Type.WET, BiomeDictionary.Type.JUNGLE, BiomeDictionary.Type.OVERWORLD);
    }

    @Override
    protected void registerSurfaceBuilders() {
    }

    @Override
    protected void registerFeatures() {
    }

    @Override
    protected void registerSounds() {
    }

    public void onBiomeLoading(BiomeLoadingEvent event) {
        BiomeGenerationSettingsBuilder gen = event.getGeneration();
        MobSpawnInfoBuilder spawns = event.getSpawns();
        if (event.getCategory() == Biome.Category.OCEAN) {
            List list = spawns.getSpawner(EntityClassification.CREATURE);
        }
        if (event.getCategory() == Biome.Category.JUNGLE) {
            BiomeFeatures.addScatteredBlock(gen, ((Block)OmniBlocks.RED_LOTUS_FLOWER.get()).func_176223_P(), (Set<Block>)ImmutableSet.of((Object)Blocks.field_196658_i, (Object)Blocks.field_196661_l), 6, 8);
            BiomeFeatures.addScatteredBlock(gen, ((Block)OmniBlocks.ORANGE_LOTUS_FLOWER.get()).func_176223_P(), (Set<Block>)ImmutableSet.of((Object)Blocks.field_196658_i, (Object)Blocks.field_196661_l), 6, 8);
            BiomeFeatures.addScatteredBlock(gen, ((Block)OmniBlocks.YELLOW_LOTUS_FLOWER.get()).func_176223_P(), (Set<Block>)ImmutableSet.of((Object)Blocks.field_196658_i, (Object)Blocks.field_196661_l), 6, 8);
            BiomeFeatures.addScatteredBlock(gen, ((Block)OmniBlocks.BLUE_LOTUS_FLOWER.get()).func_176223_P(), (Set<Block>)ImmutableSet.of((Object)Blocks.field_196658_i, (Object)Blocks.field_196661_l), 6, 8);
            BiomeFeatures.addScatteredBlock(gen, ((Block)OmniBlocks.PINK_LOTUS_FLOWER.get()).func_176223_P(), (Set<Block>)ImmutableSet.of((Object)Blocks.field_196658_i, (Object)Blocks.field_196661_l), 6, 8);
            BiomeFeatures.addScatteredBlock(gen, ((Block)OmniBlocks.PURPLE_LOTUS_FLOWER.get()).func_176223_P(), (Set<Block>)ImmutableSet.of((Object)Blocks.field_196658_i, (Object)Blocks.field_196661_l), 6, 8);
            BiomeFeatures.addScatteredBlock(gen, ((Block)OmniBlocks.BLACK_LOTUS_FLOWER.get()).func_176223_P(), (Set<Block>)ImmutableSet.of((Object)Blocks.field_196658_i, (Object)Blocks.field_196661_l), 3, 12);
            BiomeFeatures.addScatteredBlock(gen, ((Block)OmniBlocks.WHITE_LOTUS_FLOWER.get()).func_176223_P(), (Set<Block>)ImmutableSet.of((Object)Blocks.field_196658_i, (Object)Blocks.field_196661_l), 3, 12);
        }
    }
}

