/*
 * Decompiled with CFR 0.152.
 */
package pugz.omni.core.util;

import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.blockplacer.BlockPlacer;
import net.minecraft.world.gen.blockplacer.SimpleBlockPlacer;
import net.minecraft.world.gen.blockstateprovider.BlockStateProvider;
import net.minecraft.world.gen.blockstateprovider.SimpleBlockStateProvider;
import net.minecraft.world.gen.feature.BlockClusterFeatureConfig;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.FeatureSpread;
import net.minecraft.world.gen.feature.Features;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.OreFeatureConfig;
import net.minecraft.world.gen.feature.template.RuleTest;
import net.minecraft.world.gen.placement.CaveEdgeConfig;
import net.minecraft.world.gen.placement.ConfiguredPlacement;
import net.minecraft.world.gen.placement.DecoratedPlacement;
import net.minecraft.world.gen.placement.IPlacementConfig;
import net.minecraft.world.gen.placement.Placement;
import net.minecraft.world.gen.placement.TopSolidRangeConfig;
import net.minecraftforge.common.world.BiomeGenerationSettingsBuilder;
import pugz.omni.common.world.feature.cavier_caves.GeodeFeatureConfig;
import pugz.omni.common.world.feature.cavier_caves.SpeleothemFeatureConfig;
import pugz.omni.core.registry.OmniFeatures;

public class BiomeFeatures {
    private static final GeodeFeatureConfig geodeFeatureConfig = new GeodeFeatureConfig(0.35, 0.083, true, 4, 7, 3, 5, 1, 3, -16, 16, 0.05);

    public static void addOreCluster(BiomeGenerationSettingsBuilder biome, RuleTest filler, BlockState state, int size, int bottom, int top, int maxHeight, int spread, int range) {
        biome.getFeatures(GenerationStage.Decoration.UNDERGROUND_ORES).add(() -> (ConfiguredFeature)((ConfiguredFeature)((ConfiguredFeature)Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(filler, state, size)).func_227228_a_(Placement.field_242907_l.func_227446_a_((IPlacementConfig)new TopSolidRangeConfig(bottom, top, maxHeight))).func_242733_d(range)).func_242728_a()).func_242731_b(spread));
    }

    public static void addScatteredBlock(BiomeGenerationSettingsBuilder biome, BlockState state, Set<Block> placers, int tries, int chance) {
        biome.getFeatures(GenerationStage.Decoration.VEGETAL_DECORATION).add(() -> (ConfiguredFeature)((ConfiguredFeature)((ConfiguredFeature)Feature.field_227248_z_.func_225566_b_((IFeatureConfig)new BlockClusterFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(state), (BlockPlacer)SimpleBlockPlacer.field_236447_c_).func_227315_a_(tries).func_227316_a_(placers).func_227317_b_().func_227322_d_()).func_242730_a(FeatureSpread.func_242253_a((int)-1, (int)4))).func_227228_a_(Features.Placements.field_244001_l).func_242731_b(5)).func_242729_a(chance));
    }

    public static void addSpeleothems(BiomeGenerationSettingsBuilder biome, SpeleothemFeatureConfig.Variant variant, float probability) {
        biome.getFeatures(GenerationStage.Decoration.UNDERGROUND_DECORATION).add(() -> ((Feature)OmniFeatures.SPELEOTHEM.get()).func_225566_b_((IFeatureConfig)new SpeleothemFeatureConfig(variant)).func_227228_a_(new ConfiguredPlacement(Placement.field_215039_y, (IPlacementConfig)new CaveEdgeConfig(GenerationStage.Carving.AIR, probability))));
        biome.getFeatures(GenerationStage.Decoration.UNDERGROUND_DECORATION).add(() -> ((Feature)OmniFeatures.SPELEOTHEM.get()).func_225566_b_((IFeatureConfig)new SpeleothemFeatureConfig(variant)).func_227228_a_(new ConfiguredPlacement(Placement.field_215039_y, (IPlacementConfig)new CaveEdgeConfig(GenerationStage.Carving.LIQUID, probability))));
    }

    public static void addMalachiteGeodes(BiomeGenerationSettingsBuilder biome) {
        biome.getFeatures(GenerationStage.Decoration.UNDERGROUND_DECORATION).add(() -> ((Feature)OmniFeatures.GEODE.get()).func_225566_b_((IFeatureConfig)geodeFeatureConfig).func_227228_a_((ConfiguredPlacement)DecoratedPlacement.field_242907_l.func_227446_a_((IPlacementConfig)new TopSolidRangeConfig(6, 0, 47)).func_242729_a(48)));
    }
}

