/*
 * Decompiled with CFR 0.152.
 */
package pugz.omni.core.util;

import com.google.common.collect.Sets;
import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.feature.Feature;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.BiomeManager;
import net.minecraftforge.fml.RegistryObject;
import pugz.omni.core.Omni;

public class RegistryUtil {
    public static <B extends Block> RegistryObject<B> createBlock(String name, Supplier<? extends B> supplier, @Nullable ItemGroup group) {
        RegistryObject block = Omni.Registries.BLOCKS.register(name, supplier);
        if (group != null) {
            Omni.Registries.ITEMS.register(name, () -> new BlockItem((Block)block.get(), new Item.Properties().func_200916_a(group)));
        }
        return block;
    }

    public static <B extends Block> RegistryObject<B> createOverrideBlock(String name, Supplier<? extends B> supplier, @Nullable ItemGroup group) {
        RegistryObject block = Omni.OverrideRegistries.BLOCKS.register(name, supplier);
        if (group != null) {
            Omni.OverrideRegistries.ITEMS.register(name, () -> new BlockItem((Block)block.get(), new Item.Properties().func_200916_a(group)));
        }
        return block;
    }

    public static <I extends Item> RegistryObject<I> createItem(String name, Supplier<? extends I> supplier) {
        return Omni.Registries.ITEMS.register(name, supplier);
    }

    public static <I extends Item> RegistryObject<I> createOverrideItem(String name, Supplier<? extends I> supplier, @Nullable ItemGroup group) {
        RegistryObject item = Omni.OverrideRegistries.ITEMS.register(name, supplier);
        return item;
    }

    public static <T extends TileEntity> RegistryObject<TileEntityType<T>> createTileEntity(String name, Supplier<? extends T> supplier, Supplier<Block[]> blocks) {
        return Omni.Registries.TILE_ENTITIES.register(name, () -> new TileEntityType(supplier, (Set)Sets.newHashSet((Object[])((Object[])blocks.get())), null));
    }

    public static <E extends Entity> RegistryObject<EntityType<E>> createEntity(String name, Supplier<EntityType<E>> supplier) {
        return Omni.Registries.ENTITIES.register(name, supplier);
    }

    public static RegistryKey<Biome> createBiome(String name, Biome biome, BiomeManager.BiomeType type, int weight, BiomeDictionary.Type ... types) {
        RegistryKey key = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239720_u_, (ResourceLocation)new ResourceLocation("omni", name));
        BiomeManager.addBiome((BiomeManager.BiomeType)type, (BiomeManager.BiomeEntry)new BiomeManager.BiomeEntry(key, weight));
        BiomeDictionary.addTypes((RegistryKey)key, (BiomeDictionary.Type[])types);
        Omni.Registries.BIOMES.register(name, () -> biome);
        return key;
    }

    public static <F extends Feature<?>> RegistryObject<F> createFeature(String name, Supplier<? extends F> supplier) {
        return Omni.Registries.FEATURES.register(name, supplier);
    }

    public static RegistryObject<SoundEvent> createSoundEvent(String name) {
        return Omni.Registries.SOUNDS.register(name, () -> new SoundEvent(new ResourceLocation("omni", name)));
    }
}

