/*
 * Decompiled with CFR 0.152.
 */
package com.jarkon.petrevive.blocks;

import com.jarkon.petrevive.lists.BlockList;
import com.jarkon.petrevive.lists.EntityList;
import com.jarkon.petrevive.lists.ItemList;
import com.jarkon.petrevive.tileentity.CollarTileEntity;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.passive.WolfEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.DyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameters;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CollarBlock
extends Block {
    private static final Logger logger = LogManager.getLogger((String)"petrevive");
    protected static final VoxelShape SHAPE = Block.func_208617_a((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)3.0, (double)12.0);

    public CollarBlock(AbstractBlock.Properties properties) {
        super(properties);
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return SHAPE;
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return EntityList.collar_entity.func_200968_a();
    }

    public void func_176208_a(World worldIn, BlockPos pos, BlockState state, PlayerEntity player) {
        TileEntity tileentity = worldIn.func_175625_s(pos);
        if (tileentity instanceof CollarTileEntity) {
            CollarTileEntity collartileentity = (CollarTileEntity)tileentity;
            if (!worldIn.field_72995_K && player.func_184812_l_()) {
                ItemStack itemstack = new ItemStack((IItemProvider)BlockList.collar_block);
                CompoundNBT compoundnbt = collartileentity.saveToNbt(new CompoundNBT());
                itemstack.func_77982_d(compoundnbt);
                ItemEntity itementity = new ItemEntity(worldIn, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), itemstack);
                itementity.func_174869_p();
                itementity.func_184224_h(true);
                worldIn.func_217376_c((Entity)itementity);
            }
        }
        super.func_176208_a(worldIn, pos, state, player);
    }

    public void func_180633_a(World worldIn, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        CompoundNBT stackcompoundnbt = stack.func_77978_p();
        this.justReadTheDamnNBT(worldIn, pos, stackcompoundnbt);
    }

    public void justReadTheDamnNBT(World worldIn, BlockPos pos, CompoundNBT nbtIn) {
        CollarTileEntity tileentity = (CollarTileEntity)worldIn.func_175625_s(pos);
        CompoundNBT tilecompoundnbt = new CompoundNBT();
        if (nbtIn != null) {
            logger.info((Object)nbtIn);
            if (nbtIn.func_74781_a("DogName") != null) {
                String dogname = nbtIn.func_74779_i("DogName");
                tilecompoundnbt.func_74778_a("DogName", dogname);
            } else {
                tilecompoundnbt.func_74778_a("DogName", "Wolf");
            }
            String collarColor = nbtIn.func_74779_i("CollarColor");
            tilecompoundnbt.func_74778_a("CollarColor", collarColor);
            tileentity.loadFromNbt(tilecompoundnbt);
            logger.info("NBT data read: " + tilecompoundnbt);
        }
    }

    public List<ItemStack> func_220076_a(BlockState state, LootContext.Builder builder) {
        TileEntity tileentity = (TileEntity)builder.func_216019_b(LootParameters.field_216288_h);
        if (tileentity instanceof CollarTileEntity) {
            CollarTileEntity collartileentity = (CollarTileEntity)tileentity;
            if (!tileentity.func_145831_w().field_72995_K) {
                ItemStack itemstack = new ItemStack((IItemProvider)BlockList.collar_block);
                CompoundNBT compoundnbt = collartileentity.saveToNbt(new CompoundNBT());
                itemstack.func_77982_d(compoundnbt);
                BlockPos pos = tileentity.func_174877_v();
                ItemEntity itementity = new ItemEntity(tileentity.func_145831_w(), (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), itemstack);
                itementity.func_174869_p();
                tileentity.func_145831_w().func_217376_c((Entity)itementity);
            }
        }
        return super.func_220076_a(state, builder);
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        ItemStack itemstack = player.func_184586_b(handIn);
        Item item = itemstack.func_77973_b();
        if (item == ItemList.golden_bone || item == ItemList.golden_bone_enchanted) {
            if (!player.field_71075_bZ.field_75098_d) {
                itemstack.func_190918_g(1);
            }
            TileEntity tileentity = worldIn.func_175625_s(pos);
            CompoundNBT tilecompoundnbt = tileentity.func_189515_b(new CompoundNBT());
            worldIn.func_175655_b(pos, false);
            String name = tilecompoundnbt.func_74781_a("DogName") != null ? tilecompoundnbt.func_74779_i("DogName") : "Wolf";
            String color = tilecompoundnbt.func_74781_a("CollarColor") != null ? tilecompoundnbt.func_74779_i("CollarColor") : "red";
            logger.info(name + "'s " + color + " collar was clicked");
            WolfEntity newWolf = new WolfEntity(EntityType.field_200724_aC, worldIn);
            if (name == null || name.equals("Wolf")) {
                newWolf.func_200203_b(null);
            } else {
                newWolf.func_200203_b((ITextComponent)new StringTextComponent(name));
            }
            switch (color.toUpperCase()) {
                case "YELLOW": {
                    newWolf.func_175547_a(DyeColor.YELLOW);
                    break;
                }
                case "GREEN": {
                    newWolf.func_175547_a(DyeColor.GREEN);
                    break;
                }
                case "BLACK": {
                    newWolf.func_175547_a(DyeColor.BLACK);
                    break;
                }
                case "BROWN": {
                    newWolf.func_175547_a(DyeColor.BROWN);
                    break;
                }
                case "BLUE": {
                    newWolf.func_175547_a(DyeColor.BLUE);
                    break;
                }
                case "WHITE": {
                    newWolf.func_175547_a(DyeColor.WHITE);
                    break;
                }
                case "ORANGE": {
                    newWolf.func_175547_a(DyeColor.ORANGE);
                    break;
                }
                case "LIGHT_BLUE": {
                    newWolf.func_175547_a(DyeColor.LIGHT_BLUE);
                    break;
                }
                case "MAGENTA": {
                    newWolf.func_175547_a(DyeColor.MAGENTA);
                    break;
                }
                case "PINK": {
                    newWolf.func_175547_a(DyeColor.PINK);
                    break;
                }
                case "LIGHT_GRAY": {
                    newWolf.func_175547_a(DyeColor.LIGHT_GRAY);
                    break;
                }
                case "LIME": {
                    newWolf.func_175547_a(DyeColor.LIME);
                    break;
                }
                case "CYAN": {
                    newWolf.func_175547_a(DyeColor.CYAN);
                    break;
                }
                case "PURPLE": {
                    newWolf.func_175547_a(DyeColor.PURPLE);
                    break;
                }
                case "GRAY": {
                    newWolf.func_175547_a(DyeColor.GRAY);
                    break;
                }
                default: {
                    newWolf.func_175547_a(DyeColor.RED);
                }
            }
            newWolf.func_70012_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5, 0.0f, 0.0f);
            newWolf.func_193101_c(player);
            newWolf.func_70624_b((LivingEntity)null);
            if (item == ItemList.golden_bone_enchanted) {
                newWolf.func_70606_j(newWolf.func_110138_aP());
                newWolf.func_195064_c(new EffectInstance(Effects.field_76420_g, 400, 2));
                newWolf.func_195064_c(new EffectInstance(Effects.field_76426_n, 1200, 1));
                newWolf.func_195064_c(new EffectInstance(Effects.field_76424_c, 400, 2));
                newWolf.func_195064_c(new EffectInstance(Effects.field_76428_l, 700, 2));
                newWolf.func_195064_c(new EffectInstance(Effects.field_76444_x, 600, 1));
                worldIn.func_195594_a((IParticleData)ParticleTypes.field_197627_t, newWolf.func_226277_ct_(), newWolf.func_226278_cu_(), newWolf.func_226281_cx_(), 0.0, 0.0, 0.0);
                worldIn.func_184134_a(newWolf.func_226277_ct_(), newWolf.func_226278_cu_(), newWolf.func_226281_cx_(), SoundEvents.field_191263_gW, newWolf.func_184176_by(), 1.0f, 1.0f, false);
            } else {
                newWolf.func_70606_j(newWolf.func_110138_aP() * 0.2f);
            }
            worldIn.func_217376_c((Entity)newWolf);
        }
        return ActionResultType.SUCCESS;
    }
}

