/*
 * Decompiled with CFR 0.152.
 */
package com.jarkon.petrevive.blocks;

import com.jarkon.petrevive.lists.BlockList;
import com.jarkon.petrevive.lists.ItemList;
import com.jarkon.petrevive.tileentity.FeatherTileEntity;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.passive.ParrotEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameters;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FeatherBlock
extends Block {
    private static final Logger logger = LogManager.getLogger((String)"petrevive");
    protected static final VoxelShape SHAPE = Block.func_208617_a((double)4.0, (double)0.0, (double)2.0, (double)16.0, (double)3.0, (double)14.0);

    public FeatherBlock(AbstractBlock.Properties properties) {
        super(properties);
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return SHAPE;
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new FeatherTileEntity();
    }

    public void func_176208_a(World worldIn, BlockPos pos, BlockState state, PlayerEntity player) {
        TileEntity tileentity = worldIn.func_175625_s(pos);
        if (tileentity instanceof FeatherTileEntity) {
            FeatherTileEntity feathertileentity = (FeatherTileEntity)tileentity;
            if (!worldIn.field_72995_K && player.func_184812_l_()) {
                ItemStack itemstack = new ItemStack((IItemProvider)BlockList.feather_block);
                CompoundNBT compoundnbt = feathertileentity.saveToNbt(new CompoundNBT());
                itemstack.func_77982_d(compoundnbt);
                ItemEntity itementity = new ItemEntity(worldIn, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), itemstack);
                itementity.func_174869_p();
                itementity.func_184224_h(true);
                worldIn.func_217376_c((Entity)itementity);
            }
        }
        super.func_176208_a(worldIn, pos, state, player);
    }

    public void func_180633_a(World worldIn, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        this.createTileEntity(state, (IBlockReader)worldIn);
        CompoundNBT stackcompoundnbt = stack.func_77978_p();
        this.justReadTheDamnNBT(worldIn, pos, stackcompoundnbt);
    }

    public void justReadTheDamnNBT(World worldIn, BlockPos pos, CompoundNBT nbtIn) {
        CompoundNBT tilecompoundnbt = new CompoundNBT();
        if (nbtIn != null) {
            logger.info((Object)nbtIn);
            if (nbtIn.func_74781_a("ParrotName") != null) {
                String parrotname = nbtIn.func_74779_i("ParrotName");
                tilecompoundnbt.func_74778_a("ParrotName", parrotname);
            } else {
                tilecompoundnbt.func_74778_a("ParrotName", "Parrot");
            }
            String featherColor = nbtIn.func_74779_i("FeatherColor");
            tilecompoundnbt.func_74778_a("FeatherColor", featherColor);
            TileEntity tileentity = worldIn.func_175625_s(pos);
            if (tileentity != null) {
                if (tileentity instanceof FeatherTileEntity) {
                    ((FeatherTileEntity)tileentity).loadFromNbt(tilecompoundnbt);
                } else {
                    logger.info("Not the right entity: " + tileentity.getClass());
                }
            } else {
                logger.info("Could not find tile entity!");
            }
            logger.info("NBT data read: " + tilecompoundnbt);
        }
    }

    public List<ItemStack> func_220076_a(BlockState state, LootContext.Builder builder) {
        TileEntity tileentity = (TileEntity)builder.func_216019_b(LootParameters.field_216288_h);
        if (tileentity instanceof FeatherTileEntity) {
            FeatherTileEntity feathertileentity = (FeatherTileEntity)tileentity;
            if (!tileentity.func_145831_w().field_72995_K) {
                ItemStack itemstack = new ItemStack((IItemProvider)BlockList.feather_block);
                CompoundNBT compoundnbt = feathertileentity.saveToNbt(new CompoundNBT());
                itemstack.func_77982_d(compoundnbt);
                BlockPos pos = tileentity.func_174877_v();
                ItemEntity itementity = new ItemEntity(tileentity.func_145831_w(), (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), itemstack);
                itementity.func_174869_p();
                tileentity.func_145831_w().func_217376_c((Entity)itementity);
            }
        }
        return super.func_220076_a(state, builder);
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        ItemStack itemstack = player.func_184586_b(handIn);
        Item item = itemstack.func_77973_b();
        if (item == ItemList.golden_seeds || item == ItemList.golden_seeds_enchanted) {
            if (!player.field_71075_bZ.field_75098_d) {
                itemstack.func_190918_g(1);
            }
            TileEntity tileentity = worldIn.func_175625_s(pos);
            CompoundNBT tilecompoundnbt = tileentity.func_189515_b(new CompoundNBT());
            worldIn.func_175655_b(pos, false);
            String name = tilecompoundnbt.func_74781_a("ParrotName") != null ? tilecompoundnbt.func_74779_i("ParrotName") : "Parrot";
            int variant = tilecompoundnbt.func_74781_a("FeatherColor") != null ? Integer.parseInt(tilecompoundnbt.func_74779_i("FeatherColor")) : 0;
            logger.info(name + "'s " + variant + " feather was clicked");
            ParrotEntity newParrot = new ParrotEntity(EntityType.field_200783_W, worldIn);
            if (name == null || name.equals("Parrot")) {
                newParrot.func_200203_b(null);
            } else {
                newParrot.func_200203_b((ITextComponent)new StringTextComponent(name));
            }
            newParrot.func_191997_m(variant);
            newParrot.func_70012_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5, 0.0f, 0.0f);
            newParrot.func_193101_c(player);
            if (item == ItemList.golden_seeds_enchanted) {
                newParrot.func_70606_j(newParrot.func_110138_aP());
                newParrot.func_195064_c(new EffectInstance(Effects.field_76420_g, 400, 2));
                newParrot.func_195064_c(new EffectInstance(Effects.field_76426_n, 1200, 1));
                newParrot.func_195064_c(new EffectInstance(Effects.field_76424_c, 400, 2));
                newParrot.func_195064_c(new EffectInstance(Effects.field_76428_l, 700, 2));
                worldIn.func_195594_a((IParticleData)ParticleTypes.field_197627_t, newParrot.func_226277_ct_(), newParrot.func_226278_cu_(), newParrot.func_226281_cx_(), 0.0, 0.0, 0.0);
                worldIn.func_184134_a(newParrot.func_226277_ct_(), newParrot.func_226278_cu_(), newParrot.func_226281_cx_(), SoundEvents.field_191263_gW, newParrot.func_184176_by(), 1.0f, 1.0f, false);
            } else {
                newParrot.func_70606_j(newParrot.func_110138_aP() * 0.2f);
            }
            worldIn.func_217376_c((Entity)newParrot);
        }
        return ActionResultType.SUCCESS;
    }
}

