/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.plane;

import de.maxhenkel.plane.ClientConfig;
import de.maxhenkel.plane.ServerConfig;
import de.maxhenkel.plane.corelib.ClientRegistry;
import de.maxhenkel.plane.corelib.CommonRegistry;
import de.maxhenkel.plane.entity.EntityBushPlane;
import de.maxhenkel.plane.entity.EntityCargoPlane;
import de.maxhenkel.plane.entity.EntityPlane;
import de.maxhenkel.plane.entity.EntityPlaneSoundBase;
import de.maxhenkel.plane.entity.render.BushPlaneModel;
import de.maxhenkel.plane.entity.render.CargoPlaneModel;
import de.maxhenkel.plane.entity.render.PlaneModel;
import de.maxhenkel.plane.events.CapabilityEvents;
import de.maxhenkel.plane.events.InteractEvents;
import de.maxhenkel.plane.events.KeyEvents;
import de.maxhenkel.plane.events.RenderEvents;
import de.maxhenkel.plane.gui.ContainerPlane;
import de.maxhenkel.plane.gui.PlaneScreen;
import de.maxhenkel.plane.integration.waila.PluginPlane;
import de.maxhenkel.plane.item.ModItems;
import de.maxhenkel.plane.loottable.CopyPlaneData;
import de.maxhenkel.plane.net.MessageControlPlane;
import de.maxhenkel.plane.net.MessagePlaneGui;
import de.maxhenkel.plane.sound.ModSounds;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.gui.ScreenManager;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.Item;
import net.minecraft.loot.ILootSerializer;
import net.minecraft.loot.LootFunctionType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.network.IContainerFactory;
import net.minecraftforge.fml.network.simple.SimpleChannel;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod(value="plane")
public class Main {
    public static final String MODID = "plane";
    public static SimpleChannel SIMPLE_CHANNEL;
    public static EntityType<EntityPlane> PLANE_ENTITY_TYPE;
    public static EntityType<EntityCargoPlane> CARGO_PLANE_ENTITY_TYPE;
    public static EntityType<EntityBushPlane> BUSH_PLANE_ENTITY_TYPE;
    public static LootFunctionType COPY_PLANE_DATA;
    public static ServerConfig SERVER_CONFIG;
    public static ClientConfig CLIENT_CONFIG;
    public static KeyBinding PLANE_KEY;
    public static KeyBinding FORWARD_KEY;
    public static KeyBinding BACK_KEY;
    public static KeyBinding LEFT_KEY;
    public static KeyBinding RIGHT_KEY;
    public static KeyBinding UP_KEY;
    public static KeyBinding DOWN_KEY;
    public static KeyBinding START_KEY;
    public static KeyBinding BRAKE_KEY;
    public static ContainerType<ContainerPlane> PLANE_CONTAINER_TYPE;

    public Main() {
        FMLJavaModLoadingContext.get().getModEventBus().addGenericListener(Item.class, this::registerItems);
        FMLJavaModLoadingContext.get().getModEventBus().addGenericListener(SoundEvent.class, this::registerSounds);
        FMLJavaModLoadingContext.get().getModEventBus().addGenericListener(EntityType.class, this::registerEntities);
        FMLJavaModLoadingContext.get().getModEventBus().addGenericListener(ContainerType.class, this::registerContainers);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::commonSetup);
        SERVER_CONFIG = CommonRegistry.registerConfig(ModConfig.Type.SERVER, ServerConfig.class, true);
        CLIENT_CONFIG = CommonRegistry.registerConfig(ModConfig.Type.CLIENT, ClientConfig.class);
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> this.clientStart());
    }

    @OnlyIn(value=Dist.CLIENT)
    public void clientStart() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::clientSetup);
    }

    @SubscribeEvent
    public void commonSetup(FMLCommonSetupEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)new InteractEvents());
        MinecraftForge.EVENT_BUS.register((Object)new CapabilityEvents());
        COPY_PLANE_DATA = (LootFunctionType)Registry.func_218322_a((Registry)Registry.field_239694_aZ_, (ResourceLocation)new ResourceLocation(MODID, "copy_plane_data"), (Object)new LootFunctionType((ILootSerializer)new CopyPlaneData.Serializer()));
        SIMPLE_CHANNEL = CommonRegistry.registerChannel(MODID, "default");
        CommonRegistry.registerMessage(SIMPLE_CHANNEL, 0, MessageControlPlane.class);
        CommonRegistry.registerMessage(SIMPLE_CHANNEL, 1, MessagePlaneGui.class);
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void clientSetup(FMLClientSetupEvent event) {
        ScreenManager.IScreenFactory factory = (container, playerInventory, name) -> new PlaneScreen((ContainerPlane)container, playerInventory, name);
        ScreenManager.func_216911_a(PLANE_CONTAINER_TYPE, (ScreenManager.IScreenFactory)factory);
        PLANE_KEY = ClientRegistry.registerKeyBinding("key.plane", "category.plane", 80);
        FORWARD_KEY = ClientRegistry.registerKeyBinding("key.plane_add_thrust", "category.plane", 73);
        BACK_KEY = ClientRegistry.registerKeyBinding("key.plane_remove_thrust", "category.plane", 75);
        LEFT_KEY = ClientRegistry.registerKeyBinding("key.plane_left", "category.plane", 65);
        RIGHT_KEY = ClientRegistry.registerKeyBinding("key.plane_right", "category.plane", 68);
        UP_KEY = ClientRegistry.registerKeyBinding("key.plane_up", "category.plane", 83);
        DOWN_KEY = ClientRegistry.registerKeyBinding("key.plane_down", "category.plane", 87);
        START_KEY = ClientRegistry.registerKeyBinding("key.plane_start", "category.plane", 82);
        BRAKE_KEY = ClientRegistry.registerKeyBinding("key.plane_brake", "category.plane", 66);
        MinecraftForge.EVENT_BUS.register((Object)new KeyEvents());
        MinecraftForge.EVENT_BUS.register((Object)new RenderEvents());
        try {
            Class.forName("mcp.mobius.waila.api.event.WailaRenderEvent");
            MinecraftForge.EVENT_BUS.register((Object)new PluginPlane());
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        RenderingRegistry.registerEntityRenderingHandler(PLANE_ENTITY_TYPE, manager -> new PlaneModel(manager));
        RenderingRegistry.registerEntityRenderingHandler(CARGO_PLANE_ENTITY_TYPE, manager -> new CargoPlaneModel(manager));
        RenderingRegistry.registerEntityRenderingHandler(BUSH_PLANE_ENTITY_TYPE, manager -> new BushPlaneModel(manager));
    }

    @SubscribeEvent
    public void registerItems(RegistryEvent.Register<Item> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])ModItems.PLANES);
        event.getRegistry().registerAll((IForgeRegistryEntry[])ModItems.CARGO_PLANES);
        event.getRegistry().registerAll((IForgeRegistryEntry[])ModItems.BUSH_PLANES);
        event.getRegistry().registerAll((IForgeRegistryEntry[])new Item[]{ModItems.WRENCH, ModItems.PLANE_WHEEL, ModItems.PLANE_ENGINE});
    }

    @SubscribeEvent
    public void registerSounds(RegistryEvent.Register<SoundEvent> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])ModSounds.getAll().toArray(new SoundEvent[0]));
    }

    @SubscribeEvent
    public void registerEntities(RegistryEvent.Register<EntityType<?>> event) {
        PLANE_ENTITY_TYPE = CommonRegistry.registerEntity(MODID, MODID, EntityClassification.MISC, EntityPlane.class, builder -> builder.setTrackingRange(256).setUpdateInterval(1).setShouldReceiveVelocityUpdates(true).func_220321_a(3.5f, 2.0f).setCustomClientFactory((spawnEntity, world) -> new EntityPlane((World)world)));
        event.getRegistry().register(PLANE_ENTITY_TYPE);
        CARGO_PLANE_ENTITY_TYPE = CommonRegistry.registerEntity(MODID, "cargo_plane", EntityClassification.MISC, EntityCargoPlane.class, builder -> builder.setTrackingRange(256).setUpdateInterval(1).setShouldReceiveVelocityUpdates(true).func_220321_a(3.5f, 2.0f).setCustomClientFactory((spawnEntity, world) -> new EntityCargoPlane((World)world)));
        event.getRegistry().register(CARGO_PLANE_ENTITY_TYPE);
        BUSH_PLANE_ENTITY_TYPE = CommonRegistry.registerEntity(MODID, "bush_plane", EntityClassification.MISC, EntityBushPlane.class, builder -> builder.setTrackingRange(256).setUpdateInterval(1).setShouldReceiveVelocityUpdates(true).func_220321_a(3.5f, 2.0f).setCustomClientFactory((spawnEntity, world) -> new EntityBushPlane((World)world)));
        event.getRegistry().register(BUSH_PLANE_ENTITY_TYPE);
    }

    @SubscribeEvent
    public void registerContainers(RegistryEvent.Register<ContainerType<?>> event) {
        PLANE_CONTAINER_TYPE = new ContainerType((ContainerType.IFactory)((IContainerFactory)(windowId, inv, data) -> {
            EntityPlaneSoundBase plane = Main.getPlaneByUUID(inv.field_70458_d, data.func_179253_g());
            if (plane == null) {
                return null;
            }
            return new ContainerPlane(windowId, plane, inv);
        }));
        PLANE_CONTAINER_TYPE.setRegistryName(new ResourceLocation(MODID, MODID));
        event.getRegistry().register(PLANE_CONTAINER_TYPE);
    }

    @Nullable
    public static EntityPlaneSoundBase getPlaneByUUID(PlayerEntity player, UUID uuid) {
        double distance = 10.0;
        return player.field_70170_p.func_175647_a(EntityPlaneSoundBase.class, new AxisAlignedBB(player.func_226277_ct_() - distance, player.func_226278_cu_() - distance, player.func_226281_cx_() - distance, player.func_226277_ct_() + distance, player.func_226278_cu_() + distance, player.func_226281_cx_() + distance), entity -> entity.func_110124_au().equals(uuid)).stream().findAny().orElse(null);
    }
}

