/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.plane.corelib.tag;

import de.maxhenkel.plane.corelib.tag.SingleElementTag;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;

public class TagUtils {
    public static ITag<Block> AIR_BLOCK_TAG = new SingleElementTag<Block>(Blocks.field_150350_a);
    public static ITag<Item> AIR_ITEM_TAG = new SingleElementTag<Item>(Items.field_190931_a);
    public static ITag<Fluid> AIR_FLUID_TAG = new SingleElementTag<Fluid>(Fluids.field_204541_a);

    @Nullable
    public static ITag<Block> getBlock(String name, boolean nullIfNotExists) {
        if (name.startsWith("#")) {
            return BlockTags.func_199896_a().func_199910_a(new ResourceLocation(name.substring(1)));
        }
        ResourceLocation resourceLocation = new ResourceLocation(name);
        if (!ForgeRegistries.BLOCKS.containsKey(resourceLocation)) {
            if (nullIfNotExists) {
                return null;
            }
            return AIR_BLOCK_TAG;
        }
        Block block = (Block)ForgeRegistries.BLOCKS.getValue(resourceLocation);
        if (block == null) {
            if (nullIfNotExists) {
                return null;
            }
            return AIR_BLOCK_TAG;
        }
        return new SingleElementTag<Block>(block);
    }

    public static ITag<Block> getBlock(String name) {
        return TagUtils.getBlock(name, false);
    }

    @Nullable
    public static ITag<Item> getItem(String name, boolean nullIfNotExists) {
        if (name.startsWith("#")) {
            return ItemTags.func_199903_a().func_199910_a(new ResourceLocation(name.substring(1)));
        }
        ResourceLocation resourceLocation = new ResourceLocation(name);
        if (!ForgeRegistries.ITEMS.containsKey(resourceLocation)) {
            if (nullIfNotExists) {
                return null;
            }
            return AIR_ITEM_TAG;
        }
        Item item = (Item)ForgeRegistries.ITEMS.getValue(resourceLocation);
        if (item == null) {
            if (nullIfNotExists) {
                return null;
            }
            return AIR_ITEM_TAG;
        }
        return new SingleElementTag<Item>(item);
    }

    public static ITag<Item> getItem(String name) {
        return TagUtils.getItem(name, false);
    }

    @Nullable
    public static ITag<Fluid> getFluid(String name, boolean nullIfNotExists) {
        if (name.startsWith("#")) {
            return FluidTags.func_226157_a_().func_199910_a(new ResourceLocation(name.substring(1)));
        }
        ResourceLocation resourceLocation = new ResourceLocation(name);
        if (!ForgeRegistries.FLUIDS.containsKey(resourceLocation)) {
            if (nullIfNotExists) {
                return null;
            }
            return AIR_FLUID_TAG;
        }
        Fluid fluid = (Fluid)ForgeRegistries.FLUIDS.getValue(new ResourceLocation(name));
        if (fluid == null) {
            if (nullIfNotExists) {
                return null;
            }
            return AIR_FLUID_TAG;
        }
        return new SingleElementTag<Fluid>(fluid);
    }

    public static ITag<Fluid> getFluid(String name) {
        return TagUtils.getFluid(name, false);
    }
}

