/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.plane.item;

import de.maxhenkel.plane.corelib.math.MathUtils;
import de.maxhenkel.plane.entity.EntityPlaneFuelBase;
import de.maxhenkel.plane.entity.EntityPlaneSoundBase;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public abstract class ItemAbstractPlane<T extends EntityPlaneSoundBase>
extends Item {
    public ItemAbstractPlane() {
        super(new Item.Properties().func_200917_a(1).func_200916_a(ItemGroup.field_78029_e));
    }

    public abstract T createPlane(World var1);

    public ActionResultType func_195939_a(ItemUseContext context) {
        BlockPos pos;
        if (!context.func_196000_l().equals((Object)Direction.UP)) {
            return ActionResultType.FAIL;
        }
        World world = context.func_195991_k();
        if (!world.func_180495_p((pos = context.func_195995_a()).func_177984_a()).func_196952_d((IBlockReader)world, pos).func_197766_b()) {
            return ActionResultType.FAIL;
        }
        PlayerEntity player = context.func_195999_j();
        T plane = this.createPlane(world);
        ((EntityPlaneFuelBase)((Object)plane)).setFuel(100);
        BlockState state = world.func_180495_p(pos);
        VoxelShape collisionShape = state.func_196952_d((IBlockReader)world, pos);
        plane.func_70080_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + (collisionShape.func_197766_b() ? 0.0 : state.func_196952_d((IBlockReader)world, (BlockPos)pos).func_197752_a().field_72337_e) + 0.01, (double)pos.func_177952_p() + 0.5, context.func_195999_j().field_70177_z, 0.0f);
        this.addData(context.func_195996_i(), (EntityPlaneSoundBase)((Object)plane));
        world.func_217376_c(plane);
        if (!player.field_71075_bZ.field_75098_d) {
            context.func_195996_i().func_190920_e(context.func_195996_i().func_190916_E() - 1);
        }
        return ActionResultType.SUCCESS;
    }

    private void addData(ItemStack stack, EntityPlaneSoundBase plane) {
        CompoundNBT planeData = this.getPlaneData(stack);
        if (planeData != null) {
            plane.func_70037_a(planeData);
            plane.setStarted(false, false);
        }
        if (!stack.func_77973_b().func_200295_i(stack).equals(stack.func_200301_q())) {
            plane.func_200203_b(stack.func_200301_q());
        }
    }

    private CompoundNBT getPlaneData(ItemStack stack) {
        CompoundNBT tag = stack.func_77978_p();
        if (tag == null) {
            return null;
        }
        if (!tag.func_74764_b("PlaneData")) {
            return null;
        }
        return tag.func_74775_l("PlaneData");
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        CompoundNBT planeData = this.getPlaneData(stack);
        if (planeData != null) {
            tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.plane.damage", new Object[]{new StringTextComponent(String.valueOf(MathUtils.round(planeData.func_74760_g("Damage"), 2))).func_240699_a_(TextFormatting.DARK_GRAY)}).func_240699_a_(TextFormatting.GRAY));
            tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.plane.fuel", new Object[]{new StringTextComponent(String.valueOf(planeData.func_74762_e("Fuel"))).func_240699_a_(TextFormatting.DARK_GRAY)}).func_240699_a_(TextFormatting.GRAY));
        }
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
    }
}

