/*
 * Decompiled with CFR 0.152.
 */
package com.abneyonline.platter.tile;

import com.abneyonline.platter.Config;
import com.abneyonline.platter.Registration;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class PlatterTile
extends BlockEntity {
    private LazyOptional<IItemHandler> handler = LazyOptional.of(this::createHandler);
    private long tickCount = 0L;
    protected boolean tickForAnimals = true;

    public PlatterTile(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)Registration.oak_platter_tile.get(), blockPos, blockState);
    }

    public PlatterTile(BlockEntityType tet, BlockPos blockPos, BlockState blockState) {
        super(tet, blockPos, blockState);
    }

    public void tickServer() {
        if (!this.f_58857_.m_5776_() && !this.f_58857_.m_46753_(this.m_58899_())) {
            ++this.tickCount;
            if (this.tickCount >= (long)((Integer)Config.PLATTER_PERIOD.get() * 20)) {
                this.tickCount = 0L;
                int radii = (Integer)Config.PLATTER_RADIUS.get();
                List pl = this.f_58857_.m_45976_(LivingEntity.class, new AABB(this.m_58899_().m_142082_(-radii, -radii, -radii), this.m_58899_().m_142082_(radii, radii, radii)));
                ArrayList<Player> lpe = new ArrayList<Player>();
                ArrayList<Animal> lae = new ArrayList<Animal>();
                for (LivingEntity p : pl) {
                    Animal ae;
                    if (p instanceof Player) {
                        Player pe = (Player)p;
                        if (!pe.m_36391_(false) || pe.m_7500_()) continue;
                        lpe.add(pe);
                        continue;
                    }
                    if (!(p instanceof Animal) || !this.tickForAnimals || !(ae = (Animal)p).m_5957_() || ae.m_6162_()) continue;
                    lae.add(ae);
                }
                this.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(h -> {
                    for (int a = h.getSlots() - 1; a >= 0; --a) {
                        ItemStack toEat;
                        ItemStack retrievedItem = h.getStackInSlot(a);
                        if (retrievedItem.m_41614_() && !lpe.isEmpty()) {
                            Iterator ipe = lpe.iterator();
                            while (ipe.hasNext() && retrievedItem != ItemStack.f_41583_) {
                                Player toFeed = (Player)ipe.next();
                                toEat = h.extractItem(a, 1, false);
                                toFeed.m_5584_(this.f_58857_, toEat);
                                ipe.remove();
                            }
                        }
                        if (!lae.isEmpty()) {
                            Iterator iae = lae.iterator();
                            while (iae.hasNext() && retrievedItem != ItemStack.f_41583_) {
                                Animal ae = (Animal)iae.next();
                                if (!ae.m_6898_(retrievedItem) || !ae.m_5957_() || ae.m_146764_() != 0) continue;
                                toEat = h.extractItem(a, 1, false);
                                ae.m_5584_(this.f_58857_, toEat);
                                ae.m_27595_(null);
                                iae.remove();
                            }
                        }
                        if (lae.isEmpty() && lpe.isEmpty()) break;
                    }
                });
            }
        }
    }

    public void m_142466_(CompoundTag tag) {
        CompoundTag invTag = tag.m_128469_("inv");
        this.handler.ifPresent(h -> ((INBTSerializable)h).deserializeNBT((Tag)invTag));
        super.m_142466_(tag);
    }

    public CompoundTag m_6945_(CompoundTag tag) {
        this.handler.ifPresent(h -> {
            CompoundTag compound = (CompoundTag)((INBTSerializable)h).serializeNBT();
            tag.m_128365_("inv", (Tag)compound);
        });
        return super.m_6945_(tag);
    }

    private IItemHandler createHandler() {
        return new ItemStackHandler((Integer)Config.PLATTER_SLOTS.get()){

            public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                return super.isItemValid(slot, stack);
            }

            @Nonnull
            public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
                if (!simulate) {
                    PlatterTile.this.f_58857_.m_7260_(PlatterTile.this.f_58858_, PlatterTile.this.m_58900_(), PlatterTile.this.m_58900_(), 2);
                    PlatterTile.this.m_6596_();
                }
                return super.insertItem(slot, stack, simulate);
            }

            @Nonnull
            public ItemStack extractItem(int slot, int amount, boolean simulate) {
                ItemStack toReturn = super.extractItem(slot, amount, simulate);
                if (this.getStackInSlot(slot).m_41619_()) {
                    return toReturn;
                }
                if (!simulate) {
                    if (this.getStackInSlot(slot).m_41613_() - amount <= 0) {
                        for (int a = slot; a < this.stacks.size() - 1; ++a) {
                            this.setStackInSlot(a, this.getStackInSlot(a + 1));
                        }
                    }
                    PlatterTile.this.f_58857_.m_7260_(PlatterTile.this.f_58858_, PlatterTile.this.m_58900_(), PlatterTile.this.m_58900_(), 2);
                    PlatterTile.this.m_6596_();
                }
                return toReturn;
            }
        };
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.handler.cast();
        }
        return super.getCapability(cap, side);
    }

    public ClientboundBlockEntityDataPacket m_7033_() {
        CompoundTag nbtTag = new CompoundTag();
        nbtTag = this.m_6945_(nbtTag);
        return new ClientboundBlockEntityDataPacket(this.m_58899_(), -1, nbtTag);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        CompoundTag tag = pkt.m_131708_();
        this.m_142466_(tag);
    }

    public CompoundTag m_5995_() {
        CompoundTag nbt = new CompoundTag();
        this.m_6945_(nbt);
        return nbt;
    }

    public void handleUpdateTag(CompoundTag tag) {
        this.m_142466_(tag);
    }
}

