/*
 * Decompiled with CFR 0.152.
 */
package com.abneyonline.platter.tile;

import com.abneyonline.platter.Config;
import com.abneyonline.platter.Registration;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class PlatterTile
extends TileEntity
implements ITickableTileEntity {
    private LazyOptional<IItemHandler> handler = LazyOptional.of(this::createHandler);
    private long tickCount = 0L;
    protected boolean tickForAnimals = true;

    public PlatterTile() {
        super((TileEntityType)Registration.oak_platter_tile.get());
    }

    public PlatterTile(TileEntityType tet) {
        super(tet);
    }

    public void func_73660_a() {
        if (!this.field_145850_b.func_201670_d() && !this.field_145850_b.func_175640_z(this.func_174877_v())) {
            ++this.tickCount;
            if (this.tickCount >= (long)((Integer)Config.PLATTER_PERIOD.get() * 20)) {
                this.tickCount = 0L;
                int radii = (Integer)Config.PLATTER_RADIUS.get();
                List pl = this.field_145850_b.func_217357_a(LivingEntity.class, new AxisAlignedBB(this.func_174877_v().func_177982_a(-radii, -radii, -radii), this.func_174877_v().func_177982_a(radii, radii, radii)));
                ArrayList<PlayerEntity> lpe = new ArrayList<PlayerEntity>();
                ArrayList<AnimalEntity> lae = new ArrayList<AnimalEntity>();
                for (LivingEntity p : pl) {
                    AnimalEntity ae;
                    if (p instanceof PlayerEntity) {
                        PlayerEntity pe = (PlayerEntity)p;
                        if (!pe.func_71043_e(false) || pe.func_184812_l_()) continue;
                        lpe.add(pe);
                        continue;
                    }
                    if (!(p instanceof AnimalEntity) || !this.tickForAnimals || !(ae = (AnimalEntity)p).func_204701_dC() || ae.func_70631_g_()) continue;
                    lae.add(ae);
                }
                this.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(h -> {
                    for (int a = h.getSlots() - 1; a >= 0; --a) {
                        ItemStack toEat;
                        ItemStack retrievedItem = h.getStackInSlot(a);
                        if (retrievedItem.func_222117_E() && !lpe.isEmpty()) {
                            Iterator ipe = lpe.iterator();
                            while (ipe.hasNext() && retrievedItem != ItemStack.field_190927_a) {
                                PlayerEntity toFeed = (PlayerEntity)ipe.next();
                                toEat = h.extractItem(a, 1, false);
                                toFeed.func_213357_a(this.field_145850_b, toEat);
                                ipe.remove();
                            }
                        }
                        if (!lae.isEmpty()) {
                            Iterator iae = lae.iterator();
                            while (iae.hasNext() && retrievedItem != ItemStack.field_190927_a) {
                                AnimalEntity ae = (AnimalEntity)iae.next();
                                if (!ae.func_70877_b(retrievedItem) || !ae.func_204701_dC() || ae.func_70874_b() != 0) continue;
                                toEat = h.extractItem(a, 1, false);
                                ae.func_213357_a(this.field_145850_b, toEat);
                                ae.func_146082_f(null);
                                iae.remove();
                            }
                        }
                        if (lae.isEmpty() && lpe.isEmpty()) break;
                    }
                });
            }
        }
    }

    public void func_230337_a_(BlockState b, CompoundNBT tag) {
        CompoundNBT invTag = tag.func_74775_l("inv");
        this.handler.ifPresent(h -> ((INBTSerializable)h).deserializeNBT((INBT)invTag));
        super.func_230337_a_(b, tag);
    }

    public CompoundNBT func_189515_b(CompoundNBT tag) {
        this.handler.ifPresent(h -> {
            CompoundNBT compound = (CompoundNBT)((INBTSerializable)h).serializeNBT();
            tag.func_218657_a("inv", (INBT)compound);
        });
        return super.func_189515_b(tag);
    }

    private IItemHandler createHandler() {
        return new ItemStackHandler((Integer)Config.PLATTER_SLOTS.get()){

            public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                return super.isItemValid(slot, stack);
            }

            @Nonnull
            public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
                if (!simulate) {
                    PlatterTile.this.field_145850_b.func_184138_a(PlatterTile.this.field_174879_c, PlatterTile.this.func_195044_w(), PlatterTile.this.func_195044_w(), 2);
                    PlatterTile.this.func_70296_d();
                }
                return super.insertItem(slot, stack, simulate);
            }

            @Nonnull
            public ItemStack extractItem(int slot, int amount, boolean simulate) {
                ItemStack toReturn = super.extractItem(slot, amount, simulate);
                if (this.getStackInSlot(slot).func_190926_b()) {
                    return toReturn;
                }
                if (!simulate) {
                    if (this.getStackInSlot(slot).func_190916_E() - amount <= 0) {
                        for (int a = slot; a < this.stacks.size() - 1; ++a) {
                            this.setStackInSlot(a, this.getStackInSlot(a + 1));
                        }
                    }
                    PlatterTile.this.field_145850_b.func_184138_a(PlatterTile.this.field_174879_c, PlatterTile.this.func_195044_w(), PlatterTile.this.func_195044_w(), 2);
                    PlatterTile.this.func_70296_d();
                }
                return toReturn;
            }
        };
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.handler.cast();
        }
        return super.getCapability(cap, side);
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        CompoundNBT nbtTag = new CompoundNBT();
        nbtTag = this.func_189515_b(nbtTag);
        return new SUpdateTileEntityPacket(this.func_174877_v(), -1, nbtTag);
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        CompoundNBT tag = pkt.func_148857_g();
        this.func_230337_a_(this.func_195044_w(), tag);
    }

    public CompoundNBT func_189517_E_() {
        CompoundNBT nbt = new CompoundNBT();
        this.func_189515_b(nbt);
        return nbt;
    }
}

