/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.insanelib.utils;

import insane96mcp.insanelib.utils.LogHelper;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.Tag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class IdTagMatcher {
    public ResourceLocation id;
    public ResourceLocation tag;
    public ResourceLocation dimension;
    public static final ResourceLocation AnyRL = new ResourceLocation("any");

    public IdTagMatcher(@Nullable ResourceLocation id, @Nullable ResourceLocation tag, ResourceLocation dimension) {
        if (id == null && tag == null) {
            throw new NullPointerException("'id' and 'tag' can't be both null");
        }
        this.id = id;
        this.tag = tag;
        this.dimension = dimension;
    }

    public IdTagMatcher(@Nullable ResourceLocation id, @Nullable ResourceLocation tag) {
        this(id, tag, AnyRL);
    }

    @Nullable
    public static IdTagMatcher parseLine(String line) {
        String[] split = line.split(",");
        if (split.length < 1 || split.length > 2) {
            LogHelper.warn("Invalid line \"%s\". Format must be modid:item_or_block_id,modid:dimension", line);
            return null;
        }
        ResourceLocation dimension = AnyRL;
        if (split.length == 2 && (dimension = ResourceLocation.m_135820_((String)split[1])) == null) {
            LogHelper.warn(String.format("Invalid dimension \"%s\". Ignoring it", split[1]), new Object[0]);
            dimension = AnyRL;
        }
        if (split[0].startsWith("#")) {
            String replaced = split[0].replace("#", "");
            ResourceLocation tag = ResourceLocation.m_135820_((String)replaced);
            if (tag == null) {
                LogHelper.warn("%s tag is not valid", replaced);
                return null;
            }
            return new IdTagMatcher(null, tag, dimension);
        }
        ResourceLocation id = ResourceLocation.m_135820_((String)split[0]);
        if (id == null) {
            LogHelper.warn("%s id is not valid", line);
            return null;
        }
        if (ForgeRegistries.BLOCKS.containsKey(id) || ForgeRegistries.ITEMS.containsKey(id) || ForgeRegistries.ENTITIES.containsKey(id)) {
            return new IdTagMatcher(id, null, dimension);
        }
        LogHelper.warn(String.format("%s id seems to not exist", line), new Object[0]);
        return null;
    }

    public static ArrayList<? extends IdTagMatcher> parseStringList(List<? extends String> list) {
        ArrayList<IdTagMatcher> commonTagBlock = new ArrayList<IdTagMatcher>();
        for (String string : list) {
            IdTagMatcher idTagMatcher = IdTagMatcher.parseLine(string);
            if (idTagMatcher == null) continue;
            commonTagBlock.add(idTagMatcher);
        }
        return commonTagBlock;
    }

    public boolean matchesFluid(Fluid fluid) {
        return this.matchesFluid(fluid, null);
    }

    public boolean matchesFluid(Fluid fluid, @Nullable ResourceLocation dimensionId) {
        if (dimensionId == null) {
            dimensionId = AnyRL;
        }
        if (this.tag != null) {
            if (!FluidTags.m_144299_().m_13406_().contains(this.tag)) {
                return false;
            }
            Tag fluidTag = FluidTags.m_144299_().m_13404_(this.tag);
            if (fluidTag == null) {
                return false;
            }
            if (!fluidTag.m_8110_((Object)fluid)) {
                return false;
            }
            if (this.dimension.equals((Object)AnyRL) || this.dimension.equals((Object)dimensionId)) {
                return true;
            }
        } else {
            ResourceLocation fluidId = fluid.getRegistryName();
            if (fluidId.equals((Object)this.id) && (this.dimension.equals((Object)AnyRL) || this.dimension.equals((Object)dimensionId))) {
                return true;
            }
        }
        return false;
    }

    public boolean matchesBlock(Block block) {
        return this.matchesBlock(block, null);
    }

    public boolean matchesBlock(Block block, @Nullable ResourceLocation dimensionId) {
        if (dimensionId == null) {
            dimensionId = AnyRL;
        }
        ResourceLocation blockId = block.getRegistryName();
        if (this.tag != null) {
            if (!BlockTags.m_13115_().m_13406_().contains(this.tag)) {
                return false;
            }
            Tag blockTag = BlockTags.m_13115_().m_13404_(this.tag);
            if (blockTag == null) {
                return false;
            }
            if (!blockTag.m_8110_((Object)block)) {
                return false;
            }
            if (this.dimension.equals((Object)AnyRL) || this.dimension.equals((Object)dimensionId)) {
                return true;
            }
        } else if (blockId.equals((Object)this.id) && (this.dimension.equals((Object)AnyRL) || this.dimension.equals((Object)dimensionId))) {
            return true;
        }
        return false;
    }

    public boolean matchesItem(Item item) {
        return this.matchesItem(item, null);
    }

    public boolean matchesItem(Item item, @Nullable ResourceLocation dimensionId) {
        if (dimensionId == null) {
            dimensionId = AnyRL;
        }
        ResourceLocation itemId = item.getRegistryName();
        if (this.tag != null) {
            if (!ItemTags.m_13193_().m_13406_().contains(this.tag)) {
                return false;
            }
            Tag itemTag = ItemTags.m_13193_().m_13404_(this.tag);
            if (itemTag == null) {
                return false;
            }
            if (!itemTag.m_8110_((Object)item)) {
                return false;
            }
            if (this.dimension.equals((Object)AnyRL) || this.dimension.equals((Object)dimensionId)) {
                return true;
            }
        } else if (itemId.equals((Object)this.id) && (this.dimension.equals((Object)AnyRL) || this.dimension.equals((Object)dimensionId))) {
            return true;
        }
        return false;
    }

    public boolean matchesEntity(Entity entity) {
        return this.matchesEntity(entity.m_6095_(), null);
    }

    public boolean matchesEntity(Entity entity, @Nullable ResourceLocation dimensionId) {
        return this.matchesEntity(entity.m_6095_(), dimensionId);
    }

    public boolean matchesEntity(EntityType<?> entityType) {
        return this.matchesEntity(entityType, null);
    }

    public boolean matchesEntity(EntityType<?> entityType, @Nullable ResourceLocation dimensionId) {
        if (dimensionId == null) {
            dimensionId = AnyRL;
        }
        ResourceLocation entityId = entityType.getRegistryName();
        if (this.tag != null) {
            if (!EntityTypeTags.m_13126_().m_13406_().contains(this.tag)) {
                return false;
            }
            Tag entityTypeTag = EntityTypeTags.m_13126_().m_13404_(this.tag);
            if (entityTypeTag == null) {
                return false;
            }
            if (!entityTypeTag.m_8110_(entityType)) {
                return false;
            }
            if (this.dimension.equals((Object)AnyRL) || this.dimension.equals((Object)dimensionId)) {
                return true;
            }
        } else if (entityId.equals((Object)this.id) && (this.dimension.equals((Object)AnyRL) || this.dimension.equals((Object)dimensionId))) {
            return true;
        }
        return false;
    }

    public boolean matchesGeneric(ForgeRegistryEntry entry) {
        return this.matchesGeneric(entry, null);
    }

    public boolean matchesGeneric(ForgeRegistryEntry entry, @Nullable ResourceLocation dimensionId) {
        ResourceLocation itemId;
        if (dimensionId == null) {
            dimensionId = AnyRL;
        }
        if ((itemId = entry.getRegistryName()).equals((Object)this.id)) {
            return this.dimension.equals((Object)AnyRL) || this.dimension.equals((Object)dimensionId);
        }
        return false;
    }

    public List<Block> getAllBlocks() {
        ArrayList<Block> blocks = new ArrayList<Block>();
        if (this.id != null) {
            Block block = (Block)ForgeRegistries.BLOCKS.getValue(this.id);
            if (block != null) {
                blocks.add(block);
            }
        } else {
            Tag blockTag = BlockTags.m_13115_().m_13404_(this.tag);
            if (blockTag != null) {
                blocks.addAll(blockTag.m_6497_());
            }
        }
        return blocks;
    }

    public List<Item> getAllItems() {
        ArrayList<Item> items = new ArrayList<Item>();
        if (this.id != null) {
            Item item = (Item)ForgeRegistries.ITEMS.getValue(this.id);
            if (item != null) {
                items.add(item);
            }
        } else {
            Tag itemTag = ItemTags.m_13193_().m_13404_(this.tag);
            if (itemTag != null) {
                items.addAll(itemTag.m_6497_());
            }
        }
        return items;
    }
}

