/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.progressivebosses.classutils;

import insane96mcp.insanelib.utils.LogHelper;
import insane96mcp.insanelib.utils.RandomHelper;
import insane96mcp.progressivebosses.setup.PBItems;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.math.NumberUtils;

public class Drop {
    public ResourceLocation itemId;
    public int amount;
    public int difficultyRequired;
    public double chance;
    public DifficultyMode difficultyMode;
    public ChanceMode chanceMode;

    public Drop(ResourceLocation itemId, int amount, int difficultyRequired, double chance, DifficultyMode difficultyMode, ChanceMode chanceMode) {
        this.itemId = itemId;
        this.amount = amount;
        this.difficultyRequired = difficultyRequired;
        this.chance = chance;
        this.difficultyMode = difficultyMode;
        this.chanceMode = chanceMode;
    }

    @Nullable
    public static Drop parseLine(String line) {
        ChanceMode chanceMode;
        DifficultyMode difficultyMode;
        String[] split = line.split(",");
        if (split.length != 6) {
            LogHelper.warn((String)"Invalid line \"%s\" for Drop", (Object[])new Object[]{line});
            return null;
        }
        ResourceLocation item = ResourceLocation.m_135820_((String)split[0]);
        if (item == null) {
            LogHelper.warn((String)"%s item for Drop is not a valid Resource Location", (Object[])new Object[]{split[0]});
            return null;
        }
        if (!ForgeRegistries.ITEMS.containsKey(item)) {
            LogHelper.warn((String)"%s item for Drop seems to not exist", (Object[])new Object[]{split[0]});
            return null;
        }
        if (!NumberUtils.isParsable((String)split[1])) {
            LogHelper.warn((String)String.format("Invalid amount \"%s\" for Drop", line), (Object[])new Object[0]);
            return null;
        }
        int amount = Integer.parseInt(split[1]);
        if (!NumberUtils.isParsable((String)split[2])) {
            LogHelper.warn((String)String.format("Invalid difficulty_required \"%s\" for Drop", line), (Object[])new Object[0]);
            return null;
        }
        int difficultyRequired = Integer.parseInt(split[2]);
        if (!NumberUtils.isParsable((String)split[3])) {
            LogHelper.warn((String)String.format("Invalid chance \"%s\" for Drop", line), (Object[])new Object[0]);
            return null;
        }
        double chance = Double.parseDouble(split[3]);
        try {
            difficultyMode = DifficultyMode.valueOf(split[4]);
        }
        catch (IllegalArgumentException e) {
            LogHelper.warn((String)String.format("Invalid difficulty_mode \"%s\" for Drop", line), (Object[])new Object[0]);
            return null;
        }
        try {
            chanceMode = ChanceMode.valueOf(split[5]);
        }
        catch (IllegalArgumentException e) {
            LogHelper.warn((String)String.format("Invalid chance_mode \"%s\" for Drop", line), (Object[])new Object[0]);
            return null;
        }
        return new Drop(item, amount, difficultyRequired, chance, difficultyMode, chanceMode);
    }

    public static ArrayList<Drop> parseDropsList(List<? extends String> list) {
        ArrayList<Drop> drops = new ArrayList<Drop>();
        for (String string : list) {
            Drop drop = Drop.parseLine(string);
            if (drop == null) continue;
            drops.add(drop);
        }
        return drops;
    }

    public void drop(Level world, Vec3 pos, float difficulty) {
        if (this.amount == 0) {
            return;
        }
        if (difficulty < (float)this.difficultyRequired) {
            return;
        }
        double chance = this.chance;
        if (difficulty >= (float)this.difficultyRequired && this.chanceMode == ChanceMode.SCALING) {
            chance *= (double)(difficulty - (float)this.difficultyRequired + 1.0f);
        }
        if (this.difficultyMode == DifficultyMode.MINIMUM) {
            if (RandomHelper.getDouble((Random)world.f_46441_, (double)0.0, (double)1.0) >= chance) {
                return;
            }
            world.m_7967_((Entity)Drop.createDrop(world, pos, (Item)ForgeRegistries.ITEMS.getValue(this.itemId), this.amount));
        } else if (this.difficultyMode == DifficultyMode.PER_DIFFICULTY) {
            int tries = (int)(difficulty - (float)this.difficultyRequired + 1.0f);
            if (tries == 0) {
                return;
            }
            int dropped = 0;
            for (int i = 0; i < tries; ++i) {
                if (RandomHelper.getDouble((Random)world.f_46441_, (double)0.0, (double)1.0) >= chance) continue;
                ++dropped;
                world.m_7967_((Entity)Drop.createDrop(world, pos, (Item)ForgeRegistries.ITEMS.getValue(this.itemId), this.amount));
            }
            if (this.itemId.equals((Object)PBItems.NETHER_STAR_SHARD.getId()) && (double)dropped < (double)difficulty * chance) {
                world.m_7967_((Entity)Drop.createDrop(world, pos, (Item)ForgeRegistries.ITEMS.getValue(this.itemId), (int)Math.round((double)difficulty * chance - (double)dropped)));
            }
        }
    }

    private static ItemEntity createDrop(Level world, Vec3 pos, Item item, int amount) {
        ItemEntity itemEntity = new ItemEntity(world, pos.f_82479_, pos.f_82480_, pos.f_82481_, new ItemStack((ItemLike)item, amount));
        if (item.getRegistryName().equals((Object)((Item)PBItems.NETHER_STAR_SHARD.get()).getRegistryName())) {
            CompoundTag compoundNBT = new CompoundTag();
            itemEntity.m_7380_(compoundNBT);
            compoundNBT.m_128376_("Health", (short)Short.MAX_VALUE);
            itemEntity.m_7378_(compoundNBT);
        }
        return itemEntity;
    }

    public static enum DifficultyMode {
        MINIMUM,
        PER_DIFFICULTY;

    }

    public static enum ChanceMode {
        FLAT,
        SCALING;

    }
}

