/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.progressivebosses.module.dragon.feature;

import insane96mcp.insanelib.base.Feature;
import insane96mcp.insanelib.base.Label;
import insane96mcp.insanelib.base.Module;
import insane96mcp.insanelib.utils.MCUtils;
import insane96mcp.progressivebosses.setup.Config;
import insane96mcp.progressivebosses.setup.Strings;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.boss.enderdragon.phases.EnderDragonPhase;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@Label(name="Health", description="Bonus Health and Bonus regeneration.")
public class HealthFeature
extends Feature {
    private final ForgeConfigSpec.ConfigValue<Double> bonusPerDifficultyConfig;
    private final ForgeConfigSpec.ConfigValue<Double> maximumBonusRegenConfig;
    private final ForgeConfigSpec.ConfigValue<Double> bonusRegenPerDifficultyConfig;
    private final ForgeConfigSpec.ConfigValue<Double> bonusCrystalRegenConfig;
    public double bonusPerDifficulty = 30.0;
    public double maxBonusRegen = 1.0;
    public double bonusRegenPerDifficulty = 0.125;
    public double bonusCrystalRegen = 0.0;

    public HealthFeature(Module module) {
        super(Config.builder, module);
        this.pushConfig(Config.builder);
        this.bonusPerDifficultyConfig = Config.builder.comment("Increase Ender Dragon's Health by this value per difficulty").defineInRange("Health Bonus per Difficulty", this.bonusPerDifficulty, 0.0, Double.MAX_VALUE);
        this.maximumBonusRegenConfig = Config.builder.comment("Maximum bonus regeneration per second given by \"Bonus Regeneration per Difficulty\". Set to 0 to disable bonus health regeneration. This doesn't affect the crystal regeneration of the Ender Dragon.").defineInRange("Maximum Bonus Regeneration", this.maxBonusRegen, 0.0, Double.MAX_VALUE);
        this.bonusRegenPerDifficultyConfig = Config.builder.comment("How much health will the Ender Dragon regen per difficulty. This is added to the noaml Crystal regeneration.").defineInRange("Bonus Regeneration per Difficulty", this.bonusRegenPerDifficulty, 0.0, Double.MAX_VALUE);
        this.bonusCrystalRegenConfig = Config.builder.comment("How much health (when missing 100% health) will the Ender Dragon regen per difficulty each second whenever she's attached to a Crystal. So if she's missing 30% health, this will be 30% effective. This is added to the normal Crystal regen.").defineInRange("Bonus Crystal Regeneration", this.bonusCrystalRegen, 0.0, Double.MAX_VALUE);
        Config.builder.pop();
    }

    public void loadConfig() {
        super.loadConfig();
        this.bonusPerDifficulty = (Double)this.bonusPerDifficultyConfig.get();
        this.maxBonusRegen = (Double)this.maximumBonusRegenConfig.get();
        this.bonusRegenPerDifficulty = (Double)this.bonusRegenPerDifficultyConfig.get();
        this.bonusCrystalRegen = (Double)this.bonusCrystalRegenConfig.get();
    }

    @SubscribeEvent
    public void onSpawn(EntityJoinWorldEvent event) {
        if (event.getWorld().f_46443_) {
            return;
        }
        if (!this.isEnabled()) {
            return;
        }
        if (this.bonusPerDifficulty == 0.0) {
            return;
        }
        Entity entity = event.getEntity();
        if (!(entity instanceof EnderDragon)) {
            return;
        }
        EnderDragon enderDragon = (EnderDragon)entity;
        if (enderDragon.m_21051_(Attributes.f_22276_).m_22111_(Strings.AttributeModifiers.BONUS_HEALTH_UUID) != null) {
            return;
        }
        CompoundTag dragonTags = enderDragon.getPersistentData();
        double difficulty = dragonTags.m_128457_("progressivebosses:difficulty");
        MCUtils.applyModifier((LivingEntity)enderDragon, (Attribute)Attributes.f_22276_, (UUID)Strings.AttributeModifiers.BONUS_HEALTH_UUID, (String)"progressivebosses:bonus_health", (double)(difficulty * this.bonusPerDifficulty), (AttributeModifier.Operation)AttributeModifier.Operation.ADDITION);
    }

    @SubscribeEvent
    public void onUpdate(LivingEvent.LivingUpdateEvent event) {
        float crystalBonusHeal;
        if (event.getEntity().f_19853_.f_46443_) {
            return;
        }
        if (!this.isEnabled()) {
            return;
        }
        Entity entity = event.getEntity();
        if (!(entity instanceof EnderDragon)) {
            return;
        }
        EnderDragon enderDragon = (EnderDragon)entity;
        if (!enderDragon.m_6084_() || enderDragon.m_31157_().m_31415_().m_7309_() == EnderDragonPhase.f_31386_) {
            return;
        }
        CompoundTag tags = enderDragon.getPersistentData();
        float difficulty = tags.m_128457_("progressivebosses:difficulty");
        if (difficulty <= 0.0f) {
            return;
        }
        float flatBonusHeal = this.getFlatBonusHeal(difficulty);
        float heal = flatBonusHeal + (crystalBonusHeal = this.getCrystalBonusHeal(enderDragon, difficulty));
        if (heal == 0.0f) {
            return;
        }
        enderDragon.m_5634_(heal /= 20.0f);
    }

    private float getFlatBonusHeal(float difficulty) {
        if (this.bonusRegenPerDifficulty == 0.0 || this.maxBonusRegen == 0.0) {
            return 0.0f;
        }
        return (float)Math.min((double)difficulty * this.bonusRegenPerDifficulty, this.maxBonusRegen);
    }

    private float getCrystalBonusHeal(EnderDragon enderDragon, float difficulty) {
        if (this.bonusCrystalRegen == 0.0) {
            return 0.0f;
        }
        if (enderDragon.f_31086_ == null || !enderDragon.f_31086_.m_6084_()) {
            return 0.0f;
        }
        double currHealthPerc = 1.0f - enderDragon.m_21223_() / enderDragon.m_21233_();
        return (float)(this.bonusCrystalRegen * (double)difficulty * currHealthPerc);
    }
}

