/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.progressivebosses.module.dragon.feature;

import insane96mcp.insanelib.base.Feature;
import insane96mcp.insanelib.base.Label;
import insane96mcp.insanelib.base.Module;
import insane96mcp.insanelib.utils.MCUtils;
import insane96mcp.insanelib.utils.RandomHelper;
import insane96mcp.progressivebosses.module.dragon.ai.DragonMinionAttackGoal;
import insane96mcp.progressivebosses.module.dragon.ai.PBNearestAttackableTargetGoal;
import insane96mcp.progressivebosses.setup.Config;
import insane96mcp.progressivebosses.setup.Strings;
import insane96mcp.progressivebosses.utils.DragonMinionHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.GoalSelector;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.monster.Shulker;
import net.minecraft.world.entity.projectile.ShulkerBullet;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.EndPodiumFeature;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@Label(name="Minions", description="Shulkers that will make you float around.")
public class MinionFeature
extends Feature {
    private final ForgeConfigSpec.ConfigValue<Integer> minionAtDifficultyConfig;
    private final ForgeConfigSpec.ConfigValue<Integer> minCooldownConfig;
    private final ForgeConfigSpec.ConfigValue<Integer> maxCooldownConfig;
    private final ForgeConfigSpec.ConfigValue<Double> cooldownReductionConfig;
    private final ForgeConfigSpec.ConfigValue<Double> blindingChanceConfig;
    private final ForgeConfigSpec.ConfigValue<Integer> blindingDurationConfig;
    private final ForgeConfigSpec.ConfigValue<Boolean> reducedDragonDamageConfig;
    public int minionAtDifficulty = 1;
    public int minCooldown = 1400;
    public int maxCooldown = 2000;
    public double cooldownReduction = 0.05;
    public double blindingChance = 0.04;
    public int blindingDuration = 150;
    public boolean reducedDragonDamage = true;

    public MinionFeature(Module module) {
        super(Config.builder, module);
        this.pushConfig(Config.builder);
        this.minionAtDifficultyConfig = Config.builder.comment("At which difficulty the Ender Dragon starts spawning Minions").defineInRange("Minion at Difficulty", this.minionAtDifficulty, 0, Integer.MAX_VALUE);
        this.minCooldownConfig = Config.builder.comment("Minimum ticks (20 ticks = 1 seconds) after Minions can spwan.").defineInRange("Minimum Cooldown", this.minCooldown, 0, Integer.MAX_VALUE);
        this.maxCooldownConfig = Config.builder.comment("Maximum ticks (20 ticks = 1 seconds) after Minions can spwan.").defineInRange("Maximum Cooldown", this.maxCooldown, 0, Integer.MAX_VALUE);
        this.cooldownReductionConfig = Config.builder.comment("Percentage cooldown reduction per difficulty for the cooldown of Minion spawning.").defineInRange("Cooldown Reduction", this.cooldownReduction, 0.0, 1.0);
        this.blindingChanceConfig = Config.builder.comment("Percentage chance per difficulty for a Minion to spawn as a Blinding Minion.").defineInRange("Blinding Chance", this.blindingChance, 0.0, 1.0);
        this.blindingDurationConfig = Config.builder.comment("Time (in ticks) for the bliding effect when hit by a blinding bullet.").defineInRange("Blinding duration", this.blindingDuration, 0, 6000);
        this.reducedDragonDamageConfig = Config.builder.comment("If true, Dragon Minions will take only 10% damage from the Ender Dragon.").define("Reduced Dragon Damage", this.reducedDragonDamage);
        Config.builder.pop();
    }

    public void loadConfig() {
        super.loadConfig();
        this.minionAtDifficulty = (Integer)this.minionAtDifficultyConfig.get();
        this.minCooldown = (Integer)this.minCooldownConfig.get();
        this.maxCooldown = (Integer)this.maxCooldownConfig.get();
        if (this.minCooldown > this.maxCooldown) {
            this.minCooldown = this.maxCooldown;
        }
        this.cooldownReduction = (Double)this.cooldownReductionConfig.get();
        this.blindingChance = (Double)this.blindingChanceConfig.get();
        this.blindingDuration = (Integer)this.blindingDurationConfig.get();
        this.reducedDragonDamage = (Boolean)this.reducedDragonDamageConfig.get();
    }

    @SubscribeEvent
    public void onDragonSpawn(EntityJoinWorldEvent event) {
        if (event.getWorld().f_46443_) {
            return;
        }
        if (!this.isEnabled()) {
            return;
        }
        Entity entity = event.getEntity();
        if (!(entity instanceof EnderDragon)) {
            return;
        }
        EnderDragon dragon = (EnderDragon)entity;
        CompoundTag dragonTags = dragon.getPersistentData();
        int cooldown = (int)((double)RandomHelper.getInt((Random)dragon.m_21187_(), (int)this.minCooldown, (int)this.maxCooldown) * 0.5);
        dragonTags.m_128405_("progressivebosses:dragon_minion_cooldown", cooldown);
    }

    @SubscribeEvent
    public void onShulkerSpawn(EntityJoinWorldEvent event) {
        if (event.getWorld().f_46443_) {
            return;
        }
        if (!this.isEnabled()) {
            return;
        }
        Entity entity = event.getEntity();
        if (!(entity instanceof Shulker)) {
            return;
        }
        Shulker shulker = (Shulker)entity;
        CompoundTag tags = shulker.getPersistentData();
        if (!tags.m_128441_("progressivebosses:dragon_minion")) {
            return;
        }
        MinionFeature.setMinionAI(shulker);
    }

    @SubscribeEvent
    public void update(LivingEvent.LivingUpdateEvent event) {
        if (event.getEntity().f_19853_.f_46443_) {
            return;
        }
        if (!this.isEnabled()) {
            return;
        }
        Entity entity = event.getEntity();
        if (!(entity instanceof EnderDragon)) {
            return;
        }
        EnderDragon dragon = (EnderDragon)entity;
        Level world = event.getEntity().f_19853_;
        CompoundTag dragonTags = dragon.getPersistentData();
        float difficulty = dragonTags.m_128457_("progressivebosses:difficulty");
        if (difficulty < (float)this.minionAtDifficulty) {
            return;
        }
        if (dragon.m_21223_() <= 0.0f) {
            return;
        }
        int cooldown = dragonTags.m_128451_("progressivebosses:dragon_minion_cooldown");
        if (cooldown > 0) {
            dragonTags.m_128405_("progressivebosses:dragon_minion_cooldown", cooldown - 1);
            return;
        }
        BlockPos centerPodium = dragon.f_19853_.m_5452_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, EndPodiumFeature.f_65714_);
        AABB bb = new AABB(centerPodium).m_82400_(64.0);
        List players = world.m_45976_(ServerPlayer.class, bb);
        if (players.isEmpty()) {
            return;
        }
        int minCooldown = this.minCooldown;
        int maxCooldown = this.maxCooldown;
        cooldown = RandomHelper.getInt((Random)world.f_46441_, (int)minCooldown, (int)maxCooldown);
        cooldown = (int)((double)cooldown * (1.0 - this.cooldownReduction * (double)difficulty));
        dragonTags.m_128405_("progressivebosses:dragon_minion_cooldown", cooldown - 1);
        float angle = world.f_46441_.nextFloat() * (float)Math.PI * 2.0f;
        float x = (float)(Math.cos(angle) * (double)RandomHelper.getFloat((Random)dragon.m_21187_(), (float)16.0f, (float)45.0f));
        float z = (float)(Math.sin(angle) * (double)RandomHelper.getFloat((Random)dragon.m_21187_(), (float)16.0f, (float)45.0f));
        float y = world.m_5452_(Heightmap.Types.MOTION_BLOCKING, new BlockPos((double)x, 255.0, (double)z)).m_123342_();
        Shulker shulker = this.summonMinion(world, new Vec3((double)x, (double)y, (double)z), difficulty);
    }

    private static void setMinionAI(Shulker shulker) {
        ArrayList<Goal> toRemove = new ArrayList<Goal>();
        shulker.f_21345_.f_25345_.forEach(goal -> {
            if (goal.m_26015_() instanceof Shulker.ShulkerAttackGoal) {
                toRemove.add(goal.m_26015_());
            }
        });
        toRemove.forEach(arg_0 -> ((GoalSelector)shulker.f_21345_).m_25363_(arg_0));
        shulker.f_21345_.m_25352_(2, (Goal)new DragonMinionAttackGoal(shulker, 70));
        toRemove.clear();
        shulker.f_21346_.f_25345_.forEach(goal -> {
            if (goal.m_26015_() instanceof NearestAttackableTargetGoal) {
                toRemove.add(goal.m_26015_());
            }
            if (goal.m_26015_() instanceof HurtByTargetGoal) {
                toRemove.add(goal.m_26015_());
            }
        });
        toRemove.forEach(arg_0 -> ((GoalSelector)shulker.f_21346_).m_25363_(arg_0));
        shulker.f_21346_.m_25352_(2, (Goal)new PBNearestAttackableTargetGoal((Mob)shulker));
        shulker.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)shulker, new Class[]{Shulker.class, EnderDragon.class}));
    }

    public Shulker summonMinion(Level world, Vec3 pos, float difficulty) {
        Shulker shulker = new Shulker(EntityType.f_20521_, world);
        CompoundTag minionTags = shulker.getPersistentData();
        minionTags.m_128379_("progressivebosses:dragon_minion", true);
        minionTags.m_128379_("mobspropertiesrandomness:processed", true);
        boolean isBlindingMinion = world.m_5822_().nextDouble() < this.blindingChance * (double)difficulty;
        shulker.m_6034_(pos.f_82479_, pos.f_82480_, pos.f_82481_);
        shulker.m_6593_((Component)new TranslatableComponent("progressivebosses:dragon_minion"));
        shulker.f_21355_ = BuiltInLootTables.f_78712_;
        shulker.m_21530_();
        DragonMinionHelper.setMinionColor(shulker, isBlindingMinion);
        MCUtils.applyModifier((LivingEntity)shulker, (Attribute)Attributes.f_22277_, (UUID)Strings.AttributeModifiers.FOLLOW_RANGE_BONUS_UUID, (String)"progressivebosses:follow_range_bonus", (double)64.0, (AttributeModifier.Operation)AttributeModifier.Operation.ADDITION);
        world.m_7967_((Entity)shulker);
        return shulker;
    }

    @SubscribeEvent
    public void onMinionHurt(LivingHurtEvent event) {
        if (!this.isEnabled()) {
            return;
        }
        if (!this.reducedDragonDamage) {
            return;
        }
        Entity entity = event.getEntity();
        if (!(entity instanceof Shulker)) {
            return;
        }
        Shulker shulker = (Shulker)entity;
        CompoundTag compoundNBT = shulker.getPersistentData();
        if (!compoundNBT.m_128441_("progressivebosses:dragon_minion")) {
            return;
        }
        if (event.getSource().m_7639_() instanceof EnderDragon) {
            event.setAmount(event.getAmount() * 0.1f);
        }
    }

    public void onBulletTick(ShulkerBullet shulkerBulletEntity) {
        if (!shulkerBulletEntity.f_19853_.f_46443_ && shulkerBulletEntity.getPersistentData().m_128471_("progressivebosses:blindness_bullet")) {
            ((ServerLevel)shulkerBulletEntity.f_19853_).m_8767_((ParticleOptions)ParticleTypes.f_123811_, shulkerBulletEntity.m_20185_(), shulkerBulletEntity.m_20186_(), shulkerBulletEntity.m_20189_(), 1, 0.0, 0.0, 0.0, 0.0);
        }
    }
}

