/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.progressivebosses.module.elderguardian.feature;

import insane96mcp.insanelib.base.Feature;
import insane96mcp.insanelib.base.Label;
import insane96mcp.insanelib.base.Module;
import insane96mcp.progressivebosses.setup.Config;
import net.minecraft.Util;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundGameEventPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.monster.ElderGuardian;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.GameType;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.world.ExplosionEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@Label(name="Base", description="Base feature for the Elder Guardian harder fights. Disabling this feature will disable the added sound when an Elder Guardian is killed.")
public class BaseFeature
extends Feature {
    private final ForgeConfigSpec.ConfigValue<Boolean> adventureConfig;
    public boolean adventure = true;

    public BaseFeature(Module module) {
        super(Config.builder, module);
        this.pushConfig(Config.builder);
        this.adventureConfig = Config.builder.comment("If true, the player will not be able to break blocks when an Elder Guardian is nearby.").define("Adventure mode", this.adventure);
        Config.builder.pop();
    }

    public void loadConfig() {
        super.loadConfig();
        this.adventure = (Boolean)this.adventureConfig.get();
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.player.f_19853_.f_46443_) {
            return;
        }
        if (!this.isEnabled()) {
            return;
        }
        if (!this.adventure) {
            return;
        }
        if (event.player.f_19797_ % 20 != 0) {
            return;
        }
        if (!event.player.m_6084_()) {
            return;
        }
        ServerPlayer serverPlayer = (ServerPlayer)event.player;
        ServerLevel world = (ServerLevel)serverPlayer.f_19853_;
        CompoundTag nbt = serverPlayer.getPersistentData();
        boolean previouslyNearElderGuardian = nbt.m_128471_("progressivebosses:previously_near_elder_guardian");
        boolean adventureMessage = nbt.m_128471_("progressivebosses:adventure_message");
        boolean nearElderGuardian = !world.m_6443_(ElderGuardian.class, serverPlayer.m_142469_().m_82400_(32.0), entity -> true).isEmpty();
        nbt.m_128379_("progressivebosses:previously_near_elder_guardian", nearElderGuardian);
        if (serverPlayer.f_8941_.m_9290_() == GameType.SURVIVAL && nearElderGuardian) {
            serverPlayer.f_8941_.m_143473_(GameType.ADVENTURE);
            serverPlayer.f_8906_.m_141995_((Packet)new ClientboundGameEventPacket(ClientboundGameEventPacket.f_132156_, (float)GameType.ADVENTURE.m_46392_()));
            if (!adventureMessage) {
                serverPlayer.m_6352_((Component)new TranslatableComponent("elder_guardian.approach"), Util.f_137441_);
                nbt.m_128379_("progressivebosses:adventure_message", true);
            }
        } else if (serverPlayer.f_8941_.m_9290_() == GameType.ADVENTURE && !nearElderGuardian && previouslyNearElderGuardian) {
            serverPlayer.f_8941_.m_143473_(GameType.SURVIVAL);
            serverPlayer.f_8906_.m_141995_((Packet)new ClientboundGameEventPacket(ClientboundGameEventPacket.f_132156_, (float)GameType.SURVIVAL.m_46392_()));
        }
    }

    @SubscribeEvent
    public void onPlayerDeath(LivingDeathEvent event) {
        if (!this.isEnabled()) {
            return;
        }
        if (!this.adventure) {
            return;
        }
        if (!(event.getEntity() instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer serverPlayer = (ServerPlayer)event.getEntity();
        CompoundTag nbt = serverPlayer.getPersistentData();
        boolean previouslyNearElderGuardian = nbt.m_128471_("progressivebosses:previously_near_elder_guardian");
        if (previouslyNearElderGuardian && serverPlayer.f_8941_.m_9290_() == GameType.ADVENTURE) {
            serverPlayer.f_8941_.m_143473_(GameType.SURVIVAL);
            serverPlayer.f_8906_.m_141995_((Packet)new ClientboundGameEventPacket(ClientboundGameEventPacket.f_132156_, (float)GameType.SURVIVAL.m_46392_()));
        }
    }

    @SubscribeEvent
    public void onExplosionDetonate(ExplosionEvent.Start event) {
        boolean nearElderGuardian;
        if (!this.isEnabled()) {
            return;
        }
        if (!this.adventure) {
            return;
        }
        if (event.getExplosion().getExploder() == null) {
            return;
        }
        if (event.getExplosion().f_46010_ == Explosion.BlockInteraction.NONE) {
            return;
        }
        boolean bl = nearElderGuardian = !event.getWorld().m_45976_(ElderGuardian.class, event.getExplosion().getExploder().m_142469_().m_82400_(32.0)).isEmpty();
        if (nearElderGuardian) {
            event.setCanceled(true);
            event.getWorld().m_46518_(event.getExplosion().getExploder(), event.getExplosion().getPosition().f_82479_, event.getExplosion().getPosition().f_82480_, event.getExplosion().getPosition().f_82481_, event.getExplosion().f_46017_, event.getExplosion().f_46009_, Explosion.BlockInteraction.NONE);
        }
    }

    @SubscribeEvent
    public void onElderGuardianDeath(LivingDeathEvent event) {
        if (!this.isEnabled()) {
            return;
        }
        if (!(event.getEntity() instanceof ElderGuardian)) {
            return;
        }
        ElderGuardian elderGuardian = (ElderGuardian)event.getEntity();
        int elderGuardiansNearby = elderGuardian.f_19853_.m_6249_((Entity)elderGuardian, elderGuardian.m_142469_().m_82400_(48.0), entity -> entity instanceof ElderGuardian).size();
        if (elderGuardiansNearby == 0) {
            return;
        }
        elderGuardian.m_5496_(SoundEvents.f_11880_, 2.0f, 0.5f);
    }

    public static int getDeadElderGuardians(ElderGuardian elderGuardian) {
        int elderGuardiansNearby = elderGuardian.f_19853_.m_6249_((Entity)elderGuardian, elderGuardian.m_142469_().m_82400_(48.0), entity -> entity instanceof ElderGuardian).size();
        return 2 - elderGuardiansNearby;
    }
}

